/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.cv.application.Interpolator;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGrid {
    private static final Logger logger = LoggerFactory.getLogger(MeshGrid.class);
    private Size kSize;
    protected List<Point> points = new ArrayList<Point>();
    protected Map<Key, Point[]> mesh = new HashMap<Key, Point[]>();
    private Interpolator interpolator;
    public double deltaX;
    public double deltaY;
    protected int xBorder;
    protected int yBorder;
    protected Mat image;
    private int nbIter;

    public MeshGrid(Mat image, int xBorder, int yBorder) {
        this.xBorder = xBorder;
        this.yBorder = yBorder;
        this.image = new Mat();
        Core.copyMakeBorder((Mat)image, (Mat)this.image, (int)yBorder, (int)yBorder, (int)xBorder, (int)xBorder, (int)1);
    }

    public MeshGrid(Size kSize, Interpolator interpolator, double deltaX, double deltaY, Mat image) {
        this.kSize = kSize;
        this.interpolator = interpolator;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.image = new Mat();
        this.xBorder = 2 * (int)deltaX;
        this.yBorder = 2 * (int)deltaY;
        Core.copyMakeBorder((Mat)image, (Mat)this.image, (int)this.yBorder, (int)this.yBorder, (int)this.xBorder, (int)this.xBorder, (int)1);
        this.nbIter = (int)Math.round(deltaY);
    }

    private Size getOldSize() {
        return new Size((double)(this.image.width() - 2 * this.xBorder), (double)(this.image.height() - 2 * this.yBorder));
    }

    public void build() {
        int j;
        Point imgCenter = new Point((double)(this.image.width() / 2), (double)(this.image.height() / 2));
        this.addFirstPoly(imgCenter);
        int i = 0;
        while ((double)i <= this.kSize.height) {
            for (j = 0; j <= (int)this.kSize.width; ++j) {
                if (i == 0 && j == 0) continue;
                this.addPolygon(i, j);
            }
            for (j = -1; j > -((int)this.kSize.width); --j) {
                this.addPolygon(i, j);
            }
            ++i;
        }
        i = -1;
        while ((double)i > -this.kSize.height) {
            for (j = 0; j <= (int)this.kSize.width; ++j) {
                this.addPolygon(i, j);
            }
            for (j = -1; j > -((int)this.kSize.width); --j) {
                this.addPolygon(i, j);
            }
            --i;
        }
    }

    public Mat drawOnCopy(Scalar color) {
        Mat clone = this.image.clone();
        this.mesh.values().forEach(p -> this.drawPolygon(clone, (Point[])p, color));
        return clone;
    }

    private boolean inImageBorders(Point[] p) {
        for (Point pt : p) {
            if (this.inImageBorders(pt)) continue;
            return false;
        }
        return true;
    }

    private boolean inImageBorders(Point p) {
        return p.x >= 0.0 && p.x < (double)this.image.width() && p.y >= 0.0 && p.y < (double)this.image.height();
    }

    public Mat dewarp() {
        int rectHeight = (int)Math.floor(this.getOldSize().height / (2.0 * this.kSize.height));
        int rectWidth = (int)Math.floor(this.getOldSize().width / (2.0 * this.kSize.width));
        Mat dewarpedImage = new Mat(this.getOldSize(), CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
        int i = (int)(-this.kSize.height) + 1;
        while ((double)i <= this.kSize.height) {
            int j = (int)(-this.kSize.width) + 1;
            while ((double)j <= this.kSize.width) {
                if (this.inImageBorders(this.mesh.get(new Key(i, j)))) {
                    Rect subImageRect = this.subImageRect(i, j);
                    Mat homography = this.dewarpPolygon(this.mesh.get(new Key(i, j)), subImageRect, rectHeight, rectWidth);
                    int x = (j + (int)this.kSize.width - 1) * rectWidth;
                    int y = (i + (int)this.kSize.height - 1) * rectHeight;
                    assert (x >= 0 && y >= 0 && x + rectWidth <= dewarpedImage.width() && y + rectHeight <= dewarpedImage.height()) : "x: " + x + ", y: " + y + ", width: " + this.image.width() + ", height: " + this.image.height() + " , rectWidth : " + rectWidth + " , rectHeight : " + rectHeight;
                    Mat subDewarpedImage = new Mat(dewarpedImage, new Rect(new Point((double)x, (double)y), new Point((double)(x + rectWidth), (double)(y + rectHeight))));
                    Mat subImage = new Mat(this.image, subImageRect);
                    Imgproc.warpPerspective((Mat)subImage, (Mat)subDewarpedImage, (Mat)homography, (Size)new Size((double)rectWidth, (double)rectHeight), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
                    subImage.release();
                    subDewarpedImage.release();
                    homography.release();
                }
                ++j;
            }
            ++i;
        }
        return dewarpedImage;
    }

    protected Rect subImageRect(int iP, int jP) {
        Point[] polygon = this.mesh.get(new Key(iP, jP));
        assert (polygon != null) : iP + " " + jP;
        Point warpedTopLeft = polygon[0];
        Point warpedTopRight = polygon[1];
        Point warpedBottomRight = polygon[2];
        Point warpedBottomLeft = polygon[3];
        double xMin = Math.min(warpedTopLeft.x, warpedBottomLeft.x);
        double xMax = Math.max(warpedBottomRight.x, warpedTopRight.x);
        double yMin = Math.min(warpedTopRight.y, warpedTopLeft.y);
        double yMax = Math.max(warpedBottomLeft.y, warpedBottomRight.y);
        return new Rect(new Point(xMin, yMin), new Point(xMax, yMax));
    }

    protected Mat dewarpPolygon(Point[] polygon, Rect subImageRect, double rectHeight, double rectWidth) {
        Point warpedTopLeft = this.changeOrigin(subImageRect, polygon[0]);
        Point warpedTopRight = this.changeOrigin(subImageRect, polygon[1]);
        Point warpedBottomRight = this.changeOrigin(subImageRect, polygon[2]);
        Point warpedBottomLeft = this.changeOrigin(subImageRect, polygon[3]);
        Point dewarpedTopLeft = new Point(0.0, 0.0);
        Point dewarpedTopRight = new Point(rectWidth, 0.0);
        Point dewarpedBottomRight = new Point(rectWidth, rectHeight);
        Point dewarpedBottomLeft = new Point(0.0, rectHeight);
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{warpedTopLeft, warpedTopRight, warpedBottomRight, warpedBottomLeft}), (Mat)new MatOfPoint2f(new Point[]{dewarpedTopLeft, dewarpedTopRight, dewarpedBottomRight, dewarpedBottomLeft}));
    }

    protected Point changeOrigin(Rect subImageRect, Point point) {
        return new Point(point.x - (double)subImageRect.x, point.y - (double)subImageRect.y);
    }

    protected void drawPolygon(Mat image, Point[] polygon, Scalar color) {
        Point topLeft = polygon[0];
        Point topRight = polygon[1];
        Point bottomRight = polygon[2];
        Point bottomLeft = polygon[3];
        Imgproc.line((Mat)image, (Point)topLeft, (Point)topRight, (Scalar)color);
        Imgproc.line((Mat)image, (Point)topRight, (Point)bottomRight, (Scalar)color);
        Imgproc.line((Mat)image, (Point)bottomRight, (Point)bottomLeft, (Scalar)color);
        Imgproc.line((Mat)image, (Point)bottomLeft, (Point)topLeft, (Scalar)color);
    }

    private Point[] getPolygon(int i, int j) {
        return this.mesh.get(new Key(i, j));
    }

    private void addFirstPoly(Point imgCenter) {
        Point bottomRight = imgCenter;
        Point topRight = this.verticalMove(bottomRight, -this.deltaY);
        Point bottomLeft = this.horizontalMove(bottomRight, -this.deltaX);
        Point topLeft = this.intersect(topRight, bottomLeft);
        this.points.add(bottomRight);
        this.points.add(topRight);
        this.points.add(bottomLeft);
        this.points.add(topLeft);
        Point[] polygon = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        this.mesh.put(new Key(0, 0), polygon);
    }

    private void addPolygon(int i, int j) {
        Point bottomRight;
        Point bottomLeft;
        Point topRight;
        Point topLeft;
        Point[] abovePolygon = this.getPolygon(i - 1, j);
        Point[] rightPolygon = this.getPolygon(i, j + 1);
        Point[] belowPolygon = this.getPolygon(i + 1, j);
        Point[] leftPolygon = this.getPolygon(i, j - 1);
        if (abovePolygon != null) {
            topLeft = abovePolygon[3];
            topRight = abovePolygon[2];
            if (leftPolygon != null) {
                bottomLeft = leftPolygon[2];
                bottomRight = this.intersect(bottomLeft, topRight);
                this.points.add(bottomRight);
            } else if (rightPolygon != null) {
                bottomRight = rightPolygon[3];
                bottomLeft = this.intersect(bottomRight, topLeft);
                this.points.add(bottomLeft);
            } else {
                assert (j == 0);
                if (i > 0) {
                    bottomLeft = this.verticalMove(topLeft, this.deltaY);
                    bottomRight = this.intersect(bottomLeft, topRight);
                } else {
                    bottomRight = this.verticalMove(topRight, this.deltaY);
                    bottomLeft = this.intersect(topLeft, bottomRight);
                }
                this.points.add(bottomLeft);
                this.points.add(bottomRight);
            }
        } else if (rightPolygon != null) {
            topRight = rightPolygon[0];
            bottomRight = rightPolygon[3];
            if (belowPolygon != null) {
                bottomLeft = belowPolygon[0];
                topLeft = this.intersect(topRight, bottomLeft);
                this.points.add(topLeft);
            } else {
                assert (i == 0);
                if (j > 0) {
                    topLeft = this.horizontalMove(topRight, -this.deltaX);
                    bottomLeft = this.intersect(bottomRight, topLeft);
                } else {
                    bottomLeft = this.horizontalMove(bottomRight, -this.deltaX);
                    topLeft = this.intersect(topRight, bottomLeft);
                }
                this.points.add(topLeft);
                this.points.add(bottomLeft);
            }
        } else if (belowPolygon != null) {
            bottomLeft = belowPolygon[0];
            bottomRight = belowPolygon[1];
            if (leftPolygon != null) {
                topLeft = leftPolygon[1];
                topRight = this.intersect(topLeft, bottomRight);
                this.points.add(topRight);
            } else {
                assert (j == 0);
                if (i > 0) {
                    topLeft = this.verticalMove(bottomLeft, -this.deltaY);
                    topRight = this.intersect(bottomRight, topLeft);
                } else {
                    topRight = this.verticalMove(bottomRight, -this.deltaY);
                    topLeft = this.intersect(topRight, bottomLeft);
                }
                this.points.add(topLeft);
                this.points.add(topRight);
            }
        } else if (leftPolygon != null) {
            assert (i == 0);
            topLeft = leftPolygon[1];
            bottomLeft = leftPolygon[2];
            if (j > 0) {
                topRight = this.horizontalMove(topLeft, this.deltaX);
                bottomRight = this.intersect(bottomLeft, topRight);
            } else {
                bottomRight = this.horizontalMove(bottomLeft, this.deltaX);
                topRight = this.intersect(topLeft, bottomRight);
            }
            this.points.add(topRight);
            this.points.add(bottomRight);
        } else {
            throw new IllegalStateException();
        }
        Point[] polygon = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        this.mesh.put(new Key(i, j), polygon);
    }

    private Point intersect(Point hPoint, Point vPoint) {
        Point intersection = null;
        for (int i = 0; i < 1000; ++i) {
            double xDiff = this.xDiff(hPoint, vPoint);
            double yDiff = this.yDiff(vPoint, hPoint);
            hPoint = this.horizontalMove(hPoint, xDiff);
            vPoint = this.verticalMove(vPoint, yDiff);
            if (!(Math.abs(xDiff) < 0.5) || !(Math.abs(yDiff) < 0.5)) continue;
            intersection = new Point(0.5 * (hPoint.x + vPoint.x), 0.5 * (hPoint.y + vPoint.y));
            return intersection;
        }
        throw new IllegalStateException();
    }

    private double xDiff(Point pt1, Point pt2) {
        return pt2.x - pt1.x;
    }

    private double yDiff(Point pt1, Point pt2) {
        return pt2.y - pt1.y;
    }

    private Point verticalMove(Point startingPoint, double deltaY) {
        double dY = deltaY / (double)this.nbIter;
        double x = startingPoint.x;
        double y = startingPoint.y;
        for (int i = 0; i < this.nbIter; ++i) {
            double dX = dY / Math.tan(this.interpolator.interpolateVerticals(x - (double)this.xBorder, y - (double)this.yBorder));
            x += dX;
            y += dY;
        }
        return new Point(x, y);
    }

    private Point horizontalMove(Point startingPoint, double deltaX) {
        double dX = deltaX / (double)this.nbIter;
        double x = startingPoint.x;
        double y = startingPoint.y;
        for (int i = 0; i < this.nbIter; ++i) {
            double dY = Math.tan(this.interpolator.interpolateHorizontals(x - (double)this.xBorder, y - (double)this.yBorder)) * dX;
            x += dX;
            y += dY;
        }
        return new Point(x, y);
    }

    protected static class Key {
        public int i;
        public int j;

        public Key(int i, int j) {
            this.i = i;
            this.j = j;
        }

        public int hashCode() {
            return 31 * this.i + 7 * this.j;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.i == other.i && this.j == other.j;
        }
    }
}

