/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.List;
import org.genericsystem.cv.application.Reconciliation;
import org.genericsystem.cv.application.SuperFrameImg;
import org.opencv.calib3d.Calib3d;
import org.opencv.core.Core;
import org.opencv.core.DMatch;
import org.opencv.core.KeyPoint;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDMatch;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.features2d.BFMatcher;
import org.opencv.features2d.DescriptorMatcher;
import org.opencv.features2d.FastFeatureDetector;
import org.opencv.xfeatures2d.BriefDescriptorExtractor;

public class ImgDescriptor {
    private static final BriefDescriptorExtractor briefExtractor = BriefDescriptorExtractor.create((int)32, (boolean)false);
    private static final FastFeatureDetector detector = FastFeatureDetector.create((int)10, (boolean)true, (int)2);
    private static final DescriptorMatcher matcher = BFMatcher.create((int)4, (boolean)false);
    private final SuperFrameImg superFrame;
    private final MatOfKeyPoint keypoints = new MatOfKeyPoint();
    private final Mat descriptors;
    private final long timeStamp;
    private final double layoutSurface;

    public ImgDescriptor(SuperFrameImg superFrame, double surface) {
        this.superFrame = superFrame;
        detector.detect(superFrame.getFrame().getSrc(), this.keypoints);
        assert (this.keypoints != null && !this.keypoints.empty());
        this.descriptors = new Mat();
        briefExtractor.compute(superFrame.getFrame().getSrc(), this.keypoints, this.descriptors);
        this.timeStamp = System.currentTimeMillis();
        this.layoutSurface = surface;
    }

    public SuperFrameImg getSuperFrame() {
        return this.superFrame;
    }

    public double getSurface() {
        return this.layoutSurface;
    }

    public Mat getDescriptors() {
        return this.descriptors;
    }

    public MatOfKeyPoint getKeypoints() {
        return this.keypoints;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Reconciliation computeReconciliation(ImgDescriptor reference) {
        MatOfDMatch matches = new MatOfDMatch();
        matcher.match(this.getDescriptors(), reference.getDescriptors(), matches);
        List referenceKeyPoints = reference.getKeypoints().toList();
        List keyPoints = this.getKeypoints().toList();
        ArrayList<Point> referencePts = new ArrayList<Point>();
        ArrayList<Point> pts = new ArrayList<Point>();
        for (DMatch goodMatch : matches.toArray()) {
            if (!(goodMatch.distance <= 120.0f)) continue;
            referencePts.add(((KeyPoint)referenceKeyPoints.get((int)goodMatch.trainIdx)).pt);
            pts.add(((KeyPoint)keyPoints.get((int)goodMatch.queryIdx)).pt);
        }
        if (referencePts.size() > 50) {
            Mat result = Calib3d.findHomography((MatOfPoint2f)new MatOfPoint2f((Point[])pts.stream().toArray(Point[]::new)), (MatOfPoint2f)new MatOfPoint2f((Point[])referencePts.stream().toArray(Point[]::new)), (int)8, (double)1.0);
            if (result.size().empty()) {
                System.out.println("Stabilization homography is empty");
                return null;
            }
            if (!this.isValidHomography(result)) {
                System.out.println("Not a valid homography");
                return null;
            }
            return new Reconciliation(result, pts, referencePts);
        }
        return null;
    }

    private boolean isValidHomography(Mat homography) {
        int w = this.superFrame.getFrame().width();
        int h = this.superFrame.getFrame().height();
        MatOfPoint2f original = new MatOfPoint2f(new Point[]{new Point(0.0, 0.0), new Point((double)w, 0.0), new Point((double)w, (double)h), new Point(0.0, (double)h)});
        MatOfPoint2f dst = new MatOfPoint2f();
        Core.perspectiveTransform((Mat)original, (Mat)dst, (Mat)homography);
        List targets = dst.toList();
        return this.isClockwise((Point)targets.get(0), (Point)targets.get(1), (Point)targets.get(2));
    }

    private boolean isClockwise(Point a, Point b, Point c) {
        double areaSum = 0.0;
        areaSum += a.x * (b.y - c.y);
        areaSum += b.x * (c.y - a.y);
        return (areaSum += c.x * (a.y - b.y)) > 0.0;
    }
}

