/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.List;
import org.genericsystem.cv.application.Interpolator;
import org.opencv.core.Point;

public class GeneralInterpolator
implements Interpolator {
    private final List<OrientedPoint> horizontals;
    private final List<OrientedPoint> verticals;
    private final double pow;
    private final double minDist;

    public GeneralInterpolator(List<OrientedPoint> horizontals, List<OrientedPoint> verticals, double pow, double minDist) {
        this.horizontals = horizontals;
        this.verticals = verticals;
        this.pow = pow;
        this.minDist = minDist;
    }

    private double squaredEuclidianDistance(double x, double y, OrientedPoint op) {
        double result = Math.pow(x - ((OrientedPoint)op).center.x, 2.0) + Math.pow(y - ((OrientedPoint)op).center.y, 2.0);
        return result >= this.minDist * this.minDist ? result : this.minDist * this.minDist;
    }

    @Override
    public double interpolateHorizontals(double x, double y) {
        double sumHCoefs = 0.0;
        double hAngle = 0.0;
        for (OrientedPoint op : this.horizontals) {
            double geoCoef = Math.pow(1.0 / this.squaredEuclidianDistance(x, y, op), this.pow / 2.0);
            double hCoef = geoCoef * op.strenght;
            hAngle += hCoef * op.angle;
            sumHCoefs += hCoef;
        }
        return hAngle / sumHCoefs;
    }

    @Override
    public double interpolateVerticals(double x, double y) {
        double vAngle = 0.0;
        double sumVCoefs = 0.0;
        for (OrientedPoint op : this.verticals) {
            double geoCoef = Math.pow(1.0 / this.squaredEuclidianDistance(x, y, op), this.pow / 2.0);
            double vCoef = geoCoef * op.strenght;
            vAngle += vCoef * op.angle;
            sumVCoefs += vCoef;
        }
        return vAngle / sumVCoefs;
    }

    public static class OrientedPoint {
        private Point center;
        private double strenght;
        private double angle;

        public OrientedPoint(Point center, double angle, double strenght) {
            this.center = center;
            this.strenght = strenght;
            this.angle = angle;
        }
    }
}

