/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Kalman;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.SuperFrameImg;
import org.opencv.core.Mat;

public class Deperspectiver {
    private final double f;
    private final double[] pp;
    private Calibrated.AngleCalibrated calibrated0 = new Calibrated.AngleCalibrated(0.0, 1.5707963267948966);
    private Kalman kalmanZ = new Kalman();
    private Calibrated.AngleCalibrated[] calibratedVps;

    public Deperspectiver(double f, double[] pp) {
        this.f = f;
        this.pp = pp;
    }

    public Calibrated.AngleCalibrated[] computeCalibratedVps(SuperFrameImg superFrame, Lines lines) {
        if (lines.size() > 4) {
            this.calibrated0 = superFrame.findVanishingPoint(lines, this.calibrated0);
            this.calibratedVps = superFrame.findOtherVps(this.calibrated0, lines);
            double[] predictionZ = this.kalmanZ.predict();
            this.kalmanZ.correct(this.calibratedVps[2].uncalibrate(this.pp, this.f));
            this.calibratedVps[2] = new Calibrated.AngleCalibrated(new double[]{predictionZ[0], predictionZ[1], 1.0}, this.pp, this.f);
            this.calibratedVps[1] = this.calibratedVps[0].getOrthoFromVps(this.calibratedVps[2]);
            return this.calibratedVps;
        }
        System.out.println("Not enough lines : " + lines.size());
        return null;
    }

    public Mat findHomography(SuperFrameImg superFrame, Calibrated.AngleCalibrated[] calibratedVps) {
        return superFrame.findHomography(calibratedVps);
    }
}

