/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Point3;
import org.opencv.core.Scalar;

public class Svd2 {
    public static List<Point3> solve(List<Point> srcPts, int[][] rects) {
        int i;
        ArrayList<Point3> pts = new ArrayList<Point3>();
        for (Point point : srcPts) {
            pts.add(new Point3(point.x, point.y, 1.0));
        }
        double[] stdxy = new double[]{Math.sqrt(pts.stream().mapToDouble(pt -> pt.x * pt.x).average().getAsDouble()), Math.sqrt(pts.stream().mapToDouble(pt -> pt.y * pt.y).average().getAsDouble())};
        for (Point3 pt2 : pts) {
            pt2.x /= stdxy[0];
            pt2.y /= stdxy[1];
        }
        double d = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (Point3 pt3 : pts) {
            if (pt3.x < d) {
                d = pt3.x;
            }
            if (pt3.y < ymin) {
                ymin = pt3.y;
            }
            if (pt3.x > xmax) {
                xmax = pt3.x;
            }
            if (!(pt3.y > ymax)) continue;
            ymax = pt3.y;
        }
        double meanspan = Math.max(Math.max(Math.abs(d), Math.abs(xmax)), Math.max(Math.abs(ymin), Math.abs(ymax)));
        double lambda = 1.0 / (meanspan * meanspan);
        int n = pts.size();
        int m = rects.length;
        double[] polarity = new double[]{-1.0, 1.0, -1.0, 1.0};
        int nDim = 3;
        System.out.println("n = " + n);
        Mat A = new Mat(nDim * m, 3 * n, CvType.CV_64FC1, new Scalar(0.0));
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < nDim; ++j) {
                int constraint_index = nDim * i2 + j;
                for (int k = 0; k < 4; ++k) {
                    A.put(constraint_index, 3 * rects[i2][k] + j, new double[]{polarity[k]});
                }
            }
        }
        Mat B = new Mat(2 * n, 3 * n, CvType.CV_64FC1, new Scalar(0.0));
        for (int i3 = 0; i3 < n; ++i3) {
            B.put(2 * i3, 3 * i3, new double[]{1.0});
            B.put(2 * i3, 3 * i3 + 2, new double[]{-((Point3)pts.get((int)i3)).x});
            B.put(2 * i3 + 1, 3 * i3 + 1, new double[]{1.0});
            B.put(2 * i3 + 1, 3 * i3 + 2, new double[]{-((Point3)pts.get((int)i3)).y});
        }
        Mat dst = new Mat();
        Core.gemm((Mat)A.t(), (Mat)A, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Mat dst2 = new Mat();
        Core.gemm((Mat)B.t(), (Mat)B, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst2);
        Mat M = new Mat();
        Core.addWeighted((Mat)dst, (double)1.0, (Mat)dst2, (double)lambda, (double)0.0, (Mat)M);
        Mat eigenValues = new Mat();
        Mat eigenVectors = new Mat();
        Core.eigen((Mat)M, (Mat)eigenValues, (Mat)eigenVectors);
        int minIndex = -1;
        double minValue = Double.POSITIVE_INFINITY;
        for (int i4 = 0; i4 < eigenValues.rows(); ++i4) {
            if (!(eigenValues.get(i4, 0)[0] > Precision.EPSILON) || !(eigenValues.get(i4, 0)[0] < minValue)) continue;
            minValue = eigenValues.get(i4, 0)[0];
            minIndex = i4;
        }
        Mat result = eigenVectors.row(minIndex);
        double sum = 0.0;
        for (i = 0; i < pts.size(); ++i) {
            sum += result.get(0, 3 * i + 2)[0];
        }
        for (i = 0; i < pts.size(); ++i) {
            ((Point3)pts.get((int)i)).x = sum > 0.0 ? -result.get(0, 3 * i)[0] : result.get(0, 3 * i)[0];
            ((Point3)pts.get((int)i)).y = sum > 0.0 ? -result.get(0, 3 * i + 1)[0] : result.get(0, 3 * i + 1)[0];
            ((Point3)pts.get((int)i)).z = sum > 0.0 ? -result.get(0, 3 * i + 2)[0] : result.get(0, 3 * i + 2)[0];
        }
        for (i = 0; i < pts.size(); ++i) {
            ((Point3)pts.get((int)i)).x *= stdxy[0];
            ((Point3)pts.get((int)i)).y *= stdxy[1];
        }
        return pts;
    }

    static double[] mul(double[][] data, double[] sol) {
        double[] result = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                int n = i;
                result[n] = result[n] + data[i][j];
            }
        }
        return result;
    }

    static {
        NativeLibraryLoader.load();
    }
}

