/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import org.apache.commons.math3.util.Precision;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;

public class Svd {
    public static void main(String[] args) {
        double[][] pts = new double[][]{{2.0, 4.0, 1.0}, {3.0, 4.0, 1.0}, {4.0, 4.0, 1.0}, {2.0, 3.0, 1.0}, {3.0, 3.0, 1.0}, {4.0, 3.0, 1.0}, {2.0, 2.0, 1.0}, {3.0, 2.0, 1.0}, {4.0, 2.0, 1.0}};
        int[][] rects = new int[][]{{3, 4, 1, 0}, {4, 5, 2, 1}, {6, 7, 4, 3}, {7, 8, 5, 4}};
        double[][] result = Svd.solve(pts, rects);
        System.out.println(Arrays.deepToString((Object[])result));
    }

    public static double[][] solve(double[][] srcPts, int[][] rects) {
        int i;
        double[][] pts = new double[srcPts.length][srcPts[0].length];
        for (int i2 = 0; i2 < srcPts.length; ++i2) {
            pts[i2] = Arrays.copyOf(srcPts[i2], srcPts[i2].length);
        }
        double[] stdxy = new double[]{Math.sqrt(Arrays.stream(pts).mapToDouble(pt -> pt[0] * pt[0]).average().getAsDouble()), Math.sqrt(Arrays.stream(pts).mapToDouble(pt -> pt[1] * pt[1]).average().getAsDouble())};
        System.out.println(Arrays.toString(stdxy));
        for (double[] pt2 : pts) {
            pt2[0] = pt2[0] / stdxy[0];
            pt2[1] = pt2[1] / stdxy[1];
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (double[] pt3 : pts) {
            if (pt3[0] < xmin) {
                xmin = pt3[0];
            }
            if (pt3[1] < ymin) {
                ymin = pt3[1];
            }
            if (pt3[0] > xmax) {
                xmax = pt3[0];
            }
            if (!(pt3[1] > ymax)) continue;
            ymax = pt3[1];
        }
        double meanspan = Math.max(Math.max(Math.abs(xmin), Math.abs(xmax)), Math.max(Math.abs(ymin), Math.abs(ymax)));
        double lambda = 1.0 / (meanspan * meanspan);
        int n = pts.length;
        int m = rects.length;
        double[] polarity = new double[]{-1.0, 1.0, -1.0, 1.0};
        int nDim = 3;
        System.out.println("n = " + n);
        Mat A = new Mat(nDim * m, 3 * n, CvType.CV_64FC1, new Scalar(0.0));
        for (int i3 = 0; i3 < m; ++i3) {
            for (int j = 0; j < nDim; ++j) {
                int constraint_index = nDim * i3 + j;
                for (int k = 0; k < 4; ++k) {
                    A.put(constraint_index, 3 * rects[i3][k] + j, new double[]{polarity[k]});
                }
            }
        }
        for (int row = 0; row < A.rows(); ++row) {
            for (int col = 0; col < A.cols(); ++col) {
                System.out.print(A.get(row, col)[0] + " ");
            }
            System.out.println();
        }
        System.out.println();
        Mat B = new Mat(2 * n, 3 * n, CvType.CV_64FC1, new Scalar(0.0));
        for (int i4 = 0; i4 < n; ++i4) {
            B.put(2 * i4, 3 * i4, new double[]{1.0});
            B.put(2 * i4, 3 * i4 + 2, new double[]{-pts[i4][0]});
            B.put(2 * i4 + 1, 3 * i4 + 1, new double[]{1.0});
            B.put(2 * i4 + 1, 3 * i4 + 2, new double[]{-pts[i4][1]});
        }
        for (int row = 0; row < B.rows(); ++row) {
            for (int col = 0; col < B.cols(); ++col) {
                System.out.print(B.get(row, col)[0] + " ");
            }
            System.out.println();
        }
        System.out.println();
        Mat dst = new Mat();
        Core.gemm((Mat)A.t(), (Mat)A, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Mat dst2 = new Mat();
        Core.gemm((Mat)B.t(), (Mat)B, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst2);
        Mat M = new Mat();
        Core.addWeighted((Mat)dst, (double)1.0, (Mat)dst2, (double)lambda, (double)0.0, (Mat)M);
        Mat eigenValues = new Mat();
        Mat eigenVectors = new Mat();
        Core.eigen((Mat)M, (Mat)eigenValues, (Mat)eigenVectors);
        int minIndex = -1;
        double minValue = Double.POSITIVE_INFINITY;
        for (int i5 = 0; i5 < eigenValues.rows(); ++i5) {
            if (!(eigenValues.get(i5, 0)[0] > Precision.EPSILON) || !(eigenValues.get(i5, 0)[0] < minValue)) continue;
            minValue = eigenValues.get(i5, 0)[0];
            minIndex = i5;
        }
        Mat result = eigenVectors.row(minIndex);
        double sum = 0.0;
        for (i = 0; i < pts.length; ++i) {
            sum += result.get(0, 3 * i + 2)[0];
        }
        for (i = 0; i < pts.length; ++i) {
            pts[i][0] = sum > 0.0 ? -result.get(0, 3 * i)[0] : result.get(0, 3 * i)[0];
            pts[i][1] = sum > 0.0 ? -result.get(0, 3 * i + 1)[0] : result.get(0, 3 * i + 1)[0];
            pts[i][2] = sum > 0.0 ? -result.get(0, 3 * i + 2)[0] : result.get(0, 3 * i + 2)[0];
        }
        for (i = 0; i < pts.length; ++i) {
            double[] dArray = pts[i];
            dArray[0] = dArray[0] * stdxy[0];
            double[] dArray2 = pts[i];
            dArray2[1] = dArray2[1] * stdxy[1];
        }
        return pts;
    }

    static double[] mul(double[][] datas, double[] sol) {
        double[] result = new double[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            for (int j = 0; j < datas[i].length; ++j) {
                int n = i;
                result[n] = result[n] + datas[i][j];
            }
        }
        return result;
    }

    static {
        NativeLibraryLoader.load();
    }
}

