/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;

public class ImgClass
implements AutoCloseable {
    private static final String TEMPLATE_NAME = "template/template.png";
    private Img classModel;
    private Img mean;
    private Img variance;
    private final String directory;
    private final List<Function<Img, Img>> mappers = new ArrayList<Function<Img, Img>>();

    public static ImgClass fromDirectory(String bgrDirectory) {
        return new ImgClass(bgrDirectory);
    }

    private Img applyMappers(Img img) {
        for (Function<Img, Img> mapper : this.mappers) {
            img = mapper.apply(img);
        }
        return img;
    }

    public ImgClass(String bgrDirectory) {
        File oldTemplate = Paths.get(bgrDirectory, new String[0]).resolve("template.png").toFile();
        Path template = Paths.get(bgrDirectory, TEMPLATE_NAME.split(File.separator));
        template.getParent().toFile().mkdirs();
        if (oldTemplate.exists()) {
            oldTemplate.renameTo(template.toFile());
        }
        if (this.classModel == null && template.toFile().exists()) {
            this.classModel = new Img(template.toString());
        }
        this.directory = bgrDirectory;
    }

    public Stream<Img> classImgsStream() {
        return Tools.classImgsStream(this.directory);
    }

    private synchronized void computeMeanVariance() {
        Iterator it_ = this.classImgsStream().iterator();
        if (it_.hasNext()) {
            Img img0 = this.applyMappers((Img)it_.next());
            boolean gray = img0.channels() == 1;
            int type = gray ? 4 : CvType.CV_32SC3;
            Mat mean = new Mat(img0.size(), type, Scalar.all((double)0.0));
            Mat m2 = new Mat(img0.size(), type, Scalar.all((double)0.0));
            Mat mask = Mat.ones((Size)img0.size(), (int)0);
            img0.close();
            int count = 1;
            Iterator it = this.classImgsStream().iterator();
            while (it.hasNext()) {
                Mat img = new Mat();
                this.applyMappers((Img)it.next()).getSrc().convertTo(img, type);
                Mat delta = new Mat(img.size(), type);
                Core.subtract((Mat)img, (Mat)mean, (Mat)delta, (Mat)mask, (int)type);
                Core.addWeighted((Mat)mean, (double)1.0, (Mat)delta, (double)(1.0 / (double)count), (double)0.0, (Mat)mean, (int)type);
                Mat delta2 = new Mat(m2.size(), type);
                Core.subtract((Mat)img, (Mat)mean, (Mat)delta2, (Mat)mask, (int)type);
                Mat product = delta.mul(delta2);
                Core.add((Mat)m2, (Mat)product, (Mat)m2);
                ++count;
                img.release();
                delta.release();
                delta2.release();
                product.release();
            }
            Mat variance = new Mat(m2.size(), type);
            Core.multiply((Mat)m2, (Scalar)new Scalar(1.0 / (double)count, 1.0 / (double)count, 1.0 / (double)count), (Mat)variance);
            variance.convertTo(variance, 0);
            mean.convertTo(mean, 0);
            m2.release();
            mask.release();
            this.mean = new Img(mean, false);
            this.variance = new Img(variance, false);
        }
    }

    public void addMapper(Function<Img, Img> after) {
        this.mappers.add(after);
        this.computeMeanVariance();
    }

    public Img getClassModel() {
        return this.classModel;
    }

    public Img getMean() {
        if (this.mean == null) {
            this.computeMeanVariance();
        }
        return this.mean;
    }

    public Img getVariance() {
        if (this.variance == null) {
            this.computeMeanVariance();
        }
        return this.variance;
    }

    public String getDirectory() {
        return this.directory;
    }

    public Img getClosedMeanZones(Size morphClose) {
        return this.mean.morphologyEx(3, 0, morphClose);
    }

    public Img getClosedVarianceZones(Size morphClose) {
        return this.variance.morphologyEx(3, 0, morphClose);
    }

    @Override
    public void close() {
        if (this.classModel != null) {
            this.classModel.close();
        }
        if (this.mean != null) {
            this.mean.close();
        }
        if (this.variance != null) {
            this.variance.close();
        }
    }
}

