/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.objdetect.CascadeClassifier;
import org.opencv.videoio.VideoCapture;

public class FaceDetector
extends AbstractApp {
    private static CascadeClassifier faceCascade;
    private VideoCapture camera = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public static void main(String[] args) {
        FaceDetector.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        ImageView imgView = new ImageView();
        mainGrid.add((Node)imgView, 0, 0);
        Mat frame = new Mat();
        this.camera.read(frame);
        imgView.setImage(Tools.mat2jfxImage(frame));
        this.timer.scheduleAtFixedRate(() -> {
            this.camera.read(frame);
            Rect[] faces = FaceDetector.detect(frame);
            Arrays.stream(faces).forEach(face -> Imgproc.rectangle((Mat)frame, (Point)face.tl(), (Point)face.br(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1));
            imgView.setImage(Tools.mat2jfxImage(frame));
        }, 0L, 33L, TimeUnit.MILLISECONDS);
    }

    public static Rect[] detect(Mat frame) {
        Mat grayFrame = new Mat();
        Imgproc.cvtColor((Mat)frame, (Mat)grayFrame, (int)6);
        Imgproc.equalizeHist((Mat)grayFrame, (Mat)grayFrame);
        MatOfRect faces = new MatOfRect();
        int absoluteFaceSize = Math.round((float)grayFrame.rows() * 0.2f);
        if (absoluteFaceSize > 0) {
            faceCascade.detectMultiScale(grayFrame, faces, 1.1, 2, 2, new Size((double)absoluteFaceSize, (double)absoluteFaceSize), new Size());
            return faces.toArray();
        }
        return new Rect[0];
    }

    public void stop() throws Exception {
        this.timer.shutdown();
        this.camera.release();
        super.stop();
    }

    static {
        NativeLibraryLoader.load();
        faceCascade = new CascadeClassifier();
        faceCascade.load("resources/haarcascade_frontalface_alt2.xml");
    }
}

