/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import java.util.List;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.ml.Boost;
import org.opencv.ml.SVM;
import org.opencv.utils.Converters;

public class Booster {
    public static void main(String[] args) {
        List<Integer> labels = Arrays.asList(1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1);
        List trainingData = Arrays.asList({501.0, 10.0}, {508.0, 15.0}, {255.0, 10.0}, {501.0, 255.0}, {10.0, 501.0}, {10.0, 501.0}, {11.0, 501.0}, {9.0, 501.0}, {10.0, 502.0}, {10.0, 511.0}, {10.0, 495.0});
        Mat labelsMat = new Mat();
        for (int i = 0; i < 11; ++i) {
            labelsMat.push_back(new Mat(new Size(1.0, 1.0), 4, new Scalar((double)labels.get(i).intValue())));
        }
        Mat trainingDataMat = new Mat(11, 2, CvType.CV_32FC1);
        for (int i = 0; i < 11; ++i) {
            trainingDataMat.put(i, 0, new double[]{((double[])trainingData.get(i))[0]});
            trainingDataMat.put(i, 1, new double[]{((double[])trainingData.get(i))[1]});
        }
        SVM svm = SVM.create();
        svm.setType(100);
        svm.setTermCriteria(new TermCriteria(1, 100, 1.0E-6));
        svm.setKernel(0);
        assert (labelsMat.rows() == trainingData.size()) : labelsMat.rows() + " / " + trainingData.size();
        svm.train(trainingDataMat, 0, labelsMat);
        Boost boost = Boost.create();
        boost.train(trainingDataMat, 0, labelsMat);
        Mat testSample1 = Converters.vector_double_to_Mat(Arrays.asList(251.0, 5.0)).reshape(1, 1);
        testSample1.convertTo(testSample1, CvType.CV_32FC1);
        Mat testSample2 = Converters.vector_double_to_Mat(Arrays.asList(251.0, 5.0)).reshape(1, 1);
        testSample2.convertTo(testSample2, CvType.CV_32FC1);
        float svmResponse1 = svm.predict(testSample1);
        float svmResponse2 = svm.predict(testSample2);
        float boostResponse1 = boost.predict(testSample1);
        float boostResponse2 = boost.predict(testSample2);
        System.out.println("SVM: " + svmResponse1 + " " + svmResponse2);
        System.out.println("BOOST: " + boostResponse1 + " " + boostResponse2);
    }

    static {
        NativeLibraryLoader.load();
    }
}

