/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import java.util.ArrayList;
import java.util.List;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.retriever.CamLiveRetriever;
import org.opencv.calib3d.Calib3d;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.DMatch;
import org.opencv.core.KeyPoint;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDMatch;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.features2d.BFMatcher;
import org.opencv.features2d.DescriptorMatcher;
import org.opencv.features2d.FastFeatureDetector;
import org.opencv.imgproc.Imgproc;
import org.opencv.xfeatures2d.BriefDescriptorExtractor;

public class ImgDescriptor {
    private static final BriefDescriptorExtractor briefExtractor = BriefDescriptorExtractor.create((int)32, (boolean)false);
    private static final FastFeatureDetector detector = FastFeatureDetector.create((int)10, (boolean)true, (int)2);
    private static final DescriptorMatcher matcher = BFMatcher.create((int)4, (boolean)true);
    private final Img deperspectivedImg;
    private final MatOfKeyPoint keypoints = new MatOfKeyPoint();
    private final Mat descriptors;
    private final Mat homography;

    public ImgDescriptor(Mat frame, Mat deperspectivGraphy) {
        this.deperspectivedImg = CamLiveRetriever.warpPerspective(frame, deperspectivGraphy);
        detector.detect(this.deperspectivedImg.getSrc(), this.keypoints);
        assert (this.keypoints != null && !this.keypoints.empty());
        this.descriptors = new Mat();
        briefExtractor.compute(this.deperspectivedImg.getSrc(), this.keypoints, this.descriptors);
        this.homography = deperspectivGraphy;
    }

    public Img getDeperspectivedImg() {
        return this.deperspectivedImg;
    }

    public MatOfKeyPoint getKeypoints() {
        return this.keypoints;
    }

    public Mat getDescriptors() {
        return this.descriptors;
    }

    public Mat getHomography() {
        return this.homography;
    }

    private static MatOfKeyPoint detect(Img frame) {
        Img closed = frame.bilateralFilter(5, 80.0, 80.0).adaptativeGaussianInvThreshold(17, 3.0).morphologyEx(3, 2, new Size(5.0, 5.0));
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)closed.getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        double minArea = 100.0;
        ArrayList keyPoints = new ArrayList();
        contours.stream().filter(contour -> Imgproc.contourArea((Mat)contour) > minArea).map(Imgproc::boundingRect).forEach(rect -> {
            keyPoints.add(new KeyPoint((float)rect.tl().x, (float)rect.tl().y, 6.0f));
            keyPoints.add(new KeyPoint((float)rect.tl().x, (float)rect.br().y, 6.0f));
            keyPoints.add(new KeyPoint((float)rect.br().x, (float)rect.tl().y, 6.0f));
            keyPoints.add(new KeyPoint((float)rect.br().x, (float)rect.br().y, 6.0f));
        });
        return new MatOfKeyPoint((KeyPoint[])keyPoints.stream().toArray(KeyPoint[]::new));
    }

    public Mat computeStabilizationGraphy(ImgDescriptor frameDescriptor) {
        MatOfDMatch matches = new MatOfDMatch();
        matcher.match(this.getDescriptors(), frameDescriptor.getDescriptors(), matches);
        ArrayList<DMatch> goodMatches = new ArrayList<DMatch>();
        for (DMatch dMatch : matches.toArray()) {
            if (!(dMatch.distance <= 120.0f)) continue;
            goodMatches.add(dMatch);
        }
        List newKeypoints_ = frameDescriptor.getKeypoints().toList();
        List oldKeypoints_ = this.getKeypoints().toList();
        ArrayList<Point> goodNewKeypoints = new ArrayList<Point>();
        ArrayList<Point> goodOldKeypoints = new ArrayList<Point>();
        for (DMatch goodMatch : goodMatches) {
            goodNewKeypoints.add(((KeyPoint)newKeypoints_.get((int)goodMatch.trainIdx)).pt);
            goodOldKeypoints.add(((KeyPoint)oldKeypoints_.get((int)goodMatch.queryIdx)).pt);
        }
        if (goodMatches.size() > 30) {
            ArrayList<Point[]> pairedPoints = new ArrayList<Point[]>();
            for (int i = 0; i < goodNewKeypoints.size(); ++i) {
                pairedPoints.add(new Point[]{(Point)goodOldKeypoints.get(i), (Point)goodNewKeypoints.get(i)});
            }
            double[] transScaleParams = new LevenbergImpl<Point[]>((points, params) -> this.distance((Point[])points, (double[])params), pairedPoints, new double[]{1.0, 1.0, 0.0, 0.0}).getParams();
            Mat result = Calib3d.findHomography((MatOfPoint2f)new MatOfPoint2f((Point[])goodOldKeypoints.stream().toArray(Point[]::new)), (MatOfPoint2f)new MatOfPoint2f((Point[])goodNewKeypoints.stream().toArray(Point[]::new)), (int)8, (double)1.0);
            if (result.size().empty()) {
                CamLiveRetriever.logger.warn("Stabilization homography is empty");
                return null;
            }
            if (!this.isValidHomography(result)) {
                CamLiveRetriever.logger.warn("Not a valid homography");
                return null;
            }
            return result;
        }
        CamLiveRetriever.logger.warn("Not enough matches ({})", (Object)goodMatches.size());
        return null;
    }

    private Mat getTSMat(double[] transScaleParams) {
        Mat TSMat = new Mat(3, 3, CvType.CV_64FC1, new Scalar(0.0));
        TSMat.put(0, 0, new double[]{transScaleParams[0]});
        TSMat.put(1, 1, new double[]{transScaleParams[1]});
        TSMat.put(0, 2, new double[]{transScaleParams[2] * transScaleParams[0]});
        TSMat.put(1, 2, new double[]{transScaleParams[3] * transScaleParams[1]});
        TSMat.put(2, 2, new double[]{1.0});
        return TSMat;
    }

    private double distance(Point[] points, double[] params) {
        double p2x = points[1].x;
        double p1x = params[0] * points[0].x + params[0] * params[2];
        double deltaX = p2x - p1x;
        double p2y = points[1].y;
        double p1y = params[1] * points[0].y + params[1] * params[3];
        double deltaY = p2y - p1y;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        return distance < 5.0 ? distance : 5.0;
    }

    private boolean isValidHomography(Mat homography) {
        int w = this.deperspectivedImg.getSrc().width();
        int h = this.deperspectivedImg.getSrc().height();
        MatOfPoint2f original = new MatOfPoint2f(new Point[]{new Point(0.0, 0.0), new Point((double)w, 0.0), new Point((double)w, (double)h), new Point(0.0, (double)h)});
        MatOfPoint2f dst = new MatOfPoint2f();
        Core.perspectiveTransform((Mat)original, (Mat)dst, (Mat)homography);
        List targets = dst.toList();
        return this.isClockwise((Point)targets.get(0), (Point)targets.get(1), (Point)targets.get(2));
    }

    private boolean isClockwise(Point a, Point b, Point c) {
        double areaSum = 0.0;
        areaSum += a.x * (b.y - c.y);
        areaSum += b.x * (c.y - a.y);
        return (areaSum += c.x * (a.y - b.y)) > 0.0;
    }
}

