/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import com.google.common.base.Function;
import java.util.List;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.layout.Layout;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class SuperTemplate
extends SuperFrameImg {
    private final int type;

    public SuperTemplate(SuperFrameImg superFrame, int displayType, Function<SuperFrameImg, Img> retriever) {
        super(((Img)retriever.apply((Object)superFrame)).getSrc(), superFrame.getPp(), superFrame.getF());
        this.type = displayType;
    }

    @Override
    protected Img buildDisplay() {
        return new Img(new Mat(this.size(), this.type, Scalar.all((double)0.0)), false);
    }

    public Layout layout() {
        return this.getFrame().buildLayout(new Size(0.05, 0.05), 15);
    }

    public void drawLayout(Layout layout) {
        layout.draw(this.getDisplay(), new Scalar(255.0, 0.0, 0.0), new Scalar(0.0, 0.0, 255.0), 1, -1);
    }

    public void drawCenterPoints(List<Rect> referenceRects, Scalar color, int thickNess, int radius) {
        referenceRects.forEach(rect -> Imgproc.circle((Mat)this.getDisplay().getSrc(), (Point)new Point((rect.tl().x + rect.br().x) / 2.0, (rect.tl().y + rect.br().y) / 2.0), (int)radius, (Scalar)color, (int)thickNess));
    }

    public void drawCentroids(List<Point> referenceRects, Scalar color, int thickNess, int radius) {
        referenceRects.forEach(pt -> Imgproc.circle((Mat)this.getDisplay().getSrc(), (Point)pt, (int)radius, (Scalar)color, (int)thickNess));
    }
}

