/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.List;
import org.genericsystem.cv.application.Interpolator;
import org.genericsystem.cv.application.SuperContour;

public class SuperContourInterpolator
implements Interpolator {
    private final double pow;
    private List<SuperContour> superContours;
    private double hCoef;
    private double vCoef;
    private double sumHCoefs;
    private double sumVCoefs;
    private double hAngle;
    private double vAngle;

    public SuperContourInterpolator(List<SuperContour> superContours, double pow) {
        this.superContours = superContours;
        this.pow = pow;
    }

    private double squaredEuclidianDistance(double x, double y, SuperContour sc) {
        double minDist;
        double result = Math.pow(x - sc.center.x, 2.0) + Math.pow(y - sc.center.y, 2.0);
        return result >= Math.pow(minDist = 10.0, 2.0) ? result : Math.pow(minDist, 2.0);
    }

    @Override
    public double[] interpolate(double x, double y) {
        this.sumHCoefs = 0.0;
        this.sumVCoefs = 0.0;
        this.hAngle = 0.0;
        this.vAngle = 0.0;
        this.superContours.forEach(sc -> {
            double geoCoef = Math.pow(1.0 / (this.squaredEuclidianDistance(x, y, (SuperContour)sc) + 1.0E-5), this.pow / 2.0);
            this.hCoef = geoCoef * sc.dx;
            this.hAngle += this.hCoef * sc.angle;
            this.vCoef = geoCoef * sc.dx;
            this.vAngle += this.vCoef * sc.vertical;
            this.sumHCoefs += this.hCoef;
            this.sumVCoefs += this.vCoef;
        });
        return new double[]{this.hAngle / this.sumHCoefs, this.vAngle / this.sumVCoefs};
    }
}

