/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.GeneralInterpolator;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadonTransform {
    private static final Logger logger;

    public static Mat transform(Mat src, int minMaxAngle) {
        Mat dst = Mat.zeros((int)src.rows(), (int)src.rows(), (int)CvType.CV_64FC1);
        int center = dst.rows() / 2;
        src.convertTo(new Mat(dst, new Rect(new Point((double)(center - src.cols() / 2), 0.0), new Point((double)(center + src.cols() / 2), (double)src.rows()))), CvType.CV_64FC1);
        Mat radon = Mat.zeros((int)dst.rows(), (int)(2 * minMaxAngle), (int)CvType.CV_64FC1);
        for (int t = -minMaxAngle; t < minMaxAngle; ++t) {
            Mat rotated = new Mat();
            Mat rotation = Imgproc.getRotationMatrix2D((Point)new Point((double)center, (double)center), (double)t, (double)1.0);
            Imgproc.warpAffine((Mat)dst, (Mat)rotated, (Mat)rotation, (Size)new Size((double)dst.cols(), (double)dst.rows()), (int)0);
            Core.reduce((Mat)rotated, (Mat)radon.col(t + minMaxAngle), (int)1, (int)0);
            rotated.release();
            rotation.release();
        }
        dst.release();
        Core.normalize((Mat)radon, (Mat)radon, (double)0.0, (double)255.0, (int)32);
        return radon;
    }

    public static Mat projectionMap(Mat radon) {
        Mat projectionMap = Mat.zeros((int)radon.rows(), (int)radon.cols(), (int)CvType.CV_64FC1);
        for (int k = 0; k < projectionMap.rows(); ++k) {
            for (int tetha = 0; tetha < projectionMap.cols(); ++tetha) {
                int p = (int)((double)(k - projectionMap.rows() / 2) * Math.sin(((double)tetha + 45.0) / 180.0 * Math.PI) + (double)(radon.rows() / 2));
                projectionMap.put(k, tetha, new double[]{radon.get(p, tetha)[0]});
            }
        }
        return projectionMap;
    }

    public static int[] bestTraject(Mat projectionMap, double anglePenality, double pow) {
        double[][] score = new double[projectionMap.rows()][projectionMap.cols()];
        int[][] thetaPrev = new int[projectionMap.rows()][projectionMap.cols()];
        for (int theta = 0; theta < projectionMap.cols(); ++theta) {
            score[0][theta] = Math.pow(projectionMap.get(0, theta)[0], pow);
        }
        for (int k = 1; k < projectionMap.rows(); ++k) {
            for (int theta = 0; theta < projectionMap.cols(); ++theta) {
                double magnitude = projectionMap.get(k, theta)[0];
                double scoreFromPrevTheta = theta != 0 ? score[k - 1][theta - 1] : Double.NEGATIVE_INFINITY;
                double scoreFromSameTheta = score[k - 1][theta];
                double scoreFromNextTheta = theta < projectionMap.cols() - 1 ? score[k - 1][theta + 1] : Double.NEGATIVE_INFINITY;
                double bestScore4Pos = -1.0;
                if (scoreFromSameTheta >= scoreFromPrevTheta + anglePenality && scoreFromSameTheta >= scoreFromNextTheta + anglePenality) {
                    bestScore4Pos = scoreFromSameTheta;
                    thetaPrev[k][theta] = theta;
                } else if (scoreFromPrevTheta + anglePenality >= scoreFromSameTheta && scoreFromPrevTheta + anglePenality >= scoreFromNextTheta + anglePenality) {
                    bestScore4Pos = scoreFromPrevTheta + anglePenality;
                    thetaPrev[k][theta] = theta - 1;
                } else {
                    bestScore4Pos = scoreFromNextTheta + anglePenality;
                    thetaPrev[k][theta] = theta + 1;
                }
                score[k][theta] = Math.pow(magnitude, pow) + bestScore4Pos;
            }
        }
        double maxScore = Double.NEGATIVE_INFINITY;
        int prevTheta = -1;
        int[] thetas = new int[projectionMap.rows()];
        for (int theta = 0; theta < projectionMap.cols(); ++theta) {
            double lastScore = score[projectionMap.rows() - 1][theta];
            if (!(lastScore > maxScore)) continue;
            maxScore = lastScore;
            prevTheta = theta;
        }
        assert (prevTheta != -1);
        for (int k = projectionMap.rows() - 1; k >= 0; --k) {
            thetas[k] = prevTheta;
            prevTheta = thetaPrev[k][prevTheta];
        }
        return thetas;
    }

    public static List<Mat> extractStrips(Mat src, int stripWidth) {
        ArrayList<Mat> strips = new ArrayList<Mat>();
        int col = 0;
        while (col + stripWidth <= src.cols()) {
            strips.add(RadonTransform.extractStrip(src, col, stripWidth));
            col += stripWidth / 2;
        }
        return strips;
    }

    public static Mat extractStrip(Mat src, int startX, int width) {
        return new Mat(src, new Range(0, src.rows()), new Range(startX, startX + width));
    }

    public static Mat[] estimateBaselines(Mat image, double anglePenalty, int minMaxAngle, double magnitudePow) {
        Mat result = image.clone();
        Mat curve = image.clone();
        Mat preprocessed = new Img(result, false).gaussianBlur(new Size(5.0, 5.0)).adaptativeGaussianInvThreshold(5, 3.0).canny(60.0, 180.0).getSrc();
        int n = 20;
        float r = 0.5f;
        double w = (float)image.width() / ((float)n * (1.0f - r) + r);
        double step = (int)((double)(1.0f - r) * w);
        int[][] angles = new int[n][];
        double[] xs = new double[n + 2];
        BiFunction<Double, double[], Double> f = (y, params) -> params[0] + params[1] * y + params[2] * y * y;
        double[][] approxParams = new double[n][];
        int x = 0;
        for (int i = 0; i < n; ++i) {
            Mat radonTransform = RadonTransform.transform(RadonTransform.extractStrip(preprocessed, x, (int)w), minMaxAngle);
            Mat projMap = RadonTransform.projectionMap(radonTransform);
            Imgproc.morphologyEx((Mat)projMap, (Mat)projMap, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(2.0, 4.0)));
            angles[i] = RadonTransform.bestTraject(projMap, anglePenalty, magnitudePow);
            projMap.release();
            radonTransform.release();
            ArrayList<double[]> values = new ArrayList<double[]>();
            for (int k = 0; k < image.height(); ++k) {
                values.add(new double[]{k, angles[i][k]});
            }
            approxParams[i] = LevenbergImpl.fromBiFunction(f, values, new double[]{0.0, 0.0, 0.0}).getParams();
            xs[i + 1] = (double)x + 0.5 * w;
            x = (int)((double)x + step);
        }
        xs[n + 1] = image.width() - 1;
        int lines = image.height() / 15;
        double yStep = image.height() / lines;
        logger.info("Image width {}, xs {}, step {}, w {}", new Object[]{image.width(), Arrays.toString(xs), step, w});
        for (int i = 0; i < lines; ++i) {
            double theta;
            int j;
            double[] ys = new double[n + 2];
            ys[n / 2] = (double)i * yStep + 0.5 * yStep;
            for (j = n / 2; j <= n; ++j) {
                theta = (f.apply(ys[j], approxParams[j - 1]) - (double)minMaxAngle) / 180.0 * Math.PI;
                if (j == n) {
                    ys[n + 1] = ys[n] + ((double)(image.width() - 1) - xs[j]) * Math.tan(theta);
                    continue;
                }
                ys[j + 1] = ys[j] + step * Math.tan(theta);
            }
            for (j = n / 2; j > 0; --j) {
                theta = (f.apply(ys[j], approxParams[j - 1]) - (double)minMaxAngle) / 180.0 * Math.PI;
                ys[j - 1] = ys[j] - step * Math.tan(theta);
            }
            for (j = 0; j < xs.length - 1; ++j) {
                Imgproc.line((Mat)result, (Point)new Point(xs[j], ys[j]), (Point)new Point(xs[j + 1], ys[j + 1]), (Scalar)new Scalar(255.0, 0.0, 255.0));
            }
            PolynomialSplineFunction psf = new LinearInterpolator().interpolate(xs, ys);
            int currX = 0;
            Point prevPoint = new Point((double)currX, psf.value((double)currX));
            while (currX < image.width()) {
                Point newPoint = new Point((double)(currX += 5), 0.0);
                if (psf.isValidPoint((double)currX)) {
                    newPoint.y = psf.value((double)currX);
                    if (psf.isValidPoint(prevPoint.x) && RadonTransform.inImage(prevPoint, result) && RadonTransform.inImage(newPoint, result)) {
                        Imgproc.line((Mat)curve, (Point)prevPoint, (Point)newPoint, (Scalar)new Scalar(255.0, 255.0, 0.0));
                    }
                }
                prevPoint = newPoint;
            }
        }
        return new Mat[]{result, curve};
    }

    public static Function<Double, Double> approxTraject(int[] traj) {
        ArrayList<double[]> values = new ArrayList<double[]>();
        for (int k = 0; k < traj.length; ++k) {
            values.add(new double[]{k, traj[k]});
        }
        BiFunction<Double, double[], Double> f = (x, params) -> params[0] + params[1] * x + params[2] * x * x + params[3] * x * x * x;
        double[] params2 = LevenbergImpl.fromBiFunction(f, values, new double[]{0.0, 0.0, 0.0, 0.0}).getParams();
        return x -> (Double)f.apply((Double)x, params2);
    }

    public static List<GeneralInterpolator.OrientedPoint> toHorizontalOrientedPoints(Function<Double, Double> f, int vStrip, int stripWidth, int height, int step) {
        ArrayList<GeneralInterpolator.OrientedPoint> orientedPoints = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (int k = step; k < height; k += step) {
            double angle = (f.apply(Double.valueOf(k)) - 45.0) / 180.0 * Math.PI;
            orientedPoints.add(new GeneralInterpolator.OrientedPoint(new Point((double)((vStrip + 1) * stripWidth / 2), (double)k), angle, 1.0));
        }
        return orientedPoints;
    }

    public static List<GeneralInterpolator.OrientedPoint> toVerticalOrientedPoints(Function<Double, Double> f, int hStrip, int stripHeight, int width, int step) {
        ArrayList<GeneralInterpolator.OrientedPoint> orientedPoints = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (int k = step; k < width; k += step) {
            double angle = (135.0 - f.apply(Double.valueOf(k))) / 180.0 * Math.PI;
            orientedPoints.add(new GeneralInterpolator.OrientedPoint(new Point((double)k, (double)((hStrip + 1) * stripHeight / 2)), angle, 1.0));
        }
        return orientedPoints;
    }

    private static boolean inImage(Point p, Mat img) {
        return p.x >= 0.0 && p.y >= 0.0 && p.x < (double)img.width() && p.y < (double)img.height();
    }

    static {
        NativeLibraryLoader.load();
        logger = LoggerFactory.getLogger(RadonTransform.class);
    }
}

