/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.cv.Svd2;
import org.genericsystem.cv.application.Interpolator;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Point3;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGrid {
    private static final Logger logger = LoggerFactory.getLogger(MeshGrid.class);
    private final Size kSize;
    public List<Point> points = new ArrayList<Point>();
    private Map<Key, Point[]> mesh = new HashMap<Key, Point[]>();
    private Interpolator interpolator;
    public double deltaX;
    public double deltaY;
    private final int xBorder;
    private final int yBorder;
    private final Mat image;
    private int nbIter;

    public MeshGrid(Size kSize, Interpolator interpolator, double deltaX, double deltaY, Mat image) {
        this.kSize = kSize;
        this.interpolator = interpolator;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.image = image;
        this.xBorder = 2 * (int)deltaX;
        this.yBorder = 2 * (int)deltaY;
        Core.copyMakeBorder((Mat)image, (Mat)this.image, (int)this.yBorder, (int)this.yBorder, (int)this.xBorder, (int)this.xBorder, (int)1);
        this.nbIter = (int)Math.round(deltaY);
    }

    private int[][] toRectIndices() {
        int[][] rects = new int[this.mesh.size()][4];
        ArrayList<Point[]> meshPoints = new ArrayList<Point[]>(this.mesh.values());
        for (int i = 0; i < rects.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                rects[i][j] = this.points.indexOf(((Point[])meshPoints.get(i))[j]);
            }
        }
        return rects;
    }

    private Map<Key, Point3[]> toPoint3d() {
        List<Point3> points3D = Svd2.solve(this.points, this.toRectIndices());
        HashMap<Key, Point3[]> mesh3D = new HashMap<Key, Point3[]>();
        for (Map.Entry<Key, Point[]> entry : this.mesh.entrySet()) {
            Point3[] para3D = new Point3[4];
            for (int j = 0; j < 4; ++j) {
                para3D[j] = points3D.get(this.points.indexOf(entry.getValue()[j]));
            }
            mesh3D.put(entry.getKey(), para3D);
        }
        return mesh3D;
    }

    public void build() {
        int j;
        Point imgCenter = new Point((double)(this.image.width() / 2), (double)(this.image.height() / 2));
        this.addFirstPoly(imgCenter);
        int i = 0;
        while ((double)i <= this.kSize.height) {
            for (j = 0; j <= (int)this.kSize.width; ++j) {
                if (i == 0 && j == 0) continue;
                this.addPolygon(i, j);
            }
            for (j = -1; j > -((int)this.kSize.width); --j) {
                this.addPolygon(i, j);
            }
            ++i;
        }
        i = -1;
        while ((double)i > -this.kSize.height) {
            for (j = 0; j <= (int)this.kSize.width; ++j) {
                this.addPolygon(i, j);
            }
            for (j = -1; j > -((int)this.kSize.width); --j) {
                this.addPolygon(i, j);
            }
            --i;
        }
    }

    public Mat drawOnCopy(Scalar color) {
        Mat clone = this.image.clone();
        this.mesh.values().forEach(p -> this.drawPolygon(clone, (Point[])p, color));
        return clone;
    }

    public Mat dewarp2() {
        Point3[] para;
        Map<Key, Point3[]> mesh3D = this.toPoint3d();
        int[] widths = new int[2 * (int)this.kSize.width];
        for (int j = 0; j < widths.length; ++j) {
            double sum = 0.0;
            int i = (int)(-this.kSize.height) + 1;
            while ((double)i <= this.kSize.height) {
                para = mesh3D.get(new Key(i, j - (int)this.kSize.width + 1));
                sum += this.euclideanDistance(para[0], para[1]);
                ++i;
            }
            Point3[] para2 = mesh3D.get(new Key((int)this.kSize.height, j - (int)this.kSize.width + 1));
            widths[j] = (int)Math.round((sum += this.euclideanDistance(para2[2], para2[3])) / (2.0 * this.kSize.height + 1.0));
        }
        int[] heights = new int[2 * (int)this.kSize.height];
        for (int i = 0; i < heights.length; ++i) {
            double sum = 0.0;
            int j = (int)(-this.kSize.width) + 1;
            while ((double)j <= this.kSize.width) {
                Point3[] para3 = mesh3D.get(new Key(i - (int)this.kSize.height + 1, j));
                sum += this.euclideanDistance(para3[0], para3[3]);
                ++j;
            }
            para = mesh3D.get(new Key(i - (int)this.kSize.height + 1, (int)this.kSize.width));
            heights[i] = (int)Math.round((sum += this.euclideanDistance(para[1], para[2])) / (2.0 * this.kSize.width + 1.0));
        }
        int totalHeight = this.sum(heights, heights.length);
        int textSep = 20;
        double ratio = (double)totalHeight / (double)heights.length / (double)textSep;
        int i = 0;
        while (i < widths.length) {
            int n = i++;
            widths[n] = (int)((double)widths[n] / ratio);
        }
        i = 0;
        while (i < heights.length) {
            int n = i++;
            heights[n] = (int)((double)heights[n] / ratio);
        }
        int totalWidth = this.sum(widths, widths.length);
        totalHeight = this.sum(heights, heights.length);
        int rectHeight = totalHeight / heights.length;
        Mat dewarpedImage = new Mat(totalHeight + 1, totalWidth + 1, CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
        int i2 = (int)(-this.kSize.height) + 1;
        while ((double)i2 <= this.kSize.height) {
            int x = 0;
            int j = (int)(-this.kSize.width) + 1;
            while ((double)j <= this.kSize.width) {
                int wJ = j + (int)this.kSize.width - 1;
                if (wJ > 0) {
                    x += widths[wJ - 1];
                }
                if (this.inImageBorders(this.mesh.get(new Key(i2, j)))) {
                    int rectWidth = widths[wJ];
                    Rect subImageRect = this.subImageRect(i2, j);
                    int y = (i2 + (int)this.kSize.height) * rectHeight;
                    Mat homography = this.dewarpPolygon(this.mesh.get(new Key(i2, j)), subImageRect, rectHeight, rectWidth);
                    Rect dewarpedRect = new Rect(new Point((double)x, (double)y), new Point((double)(x + rectWidth), (double)(y + rectHeight)));
                    Mat subDewarpedImage = new Mat(dewarpedImage, dewarpedRect);
                    Mat subImage = new Mat(this.image, subImageRect);
                    Imgproc.warpPerspective((Mat)subImage, (Mat)subDewarpedImage, (Mat)homography, (Size)subDewarpedImage.size(), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
                    subImage.release();
                    subDewarpedImage.release();
                    homography.release();
                }
                ++j;
            }
            ++i2;
        }
        return dewarpedImage;
    }

    private int sum(int[] array, int end) {
        int sum = 0;
        for (int i = 0; i < end; ++i) {
            sum += array[i];
        }
        return sum;
    }

    private boolean inImageBorders(Point[] p) {
        for (Point pt : p) {
            if (this.inImageBorders(pt)) continue;
            return false;
        }
        return true;
    }

    private boolean inImageBorders(Point p) {
        return p.x >= 0.0 && p.x < (double)this.image.width() && p.y >= 0.0 && p.y < (double)this.image.height();
    }

    public double ratio(Point3[] parallelogram) {
        double width1 = this.euclideanDistance(parallelogram[0], parallelogram[1]);
        double width2 = this.euclideanDistance(parallelogram[2], parallelogram[3]);
        double height1 = this.euclideanDistance(parallelogram[0], parallelogram[3]);
        double height2 = this.euclideanDistance(parallelogram[2], parallelogram[1]);
        double width = (width1 + width2) / 2.0;
        double height = (height1 + height2) / 2.0;
        double ratio = width / height;
        return ratio;
    }

    private double euclideanDistance(Point3 p1, Point3 p2) {
        return Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y) + (p2.z - p1.z) * (p2.z - p1.z));
    }

    public Mat dewarp() {
        int rectHeight = (int)Math.floor((double)this.image.height() / (2.0 * this.kSize.height));
        int rectWidth = (int)Math.floor((double)this.image.width() / (2.0 * this.kSize.width));
        Mat dewarpedImage = new Mat(this.image.size(), CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
        int i = (int)(-this.kSize.height) + 1;
        while ((double)i <= this.kSize.height) {
            int j = (int)(-this.kSize.width) + 1;
            while ((double)j <= this.kSize.width) {
                if (this.inImageBorders(this.mesh.get(new Key(i, j)))) {
                    Rect subImageRect = this.subImageRect(i, j);
                    Mat homography = this.dewarpPolygon(this.mesh.get(new Key(i, j)), subImageRect, rectHeight, rectWidth);
                    int x = (j + (int)this.kSize.width - 1) * rectWidth;
                    int y = (i + (int)this.kSize.height - 1) * rectHeight;
                    assert (x >= 0 && y >= 0 && x + rectWidth <= dewarpedImage.width() && y + rectHeight <= dewarpedImage.height()) : "x: " + x + ", y: " + y + ", width: " + this.image.width() + ", height: " + this.image.height() + " , rectWidth : " + rectWidth + " , rectHeight : " + rectHeight;
                    Mat subDewarpedImage = new Mat(dewarpedImage, new Rect(new Point((double)x, (double)y), new Point((double)(x + rectWidth), (double)(y + rectHeight))));
                    Mat subImage = new Mat(this.image, subImageRect);
                    Imgproc.warpPerspective((Mat)subImage, (Mat)subDewarpedImage, (Mat)homography, (Size)new Size((double)rectWidth, (double)rectHeight), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
                    subImage.release();
                    subDewarpedImage.release();
                    homography.release();
                }
                ++j;
            }
            ++i;
        }
        return dewarpedImage;
    }

    private Rect subImageRect(int iP, int jP) {
        Point[] polygon = this.mesh.get(new Key(iP, jP));
        assert (polygon != null) : iP + " " + jP;
        Point warpedTopLeft = polygon[0];
        Point warpedTopRight = polygon[1];
        Point warpedBottomRight = polygon[2];
        Point warpedBottomLeft = polygon[3];
        double xMin = Math.min(warpedTopLeft.x, warpedBottomLeft.x);
        double xMax = Math.max(warpedBottomRight.x, warpedTopRight.x);
        double yMin = Math.min(warpedTopRight.y, warpedTopLeft.y);
        double yMax = Math.max(warpedBottomLeft.y, warpedBottomRight.y);
        return new Rect(new Point(xMin, yMin), new Point(xMax, yMax));
    }

    private Mat dewarpPolygon(Point[] polygon, Rect subImageRect, double rectHeight, double rectWidth) {
        Point warpedTopLeft = this.changeOrigin(subImageRect, polygon[0]);
        Point warpedTopRight = this.changeOrigin(subImageRect, polygon[1]);
        Point warpedBottomRight = this.changeOrigin(subImageRect, polygon[2]);
        Point warpedBottomLeft = this.changeOrigin(subImageRect, polygon[3]);
        Point dewarpedTopLeft = new Point(0.0, 0.0);
        Point dewarpedTopRight = new Point(rectWidth, 0.0);
        Point dewarpedBottomRight = new Point(rectWidth, rectHeight);
        Point dewarpedBottomLeft = new Point(0.0, rectHeight);
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{warpedTopLeft, warpedTopRight, warpedBottomRight, warpedBottomLeft}), (Mat)new MatOfPoint2f(new Point[]{dewarpedTopLeft, dewarpedTopRight, dewarpedBottomRight, dewarpedBottomLeft}));
    }

    private Point changeOrigin(Rect subImageRect, Point point) {
        return new Point(point.x - (double)subImageRect.x, point.y - (double)subImageRect.y);
    }

    private void drawPolygon(Mat image, Point[] polygon, Scalar color) {
        Point topLeft = polygon[0];
        Point topRight = polygon[1];
        Point bottomRight = polygon[2];
        Point bottomLeft = polygon[3];
        Imgproc.line((Mat)image, (Point)topLeft, (Point)topRight, (Scalar)color);
        Imgproc.line((Mat)image, (Point)topRight, (Point)bottomRight, (Scalar)color);
        Imgproc.line((Mat)image, (Point)bottomRight, (Point)bottomLeft, (Scalar)color);
        Imgproc.line((Mat)image, (Point)bottomLeft, (Point)topLeft, (Scalar)color);
    }

    private Point[] getPolygon(int i, int j) {
        return this.mesh.get(new Key(i, j));
    }

    private void addFirstPoly(Point imgCenter) {
        Point bottomRight = imgCenter;
        Point topRight = this.verticalMove(bottomRight, -this.deltaY);
        Point bottomLeft = this.horizontalMove(bottomRight, -this.deltaX);
        Point topLeft = this.intersect(topRight, bottomLeft);
        this.points.add(bottomRight);
        this.points.add(topRight);
        this.points.add(bottomLeft);
        this.points.add(topLeft);
        Point[] polygon = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        this.mesh.put(new Key(0, 0), polygon);
    }

    private void addPolygon(int i, int j) {
        Point bottomRight;
        Point bottomLeft;
        Point topRight;
        Point topLeft;
        Point[] abovePolygon = this.getPolygon(i - 1, j);
        Point[] rightPolygon = this.getPolygon(i, j + 1);
        Point[] belowPolygon = this.getPolygon(i + 1, j);
        Point[] leftPolygon = this.getPolygon(i, j - 1);
        if (abovePolygon != null) {
            topLeft = abovePolygon[3];
            topRight = abovePolygon[2];
            if (leftPolygon != null) {
                bottomLeft = leftPolygon[2];
                bottomRight = this.intersect(bottomLeft, topRight);
                this.points.add(bottomRight);
            } else if (rightPolygon != null) {
                bottomRight = rightPolygon[3];
                bottomLeft = this.intersect(bottomRight, topLeft);
                this.points.add(bottomLeft);
            } else {
                assert (j == 0);
                if (i > 0) {
                    bottomLeft = this.verticalMove(topLeft, this.deltaY);
                    bottomRight = this.intersect(bottomLeft, topRight);
                } else {
                    bottomRight = this.verticalMove(topRight, this.deltaY);
                    bottomLeft = this.intersect(topLeft, bottomRight);
                }
                this.points.add(bottomLeft);
                this.points.add(bottomRight);
            }
        } else if (rightPolygon != null) {
            topRight = rightPolygon[0];
            bottomRight = rightPolygon[3];
            if (belowPolygon != null) {
                bottomLeft = belowPolygon[0];
                topLeft = this.intersect(topRight, bottomLeft);
                this.points.add(topLeft);
            } else {
                assert (i == 0);
                if (j > 0) {
                    topLeft = this.horizontalMove(topRight, -this.deltaX);
                    bottomLeft = this.intersect(bottomRight, topLeft);
                } else {
                    bottomLeft = this.horizontalMove(bottomRight, -this.deltaX);
                    topLeft = this.intersect(topRight, bottomLeft);
                }
                this.points.add(topLeft);
                this.points.add(bottomLeft);
            }
        } else if (belowPolygon != null) {
            bottomLeft = belowPolygon[0];
            bottomRight = belowPolygon[1];
            if (leftPolygon != null) {
                topLeft = leftPolygon[1];
                topRight = this.intersect(topLeft, bottomRight);
                this.points.add(topRight);
            } else {
                assert (j == 0);
                if (i > 0) {
                    topLeft = this.verticalMove(bottomLeft, -this.deltaY);
                    topRight = this.intersect(bottomRight, topLeft);
                } else {
                    topRight = this.verticalMove(bottomRight, -this.deltaY);
                    topLeft = this.intersect(topRight, bottomLeft);
                }
                this.points.add(topLeft);
                this.points.add(topRight);
            }
        } else if (leftPolygon != null) {
            assert (i == 0);
            topLeft = leftPolygon[1];
            bottomLeft = leftPolygon[2];
            if (j > 0) {
                topRight = this.horizontalMove(topLeft, this.deltaX);
                bottomRight = this.intersect(bottomLeft, topRight);
            } else {
                bottomRight = this.horizontalMove(bottomLeft, this.deltaX);
                topRight = this.intersect(topLeft, bottomRight);
            }
            this.points.add(topRight);
            this.points.add(bottomRight);
        } else {
            throw new IllegalStateException();
        }
        Point[] polygon = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        this.mesh.put(new Key(i, j), polygon);
    }

    private Point intersect(Point hPoint, Point vPoint) {
        Point intersection = null;
        for (int i = 0; i < 1000; ++i) {
            double xDiff = this.xDiff(hPoint, vPoint);
            double yDiff = this.yDiff(vPoint, hPoint);
            hPoint = this.horizontalMove(hPoint, xDiff);
            vPoint = this.verticalMove(vPoint, yDiff);
            if (!(Math.abs(xDiff) < 0.5) || !(Math.abs(yDiff) < 0.5)) continue;
            intersection = new Point(0.5 * (hPoint.x + vPoint.x), 0.5 * (hPoint.y + vPoint.y));
            return intersection;
        }
        throw new IllegalStateException();
    }

    private double xDiff(Point pt1, Point pt2) {
        return pt2.x - pt1.x;
    }

    private double yDiff(Point pt1, Point pt2) {
        return pt2.y - pt1.y;
    }

    private Point verticalMove(Point startingPoint, double deltaY) {
        double dY = deltaY / (double)this.nbIter;
        double x = startingPoint.x;
        double y = startingPoint.y;
        for (int i = 0; i < this.nbIter; ++i) {
            double[] angles = this.interpolator.interpolate(x - (double)this.xBorder, y - (double)this.yBorder);
            double dX = dY / Math.tan(angles[1]);
            x += dX;
            y += dY;
        }
        return new Point(x, y);
    }

    private Point horizontalMove(Point startingPoint, double deltaX) {
        double dX = deltaX / (double)this.nbIter;
        double x = startingPoint.x;
        double y = startingPoint.y;
        for (int i = 0; i < this.nbIter; ++i) {
            double[] angles = this.interpolator.interpolate(x - (double)this.xBorder, y - (double)this.yBorder);
            double dY = Math.tan(angles[0]) * dX;
            x += dX;
            y += dY;
        }
        return new Point(x, y);
    }

    private class Key {
        public int i;
        public int j;

        public Key(int i, int j) {
            this.i = i;
            this.j = j;
        }

        public int hashCode() {
            return 31 * this.i + 7 * this.j;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.i == other.i && this.j == other.j;
        }
    }
}

