/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.List;
import org.genericsystem.cv.application.Interpolator;
import org.genericsystem.cv.application.SuperContour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridInterpolator
implements Interpolator {
    private static final Logger logger = LoggerFactory.getLogger(GridInterpolator.class);
    private int[] sampleSkewXs;
    private int[] sampleSkewYs;
    private double[][] skewDirs;
    private final List<SuperContour> superContours;
    private double hCoef = 0.0;
    private double hAngle = 0.0;
    private double sumHCoefs = 0.0;

    public GridInterpolator(List<SuperContour> superContours, List<Integer> patchXs, List<Integer> patchYs, int[][] dirs, int nSide, int nBin) {
        int i;
        this.superContours = superContours;
        this.sampleSkewXs = new int[patchXs.size()];
        for (i = 0; i < patchXs.size(); ++i) {
            this.sampleSkewXs[i] = patchXs.get(i) + nSide / 2;
        }
        this.sampleSkewYs = new int[patchYs.size()];
        for (i = 0; i < patchYs.size(); ++i) {
            this.sampleSkewYs[i] = patchYs.get(i) + nSide / 2;
        }
        this.skewDirs = new double[dirs.length][dirs[0].length];
        for (i = 0; i < this.skewDirs.length; ++i) {
            for (int j = 0; j < this.skewDirs[0].length; ++j) {
                double angle = Math.PI * (double)(dirs[i][j] - 1) / (double)nBin;
                if (angle >= Math.PI) {
                    angle -= Math.PI;
                }
                this.skewDirs[i][j] = angle;
            }
        }
    }

    private double squaredEuclidianDistance(double x, double y, SuperContour sc) {
        double minDist;
        double result = Math.pow(x - sc.center.x, 2.0) + Math.pow(y - sc.center.y, 2.0);
        return result >= Math.pow(minDist = 30.0, 2.0) ? result : Math.pow(minDist, 2.0);
    }

    @Override
    public double[] interpolate(double x, double y) {
        LambdaSearchResult xLambda = this.lambdaSearch(this.sampleSkewXs, x);
        LambdaSearchResult yLambda = this.lambdaSearch(this.sampleSkewYs, y);
        double vAngle = (1.0 - xLambda.lambda) * ((1.0 - yLambda.lambda) * this.skewDirs[yLambda.indB][xLambda.indB] + yLambda.lambda * this.skewDirs[yLambda.indE][xLambda.indB]) + xLambda.lambda * ((1.0 - yLambda.lambda) * this.skewDirs[yLambda.indB][xLambda.indE] + yLambda.lambda * this.skewDirs[yLambda.indE][xLambda.indE]);
        this.sumHCoefs = 0.0;
        this.hAngle = 0.0;
        this.superContours.forEach(sc -> {
            double geoCoef = Math.pow(1.0 / (this.squaredEuclidianDistance(x, y, (SuperContour)sc) + 1.0E-5), 1.5);
            this.hCoef = geoCoef * sc.dx;
            this.hAngle += this.hCoef * sc.angle;
            this.sumHCoefs += this.hCoef;
        });
        return new double[]{this.hAngle / this.sumHCoefs, vAngle};
    }

    private LambdaSearchResult lambdaSearch(int[] xs, double x) {
        int indB;
        int indE = 0;
        double lambda = 0.0;
        for (indB = xs.length - 1; indB >= 0 && x < (double)xs[indB]; --indB) {
        }
        if (indB == xs.length - 1) {
            indE = indB;
        } else if (indB == -1) {
            ++indB;
        } else {
            indE = indB + 1;
            lambda = (x - (double)xs[indB]) / (double)(xs[indE] - xs[indB]);
        }
        return new LambdaSearchResult(indB, indE, lambda);
    }

    static class LambdaSearchResult {
        final int indB;
        final int indE;
        final double lambda;

        public LambdaSearchResult(int indB, int indE, double lambda) {
            this.indB = indB;
            this.indE = indE;
            this.lambda = lambda;
        }

        public String toString() {
            return "{ indB: " + this.indB + ", indE: " + this.indE + ", lambda: " + this.lambda + " }";
        }
    }
}

