/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.Deperspectiver;
import org.genericsystem.cv.application.DirectionalFilter;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.ImgDescriptor;
import org.genericsystem.cv.application.MeshGrid;
import org.genericsystem.cv.application.ReferenceManager;
import org.genericsystem.cv.application.SuperContour;
import org.genericsystem.cv.application.SuperContourInterpolator;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.application.SuperTemplate;
import org.genericsystem.cv.application.TextOrientationLinesDetector;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.layout.Layout;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class GraphicApp
extends AbstractApp {
    private final double f = 672.5555555555555;
    private final GSCapture gsCapture = new GSVideoCapture(0, 672.5555555555555, GSVideoCapture.HD, GSVideoCapture.VGA);
    private SuperFrameImg superFrame;
    private ReferenceManager referenceManager;
    private Config config = new Config();
    private Deperspectiver deperspectiver;
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        GraphicApp.launch((String[])args);
    }

    public GraphicApp() {
        this.superFrame = this.gsCapture.read();
        this.deperspectiver = new Deperspectiver(672.5555555555555, this.superFrame.getPp());
        this.referenceManager = new ReferenceManager(this.gsCapture.getResize());
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth(this.superFrame.width() / displaySizeReduction);
                imageView.setFitHeight(this.superFrame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 300L, 30L, TimeUnit.MILLISECONDS);
    }

    private Image[] doWork() {
        Calibrated[] calibratedVps;
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.superFrame = this.gsCapture.read();
        }
        Image[] images = new Image[10];
        Lines lines = this.superFrame.detectLines();
        if (this.config.textsEnabledMode) {
            lines.getLines().addAll(this.superFrame.findTextOrientationLines());
        }
        if ((calibratedVps = this.deperspectiver.computeCalibratedVps(this.superFrame, lines)) == null) {
            return null;
        }
        Mat deperspectiveHomography = this.deperspectiver.findHomography(this.superFrame, (Calibrated.AngleCalibrated[])calibratedVps);
        if (deperspectiveHomography == null) {
            return null;
        }
        this.superFrame.draw(lines, new Scalar(0.0, 0.0, 255.0), 1);
        this.superFrame.drawVanishingPointLines(lines, calibratedVps[0], new Scalar(0.0, 255.0, 0.0), 1);
        this.superFrame.drawVanishingPointLines(lines, calibratedVps[1], new Scalar(255.0, 0.0, 0.0), 1);
        this.superFrame.drawVpsArrows(calibratedVps, new double[]{20.0, 20.0}, new Scalar(0.0, 255.0, 0.0), 2);
        images[0] = this.superFrame.getDisplay().toJfxImage();
        SuperTemplate superDeperspectived = this.superFrame.deperspective(deperspectiveHomography);
        images[1] = this.superFrame.getDiffFrame().toJfxImage();
        List<Rect> detectedRects = superDeperspectived.detectRects();
        superDeperspectived.drawRects(detectedRects, new Scalar(0.0, 255.0, 0.0), -1);
        SuperTemplate surfaceTemplate = new SuperTemplate(new SuperFrameImg(superDeperspectived.getDisplay().bgr2Gray().getSrc(), this.superFrame.getPp(), 672.5555555555555), CvType.CV_8UC1, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getDisplay));
        Layout surfaceLayout = surfaceTemplate.layout();
        double surface = surfaceLayout.normalizedArea();
        superDeperspectived.putText(String.valueOf(surface));
        images[2] = superDeperspectived.getFrame().toJfxImage();
        SuperTemplate superReferenceTemplate4 = new SuperTemplate(this.superFrame, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        List detectedSuperContours = superReferenceTemplate4.detectSuperContours(20.0).stream().filter(sc -> Math.abs(sc.angle) < 0.7853981633974483).collect(Collectors.toList());
        detectedSuperContours.stream().forEach(c -> Imgproc.line((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)c.top, (Point)c.bottom, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1));
        detectedSuperContours.stream().forEach(c -> Imgproc.line((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)c.left, (Point)c.right, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1));
        detectedSuperContours.stream().map(sc -> sc.center).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.left).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.right).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.top).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 255.0, 255.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.bottom).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(255.0, 0.0, 255.0), (int)-1));
        images[3] = superReferenceTemplate4.getDisplay().toJfxImage();
        SuperTemplate superReferenceTemplate5 = new SuperTemplate(this.superFrame, CvType.CV_8UC3, SuperFrameImg::getFrame){

            @Override
            protected Img buildDisplay() {
                return new Img(this.getFrame().getSrc(), true);
            }
        };
        List<SuperContour> filteredSuperContour = new ArrayList<SuperContour>(TextOrientationLinesDetector.selectRandomObjects(superReferenceTemplate5.detectSuperContours(20.0).stream().filter(sc -> Math.abs(sc.angle) < 0.7853981633974483 && sc.dx > 2.0 * sc.dy).collect(Collectors.toList()), 200));
        DirectionalFilter df = new DirectionalFilter();
        int nBin = 64;
        Mat gray = superReferenceTemplate5.getFrame().bgr2Gray().getSrc();
        Mat gx = df.gx(gray);
        Core.subtract((Mat)Mat.zeros((Size)gx.size(), (int)gx.type()), (Mat)gx, (Mat)gx);
        Mat gy = df.gy(gray);
        Mat mag = new Mat();
        Mat ori = new Mat();
        Core.cartToPolar((Mat)gx, (Mat)gy, (Mat)mag, (Mat)ori);
        int[][] bin = df.bin(ori, nBin);
        List<SuperFrameImg.Span> spans = superReferenceTemplate5.assembleContours(filteredSuperContour, c -> true, 100.0, 30.0, 70.0);
        double regionSize = 100.0;
        filteredSuperContour = filteredSuperContour.stream().filter(sc -> sc.center.x - regionSize > 0.0 && sc.center.x + regionSize / 2.0 < (double)superReferenceTemplate5.getFrame().width() && sc.center.y - regionSize / 2.0 > 0.0 && sc.center.y + regionSize / 2.0 < (double)superReferenceTemplate5.getFrame().height()).collect(Collectors.toList());
        filteredSuperContour.forEach(sc -> sc.computeHisto(mag, bin, nBin, df, 150.0));
        Mat image = superReferenceTemplate5.getDisplay().getSrc();
        SuperContourInterpolator interpolator = new SuperContourInterpolator(filteredSuperContour, 2.0);
        MeshGrid meshGrid = new MeshGrid(new Size(16.0, 9.0), interpolator, 20.0, 20.0, superReferenceTemplate5.getFrame().getSrc());
        meshGrid.build();
        filteredSuperContour.stream().forEach(c -> Imgproc.line((Mat)image, (Point)c.top, (Point)c.bottom, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1));
        filteredSuperContour.stream().forEach(c -> Imgproc.line((Mat)image, (Point)c.vBottom, (Point)c.vTop, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)2));
        images[4] = new Img(meshGrid.drawOnCopy(new Scalar(0.0, 255.0, 0.0))).toJfxImage();
        images[5] = new Img(meshGrid.dewarp(), false).toJfxImage();
        SuperTemplate superReferenceTemplate2 = new SuperTemplate(superReferenceTemplate5, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        spans.forEach(sp -> {
            double a = Math.random() * 255.0;
            double b = Math.random() * 255.0;
            double c = Math.random() * 255.0;
            Scalar color = new Scalar(a, b, c);
            sp.getContours().forEach(ct -> Imgproc.drawContours((Mat)superReferenceTemplate2.getDisplay().getSrc(), Arrays.asList(ct.contour), (int)0, (Scalar)color, (int)-1));
            if (!sp.getContours().isEmpty()) {
                Point[] pointer = new Point[]{sp.getContours().get((int)0).center};
                sp.getContours().forEach(ct -> {
                    Imgproc.line((Mat)superReferenceTemplate2.getDisplay().getSrc(), (Point)pointer[0], (Point)ct.center, (Scalar)color, (int)1);
                    pointer[0] = ct.center;
                });
            }
        });
        images[6] = superReferenceTemplate2.getDisplay().toJfxImage();
        ImgDescriptor newImgDescriptor = new ImgDescriptor(superDeperspectived, surface);
        if (newImgDescriptor.getDescriptors().empty()) {
            System.out.println("Empty descriptors");
            return null;
        }
        this.referenceManager.submit(newImgDescriptor, detectedRects);
        List<Rect> referenceRects = this.referenceManager.getReferenceRects();
        SuperTemplate referenceTemplate = new SuperTemplate(this.referenceManager.getReference().getSuperFrame(), CvType.CV_8UC1, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        referenceTemplate.drawRects(referenceRects, new Scalar(255.0), -1);
        images[7] = referenceTemplate.getDisplay().toJfxImage();
        SuperTemplate superReferenceTemplate3 = new SuperTemplate(this.superFrame, CvType.CV_8UC1, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        superReferenceTemplate3.drawRects(this.referenceManager.getResizedFieldsRects(), new Scalar(255.0), -1);
        images[8] = superReferenceTemplate3.getDisplay().toJfxImage();
        SuperTemplate layoutTemplate = new SuperTemplate(referenceTemplate, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getDisplay));
        Layout layout = layoutTemplate.layout();
        layoutTemplate.drawLayout(layout);
        images[9] = layoutTemplate.getDisplay().toJfxImage();
        return images;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onR() {
        this.timer.schedule(() -> this.referenceManager.clear(), 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void onT() {
        this.config.textsEnabledMode = !this.config.textsEnabledMode;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

