/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.List;
import org.genericsystem.cv.application.Interpolator;
import org.opencv.core.Point;

public class GeneralInterpolator
implements Interpolator {
    private final double pow;
    private List<OrientedPoint> horizontals;
    private List<OrientedPoint> verticals;
    private double hCoef;
    private double vCoef;
    private double sumHCoefs;
    private double sumVCoefs;
    private double hAngle;
    private double vAngle;

    public GeneralInterpolator(List<OrientedPoint> horizontals, List<OrientedPoint> verticals, double pow) {
        this.horizontals = horizontals;
        this.verticals = verticals;
        this.pow = pow;
    }

    private double squaredEuclidianDistance(double x, double y, OrientedPoint op) {
        double minDist;
        double result = Math.pow(x - ((OrientedPoint)op).center.x, 2.0) + Math.pow(y - ((OrientedPoint)op).center.y, 2.0);
        return result >= Math.pow(minDist = 10.0, 2.0) ? result : Math.pow(minDist, 2.0);
    }

    @Override
    public double[] interpolate(double x, double y) {
        this.sumHCoefs = 0.0;
        this.sumVCoefs = 0.0;
        this.hAngle = 0.0;
        this.vAngle = 0.0;
        this.horizontals.forEach(h -> {
            double geoCoef = Math.pow(1.0 / this.squaredEuclidianDistance(x, y, (OrientedPoint)h), this.pow / 2.0);
            this.hCoef = geoCoef * ((OrientedPoint)h).strenght;
            this.hAngle += this.hCoef * ((OrientedPoint)h).angle;
            this.sumHCoefs += this.hCoef;
        });
        this.verticals.forEach(v -> {
            double geoCoef = Math.pow(1.0 / (this.squaredEuclidianDistance(x, y, (OrientedPoint)v) + 1.0E-5), this.pow / 2.0);
            this.vCoef = geoCoef * ((OrientedPoint)v).strenght;
            this.vAngle += this.vCoef * ((OrientedPoint)v).angle;
            this.sumVCoefs += this.vCoef;
        });
        return new double[]{this.hAngle / this.sumHCoefs, this.vAngle / this.sumVCoefs};
    }

    public static class OrientedPoint {
        private Point center;
        private double strenght;
        private double angle;

        public OrientedPoint(Point center, double angle, double strenght) {
            this.center = center;
            this.strenght = strenght;
            this.angle = angle;
        }
    }
}

