/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class MotionDetector {
    public static void main(String[] args) {
        JFrame jframe = new JFrame("Motion Detector");
        jframe.setResizable(false);
        jframe.setDefaultCloseOperation(3);
        JLabel vidpanel = new JLabel();
        jframe.setContentPane(vidpanel);
        Mat frame = new Mat();
        VideoCapture camera = new VideoCapture(0);
        camera.read(frame);
        jframe.setSize(frame.width(), frame.height());
        jframe.setVisible(true);
        while (camera.read(frame)) {
            Mat diffFrame = new Mat();
            Core.absdiff((Mat)MotionDetector.adjust(frame), (Scalar)new Scalar(255.0), (Mat)diffFrame);
            Imgproc.adaptiveThreshold((Mat)diffFrame, (Mat)diffFrame, (double)255.0, (int)0, (int)1, (int)7, (double)3.0);
            for (Rect rect : MotionDetector.detection_contours(frame, diffFrame)) {
                Imgproc.rectangle((Mat)frame, (Point)rect.br(), (Point)rect.tl(), (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
            }
            ImageIcon image = new ImageIcon(MotionDetector.mat2bufferedImage(frame));
            vidpanel.setIcon(image);
            vidpanel.repaint();
        }
    }

    public static List<Rect> detection_contours(Mat frame, Mat diffFrame) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)diffFrame, contours, (Mat)new Mat(), (int)0, (int)2);
        double maxArea = 10.0;
        ArrayList<Rect> rectangles = new ArrayList<Rect>();
        for (int i = 0; i < contours.size(); ++i) {
            MatOfPoint contour = (MatOfPoint)contours.get(i);
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > maxArea)) continue;
            MatOfPoint2f contour2F = new MatOfPoint2f(contour.toArray());
            Point[] result = new Point[4];
            Imgproc.minAreaRect((MatOfPoint2f)contour2F).points(result);
            Imgproc.drawContours((Mat)frame, Arrays.asList(new MatOfPoint(result)), (int)0, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)1);
            rectangles.add(Imgproc.boundingRect((MatOfPoint)contour));
            Imgproc.drawContours((Mat)frame, contours, (int)i, (Scalar)new Scalar(0.0, 255.0, 0.0));
        }
        return rectangles;
    }

    public static Mat adjust(Mat frame) {
        Mat result = new Mat();
        Imgproc.cvtColor((Mat)frame, (Mat)result, (int)6);
        Imgproc.GaussianBlur((Mat)result, (Mat)result, (Size)new Size(3.0, 3.0), (double)0.0);
        return result;
    }

    public static BufferedImage mat2bufferedImage(Mat image) {
        MatOfByte bytemat = new MatOfByte();
        Imgcodecs.imencode((String)".jpg", (Mat)image, (MatOfByte)bytemat);
        try {
            return ImageIO.read(new ByteArrayInputStream(bytemat.toArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        NativeLibraryLoader.load();
    }
}

