/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.swing.ImageIcon;
import org.genericsystem.cv.FaceDetector;
import org.genericsystem.cv.Zone;
import org.genericsystem.cv.utils.Tools;
import org.genericsystem.layout.Layout;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.KeyPoint;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.features2d.FeatureDetector;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.CLAHE;
import org.opencv.imgproc.Imgproc;
import org.opencv.objdetect.HOGDescriptor;
import org.opencv.photo.Photo;
import org.opencv.utils.Converters;
import org.opencv.ximgproc.Ximgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Img
implements AutoCloseable,
Serializable {
    private static Logger log = LoggerFactory.getLogger(Img.class);
    private final Mat src;

    public Mat getSrc() {
        return this.src;
    }

    public Img(String path) {
        this(Imgcodecs.imread((String)path), false);
    }

    public Img(Mat src) {
        this(src, true);
    }

    public Img(Mat src, boolean clone) {
        if (clone) {
            this.src = new Mat();
            src.copyTo(this.src);
        } else {
            this.src = src;
        }
    }

    public Img(Img model, Zone zone) {
        this.src = new Mat(model.getSrc(), zone.getRect());
    }

    public Img(Img model, Layout shard) {
        this.src = new Mat(model.getSrc(), new Rect(new Point(shard.getX1() * (double)model.width(), shard.getY1() * (double)model.height()), new Point(shard.getX2() * (double)model.width(), shard.getY2() * (double)model.height())));
    }

    public Img morphologyEx(int morphOp, int morph, Size size) {
        Mat result = new Mat();
        Imgproc.morphologyEx((Mat)this.src, (Mat)result, (int)morphOp, (Mat)Imgproc.getStructuringElement((int)morph, (Size)size));
        return new Img(result, false);
    }

    public Img laplacian() {
        return this.laplacian(0);
    }

    public Img laplacian(int ddepth) {
        Mat result = new Mat();
        Imgproc.Laplacian((Mat)this.src, (Mat)result, (int)ddepth);
        return new Img(result, false);
    }

    public List<MatOfPoint> findContours(Img[] hierarchy, int mode, int method) {
        Mat mat = new Mat();
        ArrayList<MatOfPoint> result = new ArrayList<MatOfPoint>();
        Imgproc.findContours((Mat)this.src, result, (Mat)mat, (int)mode, (int)method);
        hierarchy[0] = new Img(mat, false);
        return result;
    }

    public List<MatOfPoint> findContours(Img[] hierarchy, int mode, int method, Point point) {
        Mat mat = new Mat();
        ArrayList<MatOfPoint> result = new ArrayList<MatOfPoint>();
        Imgproc.findContours((Mat)this.src, result, (Mat)mat, (int)mode, (int)method, (Point)point);
        hierarchy[0] = new Img(mat, false);
        return result;
    }

    public Img dilate(Mat kernel) {
        Mat result = new Mat();
        Imgproc.dilate((Mat)this.src, (Mat)result, (Mat)kernel);
        return new Img(result, false);
    }

    public Img canny(double threshold1, double threshold2) {
        Mat result = new Mat();
        Imgproc.Canny((Mat)this.src, (Mat)result, (double)threshold1, (double)threshold2);
        return new Img(result, false);
    }

    public Img canny(double threshold1, double threshold2, int apertureSize, boolean L2gradient) {
        Mat result = new Mat();
        Imgproc.Canny((Mat)this.src, (Mat)result, (double)threshold1, (double)threshold2, (int)apertureSize, (boolean)L2gradient);
        return new Img(result, false);
    }

    public void drawContours(List<MatOfPoint> contours, int contourIdx, Scalar color, int thickness) {
        Imgproc.drawContours((Mat)this.src, contours, (int)contourIdx, (Scalar)color, (int)thickness);
    }

    public Img gaussianBlur(Size ksize, double sigmaX, double sigmaY) {
        Mat result = new Mat();
        Imgproc.GaussianBlur((Mat)this.src, (Mat)result, (Size)ksize, (double)sigmaX, (double)sigmaY);
        return new Img(result, false);
    }

    public Img medianBlur(int ksize) {
        Mat result = new Mat();
        Imgproc.medianBlur((Mat)this.src, (Mat)result, (int)ksize);
        return new Img(result, false);
    }

    public Img bgr2Gray() {
        Mat result = new Mat();
        Imgproc.cvtColor((Mat)this.src, (Mat)result, (int)6);
        return new Img(result, false);
    }

    private static double angle(Point p1, Point p2, Point p0) {
        double dx1 = p1.x - p0.x;
        double dy1 = p1.y - p0.y;
        double dx2 = p2.x - p0.x;
        double dy2 = p2.y - p0.y;
        return (dx1 * dx2 + dy1 * dy2) / Math.sqrt((dx1 * dx1 + dy1 * dy1) * (dx2 * dx2 + dy2 * dy2) + 1.0E-10);
    }

    public Img cropAndDeskew() {
        Img blurred = this.medianBlur(9);
        Img gray = this.src.channels() == 1 ? blurred : blurred.bgr2Gray();
        List<Object> contours = new ArrayList();
        double maxArea = 0.0;
        int maxId = -1;
        MatOfPoint2f maxContour = null;
        Img gray_ = gray.canny(10.0, 20.0, 3, true);
        gray_ = gray_.dilate(Imgproc.getStructuringElement((int)1, (Size)new Size(12.0, 12.0)));
        contours = gray_.findContours(new Img[1], 1, 2);
        for (MatOfPoint matOfPoint : contours) {
            MatOfPoint2f temp = new MatOfPoint2f(matOfPoint.toArray());
            double area = Imgproc.contourArea((Mat)matOfPoint);
            MatOfPoint2f approxCurve = new MatOfPoint2f();
            Imgproc.approxPolyDP((MatOfPoint2f)temp, (MatOfPoint2f)approxCurve, (double)(Imgproc.arcLength((MatOfPoint2f)temp, (boolean)true) * 0.02), (boolean)true);
            if (approxCurve.total() != 4L || !(area >= maxArea)) continue;
            double maxCosine = 0.0;
            List curves = approxCurve.toList();
            for (int j = 2; j < 5; ++j) {
                double cosine = Math.abs(Img.angle((Point)curves.get(j % 4), (Point)curves.get(j - 2), (Point)curves.get(j - 1)));
                maxCosine = Math.max(maxCosine, cosine);
            }
            if (!(maxCosine < 0.3)) continue;
            maxArea = area;
            maxId = contours.indexOf(matOfPoint);
            maxContour = approxCurve;
        }
        Img result = maxId >= 0 ? this.transform(maxContour) : new Img(this.src);
        blurred.close();
        gray.close();
        gray_.close();
        return result;
    }

    public Img transform(MatOfPoint2f contour2f) {
        double slope;
        ArrayList<Point> list = new ArrayList<Point>(Arrays.asList(contour2f.toArray()));
        if (this.isClockwise(list)) {
            Point second = (Point)list.remove(3);
            Point fourth = (Point)list.remove(1);
            list.add(1, second);
            list.add(fourth);
        }
        int yMinIndex = 0;
        int xMinIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            double xCurr = ((Point)list.get((int)i)).x;
            double xMin = ((Point)list.get((int)xMinIndex)).x;
            double yCurr = ((Point)list.get((int)i)).y;
            double yMin = ((Point)list.get((int)yMinIndex)).y;
            if (xCurr < xMin || xCurr == xMin && yCurr < ((Point)list.get((int)xMinIndex)).y) {
                xMinIndex = i;
            }
            if (!(yCurr < yMin) && (yCurr != yMin || !(xCurr < ((Point)list.get((int)yMinIndex)).x))) continue;
            yMinIndex = i;
        }
        int tlIndex = yMinIndex;
        if (yMinIndex != xMinIndex && (slope = (((Point)list.get((int)xMinIndex)).y - ((Point)list.get((int)yMinIndex)).y) / (((Point)list.get((int)yMinIndex)).x - ((Point)list.get((int)xMinIndex)).x)) < 1.0) {
            tlIndex = xMinIndex;
        }
        for (int i = 0; i < tlIndex; ++i) {
            list.add((Point)list.remove(0));
        }
        double height = this.distance((Point)list.get(0), (Point)list.get(1));
        double width = this.distance((Point)list.get(1), (Point)list.get(2));
        Mat target = new Mat();
        LinkedList<Point> targets = new LinkedList<Point>(Arrays.asList(new Point(0.0, 0.0), new Point(0.0, height), new Point(width, height), new Point(width, 0.0)));
        Imgproc.warpPerspective((Mat)this.src, (Mat)target, (Mat)Imgproc.getPerspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(list), (Mat)Converters.vector_Point2f_to_Mat(targets)), (Size)new Size(width, height), (int)2);
        Img result = new Img(target, false);
        int orientation = result.getOrientation();
        if (orientation != 0) {
            result = result.rotate(orientation);
        }
        return result;
    }

    private double distance(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0));
    }

    public Img rotate(int angle) {
        Mat result = new Mat();
        if (angle == 90) {
            Core.transpose((Mat)this.src, (Mat)result);
            Core.flip((Mat)result, (Mat)result, (int)0);
        }
        if (angle == 180) {
            Core.flip((Mat)this.src, (Mat)result, (int)-1);
        }
        if (angle == 270) {
            Core.transpose((Mat)this.src, (Mat)result);
            Core.flip((Mat)result, (Mat)result, (int)1);
        }
        return new Img(result, false);
    }

    private boolean isClockwise(List<Point> points) {
        Point p1 = points.get(0);
        Point p2 = points.get(1);
        Point p3 = points.get(2);
        return (p2.x - p1.x) * (p3.y - p2.y) - (p2.y - p1.y) * (p3.x - p2.x) >= 0.0;
    }

    public int getOrientation() {
        try {
            File tmpFile = File.createTempFile("orientation", ".png");
            tmpFile.deleteOnExit();
            Imgcodecs.imwrite((String)tmpFile.toString(), (Mat)this.src);
            Process process = Runtime.getRuntime().exec(new String[]{"../gs-cv/orientation.sh", tmpFile.toString()});
            process.waitFor();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            return Integer.valueOf(stdInput.readLine());
        }
        catch (IOException | InterruptedException e) {
            log.warn("Impossible to detect file orientation, returning 0.", (Throwable)e);
            return 0;
        }
    }

    public Size size() {
        return this.src.size();
    }

    public int height() {
        return this.src.height();
    }

    public int width() {
        return this.src.width();
    }

    public double[] get(int row, int col) {
        return this.src.get(row, col);
    }

    public Img cvtColor(int code) {
        Mat result = new Mat();
        Imgproc.cvtColor((Mat)this.src, (Mat)result, (int)code);
        return new Img(result, false);
    }

    public ImageIcon getImageIcon() {
        return new ImageIcon(Tools.mat2bufferedImage(this.src));
    }

    public void rectangle(Rect rect, Scalar color, int thickNess) {
        Imgproc.rectangle((Mat)this.src, (Point)rect.br(), (Point)rect.tl(), (Scalar)color, (int)thickNess);
    }

    public ImageView getImageView() {
        return this.getImageView(400.0);
    }

    public ImageView getImageView(double width) {
        Mat conv = new Mat();
        this.src.convertTo(conv, CvType.CV_8UC1);
        Mat target = new Mat();
        Imgproc.resize((Mat)conv, (Mat)target, (Size)new Size(width, Math.floor(width / (double)conv.width() * (double)conv.height())));
        MatOfByte buffer = new MatOfByte();
        Imgcodecs.imencode((String)".png", (Mat)target, (MatOfByte)buffer);
        ImageView imageView = new ImageView(new Image((InputStream)new ByteArrayInputStream(buffer.toArray())));
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(width);
        return imageView;
    }

    public int channels() {
        return this.src.channels();
    }

    public Img range(Scalar scalar, Scalar scalar2, boolean hsv) {
        Img ranged = this;
        if (hsv) {
            ranged = ranged.cvtColor(40);
        }
        Mat result = new Mat(ranged.size(), ranged.type(), new Scalar(0.0, 0.0, 0.0));
        Mat mask = new Mat();
        Core.inRange((Mat)ranged.getSrc(), (Scalar)scalar, (Scalar)scalar2, (Mat)mask);
        ranged.getSrc().copyTo(result, mask);
        Img resultImg = new Img(result, false);
        if (hsv) {
            resultImg = resultImg.cvtColor(54);
        }
        return resultImg;
    }

    public int type() {
        return this.src.type();
    }

    public Img gaussianBlur(Size size) {
        Mat result = new Mat();
        Imgproc.GaussianBlur((Mat)this.src, (Mat)result, (Size)size, (double)0.0);
        return new Img(result, false);
    }

    public Img multiply(Scalar scalar) {
        Mat result = new Mat();
        Core.multiply((Mat)this.src, (Scalar)scalar, (Mat)result);
        return new Img(result, false);
    }

    public Img mser() {
        Img gray = this.bgr2Gray();
        MatOfKeyPoint keypoint = new MatOfKeyPoint();
        FeatureDetector detector = FeatureDetector.create((int)6);
        detector.detect(gray.getSrc(), keypoint);
        List listpoint = keypoint.toList();
        Mat result = Mat.zeros((Size)gray.size(), (int)CvType.CV_8UC1);
        for (int ind = 0; ind < listpoint.size(); ++ind) {
            KeyPoint kpoint = (KeyPoint)listpoint.get(ind);
            int rectanx1 = (int)(kpoint.pt.x - 0.5 * (double)kpoint.size);
            int rectany1 = (int)(kpoint.pt.y - 0.5 * (double)kpoint.size);
            int width = (int)kpoint.size;
            int height = (int)kpoint.size;
            if (rectanx1 <= 0) {
                rectanx1 = 1;
            }
            if (rectany1 <= 0) {
                rectany1 = 1;
            }
            if (rectanx1 + width > gray.width()) {
                width = gray.width() - rectanx1;
            }
            if (rectany1 + height > gray.height()) {
                height = gray.height() - rectany1;
            }
            Rect rectant = new Rect(rectanx1, rectany1, width, height);
            Mat roi = new Mat(result, rectant);
            roi.setTo(new Scalar(255.0));
        }
        Img img = new Img(result, false);
        Img result_ = img.morphologyEx(3, 0, new Size(17.0, 3.0));
        img.close();
        return result_;
    }

    public Img grad(double k1, double k2) {
        Img grad = this.morphologyEx(4, 0, new Size(k1, k2));
        return grad;
    }

    public Img sobel() {
        Img gray = this.bgr2Gray();
        Img sobel = gray.sobel(CvType.CV_8UC1, 3, 0, 5, 1.0, 10.0, 4);
        return sobel;
    }

    public Img bernsen() {
        return this.bernsen(31, 15);
    }

    public Img otsu() {
        return this.bgr2Gray().thresHold(0.0, 255.0, 8);
    }

    public Img otsuAfterGaussianBlur() {
        return this.otsuAfterGaussianBlur(new Size(5.0, 5.0));
    }

    public Img otsuInv() {
        return this.bgr2Gray().thresHold(0.0, 255.0, 9);
    }

    public Img equalizeHisto() {
        Mat result = new Mat();
        ArrayList channels = new ArrayList();
        Core.split((Mat)this.src, channels);
        Imgproc.equalizeHist((Mat)((Mat)channels.get(0)), (Mat)((Mat)channels.get(0)));
        Imgproc.equalizeHist((Mat)((Mat)channels.get(1)), (Mat)((Mat)channels.get(1)));
        Imgproc.equalizeHist((Mat)((Mat)channels.get(2)), (Mat)((Mat)channels.get(2)));
        Core.merge(channels, (Mat)result);
        for (Mat channel : channels) {
            channel.release();
        }
        return new Img(result, false);
    }

    public Img resize() {
        Mat result = new Mat();
        Imgproc.resize((Mat)this.src, (Mat)result, (Size)new Size(50.0, 50.0), (double)10.0, (double)10.0, (int)3);
        return new Img(result, false);
    }

    public Img equalizeHistoAdaptative() {
        CLAHE clahe = Imgproc.createCLAHE((double)2.0, (Size)new Size(8.0, 8.0));
        Mat result = new Mat();
        ArrayList channels = new ArrayList();
        Core.split((Mat)this.src, channels);
        clahe.apply((Mat)channels.get(0), (Mat)channels.get(0));
        clahe.apply((Mat)channels.get(1), (Mat)channels.get(1));
        clahe.apply((Mat)channels.get(2), (Mat)channels.get(2));
        Core.merge(channels, (Mat)result);
        for (Mat channel : channels) {
            channel.release();
        }
        return new Img(result, false);
    }

    public Img equalizeHistoAdaptative2() {
        return this.equalizeHistoAdaptative(2.0, new Size(8.0, 8.0));
    }

    public Img adaptativeMeanThreshold() {
        return this.adaptativeMeanThreshold(11, 2.0);
    }

    public Img adaptativeGaussianThreshold() {
        return this.adaptativeGaussianThreshold(11, 2.0);
    }

    public Img niblackThreshold() {
        return this.niblackThreshold(17, 0.1);
    }

    public Img sauvolaThreshold() {
        return this.sauvolaThreshold(17, 0.3);
    }

    public Img nickThreshold() {
        return this.nickThreshold(11, 0.1);
    }

    public Img wolfThreshold() {
        return this.wolfThreshold(11, 0.3);
    }

    public Img equalizeHistoAdaptative(double clipLimit, Size titleGridSize) {
        Mat result = new Mat();
        Mat channelL = new Mat();
        CLAHE clahe = Imgproc.createCLAHE((double)clipLimit, (Size)titleGridSize);
        Core.extractChannel((Mat)result, (Mat)channelL, (int)0);
        clahe.apply(channelL, channelL);
        Core.insertChannel((Mat)channelL, (Mat)result, (int)0);
        Imgproc.cvtColor((Mat)result, (Mat)result, (int)56);
        channelL.release();
        return new Img(result, false);
    }

    public Img otsuAfterGaussianBlur(Size blurSize) {
        return this.bgr2Gray().gaussianBlur(blurSize).thresHold(0.0, 255.0, 8);
    }

    public Img sobel(int ddepth, int dx, int dy, int ksize, double scale, double delta, int borderType) {
        Mat result = new Mat();
        Imgproc.Sobel((Mat)this.src, (Mat)result, (int)ddepth, (int)dx, (int)dy, (int)ksize, (double)scale, (double)delta, (int)borderType);
        return new Img(result, false);
    }

    public Img adaptativeThresHold(double maxValue, int adaptiveMethod, int thresholdType, int blockSize, double C) {
        Mat result = new Mat();
        Imgproc.adaptiveThreshold((Mat)this.src, (Mat)result, (double)maxValue, (int)adaptiveMethod, (int)thresholdType, (int)blockSize, (double)C);
        return new Img(result, false);
    }

    public Img thresHold(double thresh, double maxval, int type) {
        Mat result = new Mat();
        Imgproc.threshold((Mat)this.src, (Mat)result, (double)thresh, (double)maxval, (int)type);
        return new Img(result, false);
    }

    public Img bernsen(int ksize, int contrast_limit) {
        Img gray = this.bgr2Gray();
        Mat ret = Mat.zeros((Size)gray.size(), (int)gray.type());
        for (int i = 0; i < gray.cols(); ++i) {
            for (int j = 0; j < gray.rows(); ++j) {
                double pix;
                double mn = 999.0;
                double mx = 0.0;
                int ti = 0;
                int tj = 0;
                int tlx = i - ksize / 2;
                int tly = j - ksize / 2;
                int brx = i + ksize / 2;
                int bry = j + ksize / 2;
                if (tlx < 0) {
                    tlx = 0;
                }
                if (tly < 0) {
                    tly = 0;
                }
                if (brx >= gray.cols()) {
                    brx = gray.cols() - 1;
                }
                if (bry >= gray.rows()) {
                    bry = gray.rows() - 1;
                }
                for (int ik = -ksize / 2; ik <= ksize / 2; ++ik) {
                    for (int jk = -ksize / 2; jk <= ksize / 2; ++jk) {
                        ti = i + ik;
                        tj = j + jk;
                        if (ti <= 0 || ti >= gray.cols() || tj <= 0 || tj >= gray.rows()) continue;
                        pix = gray.get(tj, ti)[0];
                        if (pix < mn) {
                            mn = pix;
                        }
                        if (!(pix > mx)) continue;
                        mx = pix;
                    }
                }
                double median = 0.5 * (mn + mx);
                if (median < (double)contrast_limit) {
                    ret.put(j, i, new double[]{0.0});
                    continue;
                }
                pix = gray.get(j, i)[0];
                ret.put(j, i, new double[]{pix > median ? 255.0 : 0.0});
            }
        }
        return new Img(ret, false);
    }

    public int rows() {
        return this.src.rows();
    }

    public int cols() {
        return this.src.cols();
    }

    public Img dilateBlacks(double valueThreshold, double saturatioThreshold, double blueThreshold, Size dilatation) {
        return this.range(new Scalar(0.0, 0.0, 0.0), new Scalar(255.0, saturatioThreshold, valueThreshold), true).range(new Scalar(0.0, 0.0, 0.0), new Scalar(blueThreshold, 255.0, 255.0), false).morphologyEx(1, 0, dilatation);
    }

    public Img adaptativeMeanThreshold(int blockSize, double C) {
        return this.bgr2Gray().adaptativeThresHold(255.0, 0, 0, blockSize, C);
    }

    public Img adaptativeGaussianThreshold(int blockSize, double C) {
        return this.bgr2Gray().adaptativeThresHold(255.0, 1, 0, blockSize, C);
    }

    public Img adaptativeGaussianInvThreshold(int blockSize, double C) {
        return this.bgr2Gray().adaptativeThresHold(255.0, 1, 1, blockSize, C);
    }

    public Img niblackThreshold(int blockSize, double k) {
        Mat result = new Mat();
        Ximgproc.niBlackThreshold((Mat)this.bgr2Gray().getSrc(), (Mat)result, (double)255.0, (int)0, (int)blockSize, (double)k, (int)0);
        return new Img(result, false);
    }

    public Img sauvolaThreshold(int blockSize, double k) {
        Mat result = new Mat();
        Ximgproc.niBlackThreshold((Mat)this.bgr2Gray().getSrc(), (Mat)result, (double)255.0, (int)1, (int)blockSize, (double)k, (int)1);
        return new Img(result, false);
    }

    public Img nickThreshold(int blockSize, double k) {
        Mat result = new Mat();
        Ximgproc.niBlackThreshold((Mat)this.bgr2Gray().getSrc(), (Mat)result, (double)255.0, (int)0, (int)blockSize, (double)k, (int)3);
        return new Img(result, false);
    }

    public Img wolfThreshold(int blockSize, double k) {
        Mat result = new Mat();
        Ximgproc.niBlackThreshold((Mat)this.bgr2Gray().getSrc(), (Mat)result, (double)255.0, (int)1, (int)blockSize, (double)k, (int)2);
        return new Img(result, false);
    }

    public Img resize(Size size) {
        Mat result = new Mat();
        Imgproc.resize((Mat)this.src, (Mat)result, (Size)size);
        return new Img(result, false);
    }

    public Img resize(int maxLength) {
        if (this.src.width() <= maxLength && this.src.height() <= maxLength) {
            return this;
        }
        if (this.src.width() >= this.src.height()) {
            return this.resize(new Size((double)maxLength, (double)(this.src.height() * maxLength / this.src.width())));
        }
        return this.resize(new Size((double)(this.src.width() * maxLength / this.src.height()), (double)maxLength));
    }

    public Img resize(double coeff) {
        Mat result = new Mat();
        Imgproc.resize((Mat)this.src, (Mat)result, (Size)new Size((double)this.src.width() * coeff, (double)this.src.height() * coeff));
        return new Img(result, false);
    }

    public Img bilateralFilter(int d, double sigmaColor, double sigmaSpace) {
        Mat result = new Mat();
        Imgproc.bilateralFilter((Mat)this.src, (Mat)result, (int)d, (double)sigmaColor, (double)sigmaSpace);
        return new Img(result, false);
    }

    public Img bilateralFilter() {
        return this.bilateralFilter(10, 80.0, 80.0);
    }

    public Img distanceTransform() {
        Mat result = new Mat();
        Imgproc.distanceTransform((Mat)this.src, (Mat)result, (int)2, (int)5);
        return new Img(result, false);
    }

    public Img absDiff(Img img) {
        Mat result = new Mat();
        Core.absdiff((Mat)this.src, (Mat)img.getSrc(), (Mat)result);
        return new Img(result, false);
    }

    public Img absDiff(Scalar scalar) {
        Mat result = new Mat();
        Core.absdiff((Mat)this.src, (Scalar)scalar, (Mat)result);
        return new Img(result, false);
    }

    public Img hsvChannel(int channel) {
        Mat result = new Mat();
        Imgproc.cvtColor((Mat)this.src, (Mat)result, (int)40);
        ArrayList channels = new ArrayList();
        Core.split((Mat)result, channels);
        return new Img((Mat)channels.get(channel), false);
    }

    public Img bgrChannel(int channel) {
        ArrayList channels = new ArrayList();
        Core.split((Mat)this.src, channels);
        return new Img((Mat)channels.get(channel), false);
    }

    public Img eraseCorners(double proportion) {
        Img result = new Img(this.src);
        int width = Double.valueOf((double)this.src.width() * proportion).intValue();
        int height = Double.valueOf((double)this.src.height() * proportion).intValue();
        Mat roi = new Mat(result.getSrc(), new Rect(0, 0, width, height));
        roi.setTo(new Scalar(255.0, 255.0, 255.0));
        roi = new Mat(result.getSrc(), new Rect(0, this.src.height() - height, width, height));
        roi.setTo(new Scalar(255.0, 255.0, 255.0));
        roi = new Mat(result.getSrc(), new Rect(this.src.width() - width, this.src.height() - height, width, height));
        roi.setTo(new Scalar(255.0, 255.0, 255.0));
        roi = new Mat(result.getSrc(), new Rect(this.src.width() - width, 0, width, height));
        roi.setTo(new Scalar(255.0, 255.0, 255.0));
        return result;
    }

    public Img fastNlMeansDenoising() {
        Mat result = new Mat();
        Photo.fastNlMeansDenoising((Mat)this.src, (Mat)result);
        return new Img(result, false);
    }

    public int findBestHisto(List<Img> imgs) {
        ArrayList<Map<Integer, Double>> results = new ArrayList<Map<Integer, Double>>();
        for (Img img : imgs) {
            results.add(this.compareHistogramm(this.computeHistogramm(), img));
        }
        List<Integer> methods = Arrays.asList(0, 1, 2, 3, 4, 5);
        HashMap<Integer, Integer> mins = new HashMap<Integer, Integer>();
        for (Integer method : methods) {
            double min = (Double)((Map)results.get(0)).get(method);
            int index = 0;
            for (int i = 0; i < results.size(); ++i) {
                if (!(min > (Double)((Map)results.get(i)).get(method))) continue;
                min = (Double)((Map)results.get(i)).get(method);
                index = i;
            }
            mins.put(index, mins.get(index) != null ? (Integer)mins.get(index) + 1 : 1);
        }
        TreeMap reverse = mins.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getValue(), entry -> (Integer)entry.getKey(), (u, v) -> u, TreeMap::new));
        return (Integer)reverse.lastEntry().getValue();
    }

    public Mat computeHistogramm() {
        MatOfInt channels = new MatOfInt(new int[]{0, 1, 2});
        MatOfInt histSize = new MatOfInt(new int[]{8, 8, 8});
        MatOfFloat ranges = new MatOfFloat(new float[]{0.0f, 256.0f, 0.0f, 256.0f, 0.0f, 256.0f});
        Mat rgb = this.cvtColor(4).getSrc();
        Mat hist = new Mat();
        Imgproc.calcHist(Arrays.asList(rgb), (MatOfInt)channels, (Mat)Mat.ones((Size)rgb.size(), (int)CvType.CV_8UC1), (Mat)hist, (MatOfInt)histSize, (MatOfFloat)ranges);
        Core.normalize((Mat)hist, (Mat)hist);
        return hist;
    }

    public Map<Integer, Double> compareHistogramm(Mat histo, Img img) {
        HashMap<Integer, Double> results = new HashMap<Integer, Double>();
        List<Integer> methods = Arrays.asList(0, 1, 2, 3, 4, 5);
        for (int method : methods) {
            double result = Imgproc.compareHist((Mat)histo, (Mat)img.computeHistogramm(), (int)method);
            switch (method) {
                case 0: {
                    result = -result;
                    break;
                }
                case 2: {
                    result = -result;
                }
            }
            results.put(method, result);
        }
        return results;
    }

    public List<Boolean> projectVertically() {
        Mat result = new Mat();
        Core.reduce((Mat)this.getSrc(), (Mat)result, (int)1, (int)0, (int)CvType.CV_64FC1);
        ArrayList histoVertical = new ArrayList();
        Converters.Mat_to_vector_double((Mat)result, histoVertical);
        return histoVertical.stream().map(value -> value != 0.0).collect(Collectors.toList());
    }

    public List<Boolean> projectHorizontally() {
        Mat result = new Mat();
        Core.reduce((Mat)this.getSrc(), (Mat)result, (int)0, (int)0, (int)CvType.CV_64FC1);
        Core.transpose((Mat)result, (Mat)result);
        ArrayList histoHorizontal = new ArrayList();
        Converters.Mat_to_vector_double((Mat)result, histoHorizontal);
        return histoHorizontal.stream().map(value -> value != 0.0).collect(Collectors.toList());
    }

    private Img range(Scalar scalar, Scalar scalar2) {
        Mat result = new Mat();
        Core.inRange((Mat)this.getSrc(), (Scalar)scalar, (Scalar)scalar2, (Mat)result);
        return new Img(result, false);
    }

    public Img add(Img img) {
        Mat result = new Mat();
        Core.add((Mat)this.getSrc(), (Mat)img.getSrc(), (Mat)result);
        return new Img(result, false);
    }

    public Img bitwise_and(Img img) {
        Mat result = new Mat();
        Core.bitwise_and((Mat)this.getSrc(), (Mat)img.getSrc(), (Mat)result);
        return new Img(result, false);
    }

    public Img bitwise_or(Img img) {
        Mat result = new Mat();
        Core.bitwise_or((Mat)this.getSrc(), (Mat)img.getSrc(), (Mat)result);
        return new Img(result, false);
    }

    public Img bitwise_xor(Img img) {
        Mat result = new Mat();
        Core.bitwise_xor((Mat)this.getSrc(), (Mat)img.getSrc(), (Mat)result);
        return new Img(result, false);
    }

    public Img bitwise_not() {
        Mat result = new Mat();
        Core.bitwise_not((Mat)this.getSrc(), (Mat)result);
        return new Img(result, false);
    }

    public Img transpose() {
        Mat result = new Mat();
        Core.transpose((Mat)this.src, (Mat)result);
        return new Img(result, false);
    }

    public Img houghLinesP(double rho, double theta, int threshold) {
        Mat result = new Mat();
        Imgproc.HoughLinesP((Mat)this.src, (Mat)result, (double)rho, (double)theta, (int)threshold);
        return new Img(result, false);
    }

    public Mat houghLinesP(int rho, double theta, int threshold, double minLineLength, double maxLineGap) {
        Mat result = new Mat();
        Imgproc.HoughLinesP((Mat)this.src, (Mat)result, (double)rho, (double)theta, (int)threshold, (double)minLineLength, (double)maxLineGap);
        return result;
    }

    public Image toJfxImage() {
        MatOfByte byteMat = new MatOfByte();
        Imgcodecs.imencode((String)".bmp", (Mat)this.getSrc(), (MatOfByte)byteMat);
        return new Image((InputStream)new ByteArrayInputStream(byteMat.toArray()));
    }

    public ImageView toJfxImageView() {
        return new ImageView(this.toJfxImage());
    }

    public MatOfFloat getHogDescriptor() {
        MatOfFloat imgDescriptor = new MatOfFloat();
        HOGDescriptor hog = new HOGDescriptor(new Size(64.0, 64.0), new Size(16.0, 16.0), new Size(16.0, 16.0), new Size(16.0, 16.0), 4);
        hog.compute(this.src, imgDescriptor);
        return imgDescriptor;
    }

    @Override
    public void close() {
        this.src.release();
    }

    public Layout buildLayout(Size morph, int level) {
        Layout root = new Layout(null, 0.0, 1.0, 0.0, 1.0);
        return root.recursiveSplit(morph, level, this);
    }

    public static boolean[] close(List<Boolean> histo, int k) {
        boolean[] closed = new boolean[histo.size()];
        block0: for (int i = 0; i < histo.size() - 1; ++i) {
            if (histo.get(i).booleanValue() && !histo.get(i + 1).booleanValue()) {
                for (int j = k + 1; j > 0; --j) {
                    if (i + j >= histo.size()) continue;
                    if (histo.get(i + j).booleanValue()) {
                        Arrays.fill(closed, i, i + j + 1, true);
                        i += j - 1;
                        continue block0;
                    }
                    closed[i] = histo.get(i);
                }
                continue;
            }
            closed[i] = histo.get(i);
        }
        if (!closed[histo.size() - 1]) {
            closed[histo.size() - 1] = histo.get(histo.size() - 1);
        }
        return closed;
    }

    public static boolean[] open(List<Boolean> histo, int k) {
        boolean[] closed = new boolean[histo.size()];
        block0: for (int i = 0; i < histo.size() - 1; ++i) {
            if (!histo.get(i).booleanValue() && histo.get(i + 1).booleanValue()) {
                for (int j = k + 1; j > 0; --j) {
                    if (i + j >= histo.size()) continue;
                    if (!histo.get(i + j).booleanValue()) {
                        Arrays.fill(closed, i, i + j + 1, false);
                        i += j - 1;
                        continue block0;
                    }
                    closed[i] = histo.get(i);
                }
                continue;
            }
            closed[i] = histo.get(i);
        }
        if (!closed[histo.size() - 1]) {
            closed[histo.size() - 1] = histo.get(histo.size() - 1);
        }
        return closed;
    }

    private List<Boolean> getRow(int row) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.src.cols());
        for (int col = 0; col < this.src.cols(); ++col) {
            result.add(this.src.get(row, col)[0] != 0.0);
        }
        return result;
    }

    public List<Boolean> getCol(int col) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.src.rows());
        for (int row = 0; row < this.src.rows(); ++row) {
            result.add(this.src.get(row, col)[0] != 0.0);
        }
        return result;
    }

    public Img cleanTables(double close) {
        Mat result = new Mat(this.src.size(), 0, new Scalar(255.0));
        boolean[][] hHistos = new boolean[this.src.cols()][this.src.rows()];
        for (int col = 0; col < this.src.cols(); ++col) {
            hHistos[col] = Img.open(this.getCol(col), Long.valueOf(Math.round(close * (double)this.src.rows())).intValue());
        }
        boolean[][] vHistos = new boolean[this.src.rows()][this.src.cols()];
        for (int row = 0; row < this.src.rows(); ++row) {
            vHistos[row] = Img.open(this.getRow(row), Long.valueOf(Math.round(close * (double)this.src.cols())).intValue());
        }
        for (int col = 0; col < this.src.cols(); ++col) {
            for (int row = 0; row < this.src.rows(); ++row) {
                result.put(row, col, new double[]{this.getSrc().get(row, col)[0] != 0.0 ^ (hHistos[col][row] || vHistos[row][col]) ? 255.0 : 0.0});
            }
        }
        return new Img(result, false);
    }

    public Img cleanTablesInv(double close) {
        Img hImg = this.morphologyEx(2, 0, new Size(close * (double)this.getSrc().width(), 1.0));
        Img vImg = this.morphologyEx(2, 0, new Size(1.0, close * (double)this.getSrc().height()));
        return new Img(this.bitwise_xor(hImg.bitwise_or(vImg)).getSrc());
    }

    public Img cleanFaces(double px, double py) {
        Img result = new Img(this.getSrc());
        Rect[] faces = FaceDetector.detect(result.getSrc());
        Arrays.stream(faces).forEach(face -> new Zone(0, (Rect)face).adjustRect((double)result.getSrc().width() * px / 2.0, (double)result.getSrc().height() * py / 2.0, result.getSrc().width(), result.getSrc().height()).draw(result, Scalar.all((double)0.0), -1));
        return result;
    }

    public Img directionalFilter(int size) {
        Size newSize = new Size((double)this.getSrc().width(), (double)(this.getSrc().height() - size));
        Mat result = new Mat(newSize, CvType.CV_64FC1, new Scalar(0.0));
        for (int i = 0; i < size; ++i) {
            Mat roi = new Mat(this.getSrc(), new Rect(new Point(0.0, (double)i), new Point((double)this.getSrc().width(), (double)(this.getSrc().height() - size + i))));
            Mat roi2 = new Mat();
            roi.convertTo(roi2, CvType.CV_64FC1);
            Core.addWeighted((Mat)result, (double)1.0, (Mat)roi2, (double)1.0, (double)0.0, (Mat)result);
        }
        Core.divide((Mat)result, (Scalar)new Scalar((double)size), (Mat)result);
        return new Img(result, false);
    }
}

