/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import java.nio.file.Paths;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.Deskewer;
import org.opencv.core.Scalar;

public class DeskewVisualizer
extends AbstractApp {
    private int row = 0;
    private int col = 0;
    private final String filename = System.getenv("HOME") + "/genericsystem/gs-ir-files/converted-png/image-test2-0.png";
    private final Img original = new Img(this.filename);

    public static void main(String[] args) {
        DeskewVisualizer.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        this.showWithRectangles(mainGrid);
        this.col = 0;
        ++this.row;
        this.showWithLines(mainGrid);
        this.original.close();
    }

    private void showWithRectangles(GridPane mainGrid) {
        Img deskewed = Deskewer.deskew(Paths.get(this.filename, new String[0]), Deskewer.METHOD.ROTADED_RECTANGLES);
        Img annotated = Deskewer.getRotatedRectanglesDrawn(this.original, new Scalar(0.0, 0.0, 255.0), 4);
        Img annotated2 = Deskewer.getRotatedRectanglesDrawn(deskewed, new Scalar(0.0, 0.0, 255.0), 4);
        mainGrid.add((Node)annotated.getImageView(), this.col++, this.row);
        mainGrid.add((Node)annotated2.getImageView(), this.col++, this.row);
        annotated.close();
        deskewed.close();
        annotated2.close();
    }

    private void showWithLines(GridPane mainGrid) {
        Img deskewed = Deskewer.deskew(Paths.get(this.filename, new String[0]), Deskewer.METHOD.HOUGH_LINES);
        Img annotated = Deskewer.getLinesDrawn(this.original, new Scalar(0.0, 0.0, 255.0), 4);
        Img annotated2 = Deskewer.getLinesDrawn(deskewed, new Scalar(0.0, 0.0, 255.0), 4);
        mainGrid.add((Node)annotated.getImageView(), this.col++, this.row);
        mainGrid.add((Node)annotated2.getImageView(), this.col++, this.row);
        annotated.close();
        deskewed.close();
        annotated2.close();
    }
}

