/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class TextOrientationLinesDetector {
    static List<Lines.Line> getTextOrientationLines(SuperFrameImg superFrame) {
        List<Circle> circles = TextOrientationLinesDetector.gridCircles(superFrame.size(), (int)(superFrame.size().width / 15.0));
        Collection<Circle> selectedCircles = TextOrientationLinesDetector.selectRandomObjects(circles, 30);
        ArrayList<Lines.Line> result = new ArrayList<Lines.Line>();
        for (Circle circle : selectedCircles) {
            Img circledImg = TextOrientationLinesDetector.getCircledImg(superFrame, (int)circle.radius, circle.center);
            double angle = TextOrientationLinesDetector.getBestAngle(circledImg, 42, 12.0, 5, 192.0, null) / 180.0 * Math.PI;
            result.add(TextOrientationLinesDetector.buildLine(circle.center, angle, circle.radius));
            Imgproc.circle((Mat)superFrame.getDisplay().getSrc(), (Point)circle.center, (int)((int)circle.radius), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
        }
        return result;
    }

    private static List<Circle> gridCircles(Size size, double radius) {
        ArrayList<Circle> circles = new ArrayList<Circle>();
        int j = 2;
        while ((double)j <= size.width / radius - 2.0) {
            int i = 2;
            while ((double)i <= size.height / radius - 2.0) {
                circles.add(new Circle(new Point((double)j * radius, (double)i * radius), (int)radius));
                i += 2;
            }
            j += 2;
        }
        return circles;
    }

    private static List<MatOfPoint> getContours(Img img) {
        ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
        Imgproc.findContours((Mat)img.getSrc(), contours, (Mat)new Mat(), (int)1, (int)2);
        return contours;
    }

    private static List<Circle> detectCircles(Img img, int maxContourArea, int minRadius, int maxRadius) {
        List<MatOfPoint> contours = TextOrientationLinesDetector.getContours(img);
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (MatOfPoint contour : contours) {
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > 50.0)) continue;
            float[] radius = new float[1];
            Point center = new Point();
            MatOfPoint2f contour2F = new MatOfPoint2f(contour.toArray());
            Imgproc.minEnclosingCircle((MatOfPoint2f)contour2F, (Point)center, (float[])radius);
            if (!(radius[0] > (float)minRadius) || !(radius[0] < (float)maxRadius) || !(center.x > (double)radius[0]) || !(center.y > (double)radius[0]) || !(center.x + (double)radius[0] < (double)img.width()) || !(center.y + (double)radius[0] < (double)img.height())) continue;
            circles.add(new Circle(center, radius[0]));
        }
        return circles;
    }

    private static List<Rect> detectRects(Img img, int maxContourArea, int minWidth, int maxWidth, int minHeight, int maxHeight) {
        List<MatOfPoint> contours = TextOrientationLinesDetector.getContours(img);
        ArrayList<Rect> rects = new ArrayList<Rect>();
        for (MatOfPoint contour : contours) {
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > 50.0)) continue;
            Rect rect = Imgproc.boundingRect((MatOfPoint)contour);
            if (rect.width < minWidth || rect.width > maxWidth || rect.height < minHeight || rect.height > maxHeight) continue;
            rects.add(rect);
        }
        return rects;
    }

    private static <T> Collection<T> selectRandomObjects(List<T> objects, int maxReturnObjects) {
        if (objects.size() <= maxReturnObjects) {
            return objects;
        }
        HashSet<T> result = new HashSet<T>();
        while (result.size() < maxReturnObjects) {
            result.add(objects.get((int)(Math.random() * (double)objects.size())));
        }
        return result;
    }

    private static Img getCircledImg(SuperFrameImg superFrame, int radius, Point center) {
        Mat mask = new Mat(new Size((double)(radius * 2), (double)(radius * 2)), CvType.CV_8UC1, new Scalar(0.0));
        Imgproc.circle((Mat)mask, (Point)new Point((double)radius, (double)radius), (int)radius, (Scalar)new Scalar(255.0), (int)-1);
        Rect rect = new Rect(new Point(center.x - (double)radius, center.y - (double)radius), new Point(center.x + (double)radius, center.y + (double)radius));
        Mat roi = new Mat(superFrame.getBinarized().getSrc(), rect);
        Mat circled = new Mat();
        roi.copyTo(circled, mask);
        Img circledImg = new Img(circled, false);
        return circledImg;
    }

    private static Img getRectImg(SuperFrameImg superFrame, Rect rect) {
        return new Img(new Mat(superFrame.getBinarized().getSrc(), rect), false);
    }

    private static Lines.Line buildLine(Point center, double angle, double size) {
        double x1 = center.x - Math.sin(angle) * size;
        double y1 = center.y + Math.cos(angle) * size;
        double x2 = center.x + Math.sin(angle) * size;
        double y2 = center.y - Math.cos(angle) * size;
        return new Lines.Line(new Point(x1, y1), new Point(x2, y2));
    }

    private static double score(Img circled, double angle, int filterSize, double threshold) {
        Mat M = Imgproc.getRotationMatrix2D((Point)new Point((double)(circled.width() / 2), (double)(circled.width() / 2)), (double)angle, (double)1.0);
        Mat rotated = new Mat();
        Imgproc.warpAffine((Mat)circled.getSrc(), (Mat)rotated, (Mat)M, (Size)new Size((double)circled.width(), (double)circled.width()));
        Img binarized = new Img(rotated, false).directionalFilter(filterSize).thresHold(threshold, 255.0, 0);
        Mat result = new Mat();
        Core.reduce((Mat)binarized.getSrc(), (Mat)result, (int)1, (int)0, (int)6);
        Core.reduce((Mat)result, (Mat)result, (int)0, (int)0, (int)6);
        return result.get(0, 0)[0];
    }

    private static double getBestAngle(Img circledImg, int absMinMax, double step, int filterSize, double threshold, Img[] binarized) {
        double maxScore = 0.0;
        double bestAngle = -1.0;
        if (binarized != null) {
            binarized[0] = new Img(new Mat(new Size((double)(2 * absMinMax * 10), 200.0), CvType.CV_8UC1, new Scalar(0.0)), false);
        }
        ArrayList<double[]> results = new ArrayList<double[]>();
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += step) {
            double score = TextOrientationLinesDetector.score(circledImg, angle, filterSize, threshold);
            if (angle != 0.0 && score > maxScore) {
                maxScore = score;
                bestAngle = angle;
            }
            if (angle != 0.0) {
                results.add(new double[]{angle, score});
            }
            if (binarized == null) continue;
            new Lines.Line(((double)absMinMax + angle) * 10.0, 0.0, ((double)absMinMax + angle) * 10.0, score / 1000.0).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0), 1);
        }
        BiFunction<Double, double[], Double> f = (x, params) -> params[0] * x * x * x * x + params[1] * x * x * x + params[2] * x * x + params[3] * x + params[4];
        double[] result = LevenbergImpl.fromBiFunction(f, results, new double[]{1.0, 1.0, 1.0, 1.0, 1.0}).getParams();
        Point point = null;
        double polynomAngle = 0.0;
        double max = 0.0;
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += 1.0) {
            Point oldPoint = point;
            double score = f.apply(angle, result);
            point = new Point(((double)absMinMax + angle) * 10.0, score / 1000.0);
            if (score > max) {
                max = score;
                polynomAngle = angle;
            }
            if (binarized == null || oldPoint == null) continue;
            new Lines.Line(oldPoint, point).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0), 1);
        }
        if (binarized != null) {
            Imgproc.circle((Mat)binarized[0].getSrc(), (Point)new Point(((double)absMinMax + polynomAngle) * 10.0, max / 1000.0), (int)10, (Scalar)new Scalar(255.0, 255.0, 0.0), (int)3);
        }
        return polynomAngle;
    }

    static class Circle {
        Point center;
        float radius;

        public Circle(Point center, float radius) {
            this.center = center;
            this.radius = radius;
        }
    }
}

