/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.SuperTemplate;
import org.genericsystem.cv.application.TextOrientationLinesDetector;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.imgproc.Moments;

public class SuperFrameImg {
    private final Img frame;
    private final double[] pp;
    private final double f;
    private Img display;
    private Img bilateralFilter;
    private Img binarized;
    private Img gradient;
    private Img diffFrame;
    private Img binaryClosed10;
    private Img binaryClosed20;
    private Img binaryClosed30;
    private Img binaryClosed40;

    public SuperFrameImg(Mat frameMat, double[] pp, double f) {
        this.frame = new Img(frameMat, false);
        this.pp = pp;
        this.f = f;
    }

    public Img getFrame() {
        return this.frame;
    }

    public Img getBilateralFilter() {
        return this.bilateralFilter != null ? this.bilateralFilter : (this.bilateralFilter = this.buildBilateralFilter());
    }

    public Img getBinarized() {
        return this.binarized != null ? this.binarized : (this.binarized = this.buildBinarized());
    }

    public Img getGradient() {
        return this.gradient != null ? this.gradient : (this.gradient = this.buildGradient());
    }

    public Img getDisplay() {
        return this.display != null ? this.display : (this.display = this.buildDisplay());
    }

    public Img getDiffFrame() {
        return this.diffFrame != null ? this.diffFrame : (this.diffFrame = this.buildDiffFrame());
    }

    public Img getBinaryClosed10() {
        return this.binaryClosed10 != null ? this.binaryClosed10 : (this.binaryClosed10 = this.buildBinaryClosed10());
    }

    public Img getBinaryClosed20() {
        return this.binaryClosed20 != null ? this.binaryClosed20 : (this.binaryClosed20 = this.buildBinaryClosed20());
    }

    public Img getBinaryClosed30() {
        return this.binaryClosed30 != null ? this.binaryClosed30 : (this.binaryClosed30 = this.buildBinaryClosed30());
    }

    public Img getBinaryClosed40() {
        return this.binaryClosed40 != null ? this.binaryClosed40 : (this.binaryClosed40 = this.buildBinaryClosed40());
    }

    private Img buildBilateralFilter() {
        return this.getFrame().bilateralFilter();
    }

    private Img buildBinarized() {
        return this.getBilateralFilter().adaptativeGaussianInvThreshold(11, 3.0);
    }

    private Img buildGradient() {
        return this.getFrame().bgr2Gray().morphologyEx(4, 2, new Size(2.0, 2.0)).thresHold(15.0, 255.0, 0);
    }

    protected Img buildDisplay() {
        return new Img(this.getFrame().getSrc(), true);
    }

    private Img buildBinaryClosed10() {
        return this.getBinarized().morphologyEx(3, 2, new Size(10.0, 10.0)).morphologyEx(3, 0, new Size(10.0, 10.0));
    }

    private Img buildBinaryClosed20() {
        return this.getBinarized().morphologyEx(3, 2, new Size(20.0, 20.0)).morphologyEx(3, 0, new Size(20.0, 20.0));
    }

    private Img buildBinaryClosed30() {
        return this.getBinarized().morphologyEx(3, 2, new Size(30.0, 30.0)).morphologyEx(3, 0, new Size(30.0, 30.0));
    }

    private Img buildBinaryClosed40() {
        return this.getBinarized().morphologyEx(3, 2, new Size(40.0, 40.0)).morphologyEx(3, 0, new Size(40.0, 40.0));
    }

    public Lines detectLines() {
        Img grad = this.getGradient().morphologyEx(3, 0, new Size(8.0, 8.0)).morphologyEx(3, 2, new Size(8.0, 8.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
        Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 10.0, 3.0));
        Img grad2 = this.getGradient().morphologyEx(3, 0, new Size(30.0, 30.0)).morphologyEx(3, 2, new Size(30.0, 30.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
        lines.getLines().addAll(new Lines(grad2.houghLinesP(1, Math.PI / 180, 10, 30.0, 10.0)).getLines());
        return lines;
    }

    public double[] getPrincipalPoint() {
        return new double[]{this.frame.width() / 2, this.frame.height() / 2};
    }

    public Size size() {
        return this.getFrame().size();
    }

    public double width() {
        return this.getFrame().width();
    }

    public double height() {
        return this.getFrame().height();
    }

    public Img warpPerspective(Mat homography) {
        Mat deperspectived = new Mat();
        Imgproc.warpPerspective((Mat)this.getFrame().getSrc(), (Mat)deperspectived, (Mat)homography, (Size)this.size(), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
        return new Img(deperspectived, false);
    }

    public Mat findHomography(Calibrated.AngleCalibrated[] calibrateds) {
        double[][] vps = new double[][]{calibrateds[0].getCalibratexyz(), calibrateds[1].getCalibratexyz(), calibrateds[2].getCalibratexyz()};
        double[][] vps2D = this.getVp2DFromVps(vps);
        double theta = calibrateds[0].getTheta();
        double theta2 = calibrateds[1].getTheta();
        Size size = this.size();
        double x = this.size().width / 6.0;
        double[] A = new double[]{size.width / 2.0, size.height / 2.0, 1.0};
        double[] B = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0};
        double[] D = new double[]{size.width / 2.0, size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x), 1.0};
        double[] C = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x)};
        double[] A_ = A;
        double[] B_ = new double[]{size.width / 2.0 + x * vps[0][0], size.height / 2.0 + x * vps[0][1], 1.0};
        double[] D_ = new double[]{size.width / 2.0 + x * vps[1][0], size.height / 2.0 + x * vps[1][1], 1.0};
        double[] C_ = SuperFrameImg.cross2D(SuperFrameImg.cross(B_, vps2D[1]), SuperFrameImg.cross(D_, vps2D[0]));
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(A_), new Point(B_), new Point(C_), new Point(D_)}), (Mat)new MatOfPoint2f(new Point[]{new Point(A), new Point(B), new Point(C), new Point(D)}));
    }

    public double[][] getVp2DFromVps(double[][] vps) {
        double[][] result = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            result[i][0] = vps[i][0] * this.f / vps[i][2] + this.pp[0];
            result[i][1] = vps[i][1] * this.f / vps[i][2] + this.pp[1];
            result[i][2] = 1.0;
        }
        return result;
    }

    static double[] cross2D(double[] a, double[] b) {
        return SuperFrameImg.on2D(SuperFrameImg.cross(a, b));
    }

    static double[] on2D(double[] a) {
        return new double[]{a[0] / a[2], a[1] / a[2], 1.0};
    }

    static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    public void draw(Lines lines, Scalar color, int thickness) {
        lines.draw(this.getDisplay().getSrc(), color, thickness);
    }

    public void drawVanishingPointLines(Lines lines, Calibrated.AngleCalibrated calibratedVp, Scalar color, int thickness) {
        double[] uncalibrate0 = calibratedVp.uncalibrate(this.pp, this.f);
        Lines horizontals = lines.filter(line -> Calibrated.AngleCalibrated.distance(uncalibrate0, line) < 0.4);
        this.draw(horizontals, color, thickness);
    }

    public SuperTemplate deperspective(Mat homography) {
        return new SuperTemplate(this, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)st -> st.warpPerspective(homography)));
    }

    public Calibrated.AngleCalibrated findVanishingPoint(Lines lines, Calibrated.AngleCalibrated old) {
        double[] thetaPhi = new LevenbergImpl<Lines.Line>((line, params) -> new Calibrated.AngleCalibrated((double[])params).distance((Lines.Line)line, this.pp, this.f), lines.getLines(), old.getThetaPhi()).getParams();
        return new Calibrated.AngleCalibrated(thetaPhi);
    }

    public List<Lines.Line> findTextOrientationLines() {
        return TextOrientationLinesDetector.getTextOrientationLines(this);
    }

    public void drawVpsArrows(Calibrated[] calibratedVps, double[] shift, Scalar color, int thickness) {
        this.drawArrow(new Point(shift[0], shift[1]), new Point(shift[0] + calibratedVps[0].getX() * 20.0, shift[1] + calibratedVps[0].getY() * 20.0), new Scalar(0.0, 255.0, 0.0), 2);
        this.drawArrow(new Point(shift[0], shift[1]), new Point(shift[0] - calibratedVps[1].getX() * 20.0, shift[1] - calibratedVps[1].getY() * 20.0), new Scalar(255.0, 0.0, 0.0), 2);
        this.drawArrow(new Point(shift[0], shift[1]), new Point(shift[0] - calibratedVps[2].getX() * 20.0, shift[1] - calibratedVps[2].getY() * 20.0), new Scalar(0.0, 0.0, 255.0), 2);
    }

    public void drawArrow(Point pt1, Point pt2, Scalar color, int thickness) {
        Imgproc.arrowedLine((Mat)this.getDisplay().getSrc(), (Point)pt1, (Point)pt2, (Scalar)color, (int)thickness, (int)8, (int)0, (double)0.5);
    }

    public void drawDetectedRects() {
        this.drawRects(this.detectRects(), new Scalar(255.0), -1);
    }

    public void drawRects(List<Rect> gsRects, Scalar color, int thickness) {
        Mat display = this.getDisplay().getSrc();
        gsRects.forEach(rect -> Imgproc.rectangle((Mat)display, (Point)rect.tl(), (Point)rect.br(), (Scalar)color, (int)thickness));
    }

    public Img getGrayFrame() {
        return 0 != this.getFrame().type() ? this.getFrame().bgr2Gray() : this.getFrame();
    }

    private Img buildDiffFrame() {
        Mat diffFrame = this.getGrayFrame().gaussianBlur(new Size(5.0, 5.0)).getSrc();
        Core.absdiff((Mat)diffFrame, (Scalar)new Scalar(50.0), (Mat)diffFrame);
        Imgproc.adaptiveThreshold((Mat)diffFrame, (Mat)diffFrame, (double)255.0, (int)0, (int)1, (int)7, (double)3.0);
        return new Img(diffFrame, false);
    }

    public List<Rect> detectRects() {
        return this.detectRects(this.getDiffFrame(), 10, 10000, 0.3);
    }

    public List<Point> detectCentroids() {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)this.getDiffFrame().getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        ArrayList<Point> result = new ArrayList<Point>();
        for (MatOfPoint contour : contours) {
            Moments moments = Imgproc.moments((Mat)contour);
            result.add(new Point(moments.m10 / moments.m00, moments.m01 / moments.m00));
        }
        Collections.reverse(result);
        return result;
    }

    public int countWhitePixels(MatOfPoint contour, Rect rect, Img img) {
        Mat mask = Mat.zeros((Size)rect.size(), (int)CvType.CV_8UC1);
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0), (int)-1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(0.0), (int)1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        int white = 0;
        for (int row = 0; row < mask.rows(); ++row) {
            for (int col = 0; col < mask.cols(); ++col) {
                if (mask.get(row, col)[0] == 0.0 || img.get(row + (int)rect.tl().y, col + (int)rect.tl().x)[0] == 0.0) continue;
                ++white;
            }
        }
        return white;
    }

    public List<SuperContour> detectSuperContours(double minArea) {
        ArrayList contours = new ArrayList();
        Mat hierarchy = new Mat();
        Img img = this.getDiffFrame().morphologyEx(3, 0, new Size(1.0, 1.0));
        Imgproc.findContours((Mat)img.getSrc(), contours, (Mat)hierarchy, (int)3, (int)1);
        ArrayList<SuperContour> result = new ArrayList<SuperContour>();
        int row = 0;
        for (MatOfPoint contour : contours) {
            MatOfPoint fatherWrapper;
            double[] indexes = hierarchy.get(0, row);
            double fatherIndex = indexes[3];
            MatOfPoint matOfPoint = fatherWrapper = fatherIndex != -1.0 ? (MatOfPoint)contours.get((int)fatherIndex) : null;
            if (Imgproc.contourArea((Mat)contour) > minArea && Imgproc.boundingRect((MatOfPoint)contour).area() < 4000.0) {
                if (fatherWrapper != null) {
                    if (this.countWhitePixels(contour, Imgproc.boundingRect((MatOfPoint)contour), img) != 0) {
                        result.add(new SuperContour(contour, hierarchy.get(0, row)[3] == -1.0));
                    }
                } else {
                    result.add(new SuperContour(contour, hierarchy.get(0, row)[3] == -1.0));
                }
            }
            ++row;
        }
        return result;
    }

    private Edge generateEdge(SuperContour c1, SuperContour c2, double maxDistance, double coeffDeltaAngle) {
        if (c1.compareTo(c2) > 0) {
            SuperContour tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        double minDist = Double.MAX_VALUE;
        double c1Angle = 0.0;
        double c2Angle = 0.0;
        for (Point c1Point : new Point[]{c1.top, c1.right, c1.left, c1.bottom}) {
            for (Point c2Point : new Point[]{c2.top, c2.right, c2.left, c2.bottom}) {
                double dist = this.euclid(c1Point, c2Point);
                if (!(dist < minDist)) continue;
                minDist = dist;
                c1Angle = SuperFrameImg.toDemiPis(c1Point == c1.top || c1Point == c1.bottom ? c1.antiAngle : c1.angle);
                c2Angle = SuperFrameImg.toDemiPis(c2Point == c2.top || c2Point == c2.bottom ? c2.antiAngle : c2.angle);
            }
        }
        if (minDist > maxDistance) {
            return null;
        }
        double centersAngle = SuperFrameImg.toDemiPis(Math.atan2(c2.center.y - c1.center.y, c2.center.x - c1.center.x));
        if (Math.abs(centersAngle) * 180.0 / Math.PI > 45.0) {
            return null;
        }
        double deltaAngle = Math.max(SuperFrameImg.toZeroDemiPi(centersAngle - c1Angle), SuperFrameImg.toZeroDemiPi(centersAngle - c2Angle));
        if (minDist * Math.sin(deltaAngle) > 8.0) {
            return null;
        }
        double score = minDist + minDist * Math.sin(deltaAngle) * coeffDeltaAngle;
        return new Edge(score, c1, c2);
    }

    private double euclid(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    private static double toZeroDemiPi(double diff) {
        while (diff > 1.5707963267948966) {
            diff -= Math.PI;
        }
        while (diff < -1.5707963267948966) {
            diff += Math.PI;
        }
        return Math.abs(diff);
    }

    private static double toDemiPis(double diff) {
        while (diff > 1.5707963267948966) {
            diff -= Math.PI;
        }
        while (diff < -1.5707963267948966) {
            diff += Math.PI;
        }
        return diff;
    }

    public List<Span> assembleContours(List<SuperContour> superContours, Predicate<SuperContour> contoursFilter, double maxCentersDistance, double coeffDeltaAngle, double minSpanWidth) {
        superContours = superContours.stream().filter(contoursFilter).collect(Collectors.toList());
        Collections.sort(superContours);
        ArrayList<Edge> candidateEdges = new ArrayList<Edge>();
        for (int i = 0; i < superContours.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                Edge edge = this.generateEdge(superContours.get(i), superContours.get(j), maxCentersDistance, coeffDeltaAngle);
                if (edge == null) continue;
                candidateEdges.add(edge);
            }
        }
        Collections.sort(candidateEdges);
        for (Edge edge : candidateEdges) {
            if (edge.getC1().succ != null || edge.getC2().pred != null) continue;
            edge.getC1().succ = edge.getC2();
            edge.getC2().pred = edge.getC1();
        }
        ArrayList<Span> spans = new ArrayList<Span>();
        while (!superContours.isEmpty()) {
            SuperContour contour = superContours.get(0);
            while (contour.pred != null) {
                contour = contour.pred;
            }
            Span curSpan = new Span();
            double width = 0.0;
            while (contour != null) {
                superContours.remove(contour);
                curSpan.add(contour);
                width += contour.lxmax - contour.lxmin;
                contour = contour.succ;
            }
            if (!(width > minSpanWidth) || curSpan.getContours().size() <= 1) continue;
            spans.add(curSpan);
        }
        Collections.sort(spans);
        return spans;
    }

    List<Rect> detectRects(Img binarized, int minArea, int maxArea, double fillRatio) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)binarized.getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        Size size = binarized.size();
        ArrayList<Rect> result = new ArrayList<Rect>();
        for (MatOfPoint contour : contours) {
            double area = Imgproc.contourArea((Mat)contour);
            if (!(area > (double)minArea) || !(area < (double)maxArea)) continue;
            Rect rect = Imgproc.boundingRect((MatOfPoint)contour);
            if (rect.tl().x == 0.0 || rect.tl().y == 0.0 || rect.br().x == size.width || rect.br().y == size.height || !(this.getFillRatio(contour, rect) > fillRatio)) continue;
            result.add(rect);
        }
        Collections.reverse(result);
        return result;
    }

    public double getFillRatio(MatOfPoint contour, Rect rect) {
        Mat mask = Mat.zeros((Size)rect.size(), (int)CvType.CV_8UC1);
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0), (int)-1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        Mat mat = new Mat();
        Core.findNonZero((Mat)mask, (Mat)mat);
        return (double)mat.rows() / rect.area();
    }

    public List<GSRect> cleanList(List<GSRect> bigRects, List<GSRect> smallRects, double overlapThreshold) {
        smallRects.removeIf(smallRect -> bigRects.stream().anyMatch(bigRect -> smallRect.inclusiveArea(bigRect) > overlapThreshold));
        return Stream.concat(smallRects.stream().filter(smallRect -> bigRects.stream().filter(rect -> rect.isOverlapping(smallRect)).noneMatch(rect -> rect.getInsider(smallRect) == null)), bigRects.stream()).collect(Collectors.toList());
    }

    public boolean isOverlapping(Rect rect, Rect other) {
        return (double)rect.x <= other.br().x && other.tl().x <= rect.br().x && (double)rect.y <= other.br().y && other.tl().y <= rect.br().y;
    }

    public Calibrated.AngleCalibrated[] findOtherVps(Calibrated.AngleCalibrated calibrated0, Lines lines) {
        Calibrated.AngleCalibrated[] result = new Calibrated.AngleCalibrated[]{null, null, null};
        double bestError = Double.MAX_VALUE;
        for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / 180) {
            double error;
            Calibrated.AngleCalibrated calibratexy = calibrated0.getOrthoFromAngle(angle);
            Calibrated.AngleCalibrated calibratez = calibrated0.getOrthoFromVps(calibratexy);
            if (calibratexy.getPhi() < calibratez.getPhi()) {
                Calibrated.AngleCalibrated tmp = calibratexy;
                calibratexy = calibratez;
                calibratez = tmp;
            }
            if (!((error = calibratexy.distance(lines.getLines(), this.pp, this.f)) < bestError)) continue;
            bestError = error;
            result[0] = calibrated0;
            result[1] = calibratexy;
            result[2] = calibratez;
        }
        double theta0 = Math.abs(result[0].getTheta()) % Math.PI;
        theta0 = Math.min(Math.PI - theta0, theta0);
        double theta1 = Math.abs(result[1].getTheta()) % Math.PI;
        if (theta0 > (theta1 = Math.min(Math.PI - theta1, theta1))) {
            Calibrated.AngleCalibrated tmp = result[0];
            result[0] = result[1];
            result[1] = tmp;
        }
        return result;
    }

    public double[] getPp() {
        return this.pp;
    }

    public double getF() {
        return this.f;
    }

    public void putText(String text) {
        Imgproc.putText((Mat)this.getDisplay().getSrc(), (String)text, (Point)new Point((double)(this.getDisplay().width() / 2), 20.0), (int)1, (double)1.0, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1);
    }

    public static class Span
    implements Comparable<Span> {
        private List<SuperContour> contours = new ArrayList<SuperContour>();
        private java.util.function.Function<Double, Double> approx;

        public void add(SuperContour superContour) {
            this.contours.add(superContour);
        }

        public List<SuperContour> getContours() {
            return this.contours;
        }

        public java.util.function.Function<Double, Double> getApprox() {
            return this.approx != null ? this.approx : (this.approx = this.computeApprox());
        }

        private java.util.function.Function<Double, Double> computeApprox() {
            PolynomialSplineFunction psf = new LinearInterpolator().interpolate(this.contours.stream().mapToDouble(sc -> sc.center.x).toArray(), this.contours.stream().mapToDouble(sc -> sc.center.y).toArray());
            return x -> psf.isValidPoint(x.doubleValue()) ? Double.valueOf(psf.value(x.doubleValue())) : null;
        }

        @Override
        public int compareTo(Span span) {
            return Double.compare(this.getContours().stream().mapToDouble(c -> c.center.y).average().getAsDouble(), span.getContours().stream().mapToDouble(c -> c.center.y).average().getAsDouble());
        }
    }

    public static class Edge
    implements Comparable<Edge> {
        private final double score;
        private final SuperContour c1;
        private final SuperContour c2;

        public Edge(double score, SuperContour c1, SuperContour c2) {
            this.c1 = c1;
            this.c2 = c2;
            this.score = score;
        }

        @Override
        public int compareTo(Edge edge) {
            return Double.compare(this.score, edge.getScore());
        }

        private double getScore() {
            return this.score;
        }

        public SuperContour getC1() {
            return this.c1;
        }

        public SuperContour getC2() {
            return this.c2;
        }
    }

    public static class SuperContour
    implements Comparable<SuperContour> {
        public final MatOfPoint contour;
        public SuperContour succ;
        public SuperContour pred;
        public final Point center;
        public final double angle;
        public final double antiAngle;
        public final Point left;
        public final Point right;
        public final Point top;
        public final Point bottom;
        public final Rect rect;
        public final double lxmin;
        public final double lxmax;
        public final double lymin;
        public final double lymax;
        public final double dx;
        public final double dy;
        public final boolean isLeaf;

        public SuperContour(MatOfPoint contour, boolean isLeaf) {
            this.contour = contour;
            this.rect = Imgproc.boundingRect((MatOfPoint)contour);
            Mat dataPts = this.convertContourToMat(contour);
            Mat mean = new Mat();
            Mat eigen = new Mat();
            Core.PCACompute((Mat)dataPts, (Mat)mean, (Mat)eigen);
            Mat project = new Mat();
            Core.PCAProject((Mat)dataPts, (Mat)mean, (Mat)eigen, (Mat)project);
            Mat min = new Mat();
            Core.reduce((Mat)project, (Mat)min, (int)0, (int)3);
            Mat max = new Mat();
            Core.reduce((Mat)project, (Mat)max, (int)0, (int)2);
            this.center = new Point(mean.get(0, 0)[0], mean.get(0, 1)[0]);
            this.lxmin = min.get(0, 0)[0];
            this.lymin = min.get(0, 1)[0];
            this.lxmax = max.get(0, 0)[0];
            this.lymax = max.get(0, 1)[0];
            Point tangent = new Point(eigen.get(0, 0)[0], eigen.get(0, 1)[0]);
            Point antiTangent = new Point(eigen.get(0, 1)[0], -eigen.get(0, 0)[0]);
            this.left = new Point(this.center.x + tangent.x * this.lxmin, this.center.y + tangent.y * this.lxmin);
            this.right = new Point(this.center.x + tangent.x * this.lxmax, this.center.y + tangent.y * this.lxmax);
            this.top = new Point(this.center.x + antiTangent.x * this.lymin, this.center.y + antiTangent.y * this.lymin);
            this.bottom = new Point(this.center.x + antiTangent.x * this.lymax, this.center.y + antiTangent.y * this.lymax);
            this.angle = Math.atan2(tangent.y, tangent.x);
            this.antiAngle = Math.atan2(antiTangent.y, antiTangent.x);
            this.isLeaf = isLeaf;
            this.dx = this.lxmax - this.lxmin;
            this.dy = this.lymax - this.lymin;
        }

        Mat convertContourToMat(MatOfPoint contour) {
            Point[] pts = contour.toArray();
            Mat result = new Mat(pts.length, 2, CvType.CV_64FC1);
            for (int i = 0; i < result.rows(); ++i) {
                result.put(i, 0, new double[]{pts[i].x});
                result.put(i, 1, new double[]{pts[i].y});
            }
            return result;
        }

        @Override
        public int compareTo(SuperContour c) {
            int xCompare = Double.compare(this.center.x, c.center.x);
            return xCompare != 0 ? xCompare : Double.compare(this.center.y, c.center.y);
        }
    }
}

