/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.Deperspectiver;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.ImgDescriptor;
import org.genericsystem.cv.application.ReferenceManager;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.application.SuperTemplate;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.layout.Layout;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class GraphicApp
extends AbstractApp {
    private final double f = 672.5555555555555;
    private final GSCapture gsCapture = new GSVideoCapture(0, 672.5555555555555, GSVideoCapture.HD, GSVideoCapture.VGA);
    private SuperFrameImg superFrame;
    private ReferenceManager referenceManager;
    private Config config = new Config();
    private Deperspectiver deperspectiver;
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        GraphicApp.launch((String[])args);
    }

    public GraphicApp() {
        this.superFrame = this.gsCapture.read();
        this.deperspectiver = new Deperspectiver(672.5555555555555, this.superFrame.getPp());
        this.referenceManager = new ReferenceManager(this.gsCapture.getResize());
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth(this.superFrame.width() / displaySizeReduction);
                imageView.setFitHeight(this.superFrame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 30L, TimeUnit.MILLISECONDS);
    }

    private Image[] doWork() {
        double rapport;
        int bottomRow;
        int topRow;
        int col;
        int row;
        Calibrated[] calibratedVps;
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.superFrame = this.gsCapture.read();
        }
        Image[] images = new Image[9];
        Lines lines = this.superFrame.detectLines();
        if (this.config.textsEnabledMode) {
            lines.getLines().addAll(this.superFrame.findTextOrientationLines());
        }
        if ((calibratedVps = this.deperspectiver.computeCalibratedVps(this.superFrame, lines)) == null) {
            return null;
        }
        Mat deperspectiveHomography = this.deperspectiver.findHomography(this.superFrame, (Calibrated.AngleCalibrated[])calibratedVps);
        if (deperspectiveHomography == null) {
            return null;
        }
        this.superFrame.draw(lines, new Scalar(0.0, 0.0, 255.0), 1);
        this.superFrame.drawVanishingPointLines(lines, calibratedVps[0], new Scalar(0.0, 255.0, 0.0), 1);
        this.superFrame.drawVanishingPointLines(lines, calibratedVps[1], new Scalar(255.0, 0.0, 0.0), 1);
        this.superFrame.drawVpsArrows(calibratedVps, new double[]{20.0, 20.0}, new Scalar(0.0, 255.0, 0.0), 2);
        images[0] = this.superFrame.getDisplay().toJfxImage();
        SuperTemplate superDeperspectived = this.superFrame.deperspective(deperspectiveHomography);
        images[1] = superDeperspectived.getDiffFrame().toJfxImage();
        List<Rect> detectedRects = superDeperspectived.detectRects();
        superDeperspectived.drawRects(detectedRects, new Scalar(0.0, 255.0, 0.0), -1);
        SuperTemplate surfaceTemplate = new SuperTemplate(new SuperFrameImg(superDeperspectived.getDisplay().bgr2Gray().getSrc(), this.superFrame.getPp(), 672.5555555555555), CvType.CV_8UC1, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getDisplay));
        Layout surfaceLayout = surfaceTemplate.layout();
        double surface = surfaceLayout.normalizedArea();
        superDeperspectived.putText(String.valueOf(surface));
        images[2] = superDeperspectived.getDisplay().toJfxImage();
        SuperTemplate superReferenceTemplate4 = new SuperTemplate(superDeperspectived, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        List<SuperFrameImg.SuperContour> detectedSuperContours = superReferenceTemplate4.detectSuperContours(20.0);
        detectedSuperContours.stream().forEach(c -> Imgproc.line((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)c.top, (Point)c.bottom, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1));
        detectedSuperContours.stream().forEach(c -> Imgproc.line((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)c.left, (Point)c.right, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1));
        detectedSuperContours.stream().map(sc -> sc.center).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.left).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.right).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.top).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 255.0, 255.0), (int)-1));
        detectedSuperContours.stream().map(sc -> sc.bottom).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate4.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(255.0, 0.0, 255.0), (int)-1));
        images[3] = superReferenceTemplate4.getDisplay().toJfxImage();
        SuperTemplate superReferenceTemplate5 = new SuperTemplate(this.superFrame, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        List<SuperFrameImg.SuperContour> detectedSuperContours2 = superReferenceTemplate5.detectSuperContours(20.0);
        detectedSuperContours2.stream().forEach(c -> Imgproc.line((Mat)superReferenceTemplate5.getDisplay().getSrc(), (Point)c.top, (Point)c.bottom, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1));
        detectedSuperContours2.stream().forEach(c -> Imgproc.line((Mat)superReferenceTemplate5.getDisplay().getSrc(), (Point)c.left, (Point)c.right, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1));
        detectedSuperContours2.stream().map(sc -> sc.center).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate5.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)-1));
        detectedSuperContours2.stream().map(sc -> sc.left).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate5.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)-1));
        detectedSuperContours2.stream().map(sc -> sc.right).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate5.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)-1));
        detectedSuperContours2.stream().map(sc -> sc.top).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate5.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(0.0, 255.0, 255.0), (int)-1));
        detectedSuperContours2.stream().map(sc -> sc.bottom).forEach(pt -> Imgproc.circle((Mat)superReferenceTemplate5.getDisplay().getSrc(), (Point)pt, (int)3, (Scalar)new Scalar(255.0, 0.0, 255.0), (int)-1));
        images[4] = superReferenceTemplate5.getDisplay().toJfxImage();
        SuperTemplate superReferenceTemplate2 = new SuperTemplate(superReferenceTemplate5, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        List<SuperFrameImg.Span> spans = superReferenceTemplate2.assembleContours(detectedSuperContours2, c -> true, 100.0, 5.0, 100.0);
        spans.forEach(sp -> {
            double a = Math.random() * 255.0;
            double b = Math.random() * 255.0;
            double c = Math.random() * 255.0;
            Scalar color = new Scalar(a, b, c);
            sp.getContours().forEach(ct -> Imgproc.drawContours((Mat)superReferenceTemplate2.getDisplay().getSrc(), Arrays.asList(ct.contour), (int)0, (Scalar)color, (int)-1));
            if (!sp.getContours().isEmpty()) {
                Point[] pointer = new Point[]{sp.getContours().get((int)0).center};
                sp.getContours().forEach(ct -> {
                    Imgproc.line((Mat)superReferenceTemplate2.getDisplay().getSrc(), (Point)pointer[0], (Point)ct.center, (Scalar)color, (int)1);
                    pointer[0] = ct.center;
                });
            }
        });
        int rows = spans.size();
        int cols = (int)superReferenceTemplate2.size().width / 10;
        Double[][] table = new Double[rows][cols];
        for (row = 0; row < rows; ++row) {
            for (col = 0; col < cols; ++col) {
                table[row][col] = spans.get(row).getApprox().apply((double)col * 10.0);
            }
        }
        for (row = 1; row < rows - 1; ++row) {
            for (col = 0; col < cols; ++col) {
                if (table[row][col] != null || col <= 0 || table[row][col - 1] == null) continue;
                for (topRow = row - 1; topRow >= 0 && (table[topRow][col - 1] == null || table[topRow][col] == null); --topRow) {
                }
                if (topRow < 0) continue;
                for (bottomRow = row + 1; bottomRow < rows && (table[bottomRow][col - 1] == null || table[bottomRow][col] == null); ++bottomRow) {
                }
                if (bottomRow >= rows) continue;
                rapport = (table[row][col - 1] - table[topRow][col - 1]) / (table[bottomRow][col - 1] - table[topRow][col - 1]);
                table[row][col] = rapport * (table[bottomRow][col] - table[topRow][col]) + table[topRow][col];
            }
        }
        for (row = 0; row < rows - 1; ++row) {
            for (col = cols - 2; col >= 0; --col) {
                if (table[row][col] != null || col >= cols - 1 || table[row][col + 1] == null) continue;
                for (topRow = row - 1; topRow >= 0 && (table[topRow][col + 1] == null || table[topRow][col] == null); --topRow) {
                }
                if (topRow < 0) continue;
                for (bottomRow = row + 1; bottomRow < rows && (table[bottomRow][col + 1] == null || table[bottomRow][col] == null); ++bottomRow) {
                }
                if (bottomRow >= rows) continue;
                rapport = (table[row][col + 1] - table[topRow][col + 1]) / (table[bottomRow][col + 1] - table[topRow][col + 1]);
                table[row][col] = rapport * (table[bottomRow][col] - table[topRow][col]) + table[topRow][col];
            }
        }
        for (row = 0; row < rows; ++row) {
            Point pointer = table[row][0] != null ? new Point(0.0, table[row][0].doubleValue()) : null;
            for (int col2 = 1; col2 < cols; ++col2) {
                Point tmp;
                Point point = tmp = table[row][col2] != null ? new Point((double)(col2 * 10), table[row][col2].doubleValue()) : null;
                if (tmp != null && pointer != null) {
                    Imgproc.line((Mat)superReferenceTemplate2.getDisplay().getSrc(), (Point)pointer, (Point)tmp, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
                }
                pointer = tmp;
            }
        }
        images[5] = superReferenceTemplate2.getDisplay().toJfxImage();
        ImgDescriptor newImgDescriptor = new ImgDescriptor(superDeperspectived, surface);
        if (newImgDescriptor.getDescriptors().empty()) {
            System.out.println("Empty descriptors");
            return null;
        }
        this.referenceManager.submit(newImgDescriptor, detectedRects);
        List<Rect> referenceRects = this.referenceManager.getReferenceRects();
        SuperTemplate referenceTemplate = new SuperTemplate(this.referenceManager.getReference().getSuperFrame(), CvType.CV_8UC1, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        referenceTemplate.drawRects(referenceRects, new Scalar(255.0), -1);
        images[6] = referenceTemplate.getDisplay().toJfxImage();
        SuperTemplate superReferenceTemplate3 = new SuperTemplate(this.superFrame, CvType.CV_8UC1, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getFrame));
        superReferenceTemplate3.drawRects(this.referenceManager.getResizedFieldsRects(), new Scalar(255.0), -1);
        images[7] = superReferenceTemplate3.getDisplay().toJfxImage();
        SuperTemplate layoutTemplate = new SuperTemplate(referenceTemplate, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)SuperFrameImg::getDisplay));
        Layout layout = layoutTemplate.layout();
        layoutTemplate.drawLayout(layout);
        images[8] = layoutTemplate.getDisplay().toJfxImage();
        return images;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onR() {
        this.timer.schedule(() -> this.referenceManager.clear(), 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void onT() {
        this.config.textsEnabledMode = !this.config.textsEnabledMode;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

