/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import org.genericsystem.cv.Img;
import org.genericsystem.cv.PdfToPngConverter;
import org.genericsystem.cv.application.SuperFrameImg;
import org.opencv.core.Size;

interface GSCapture {
    public static final Size HD = new Size(1280.0, 720.0);
    public static final Size VGA = new Size(640.0, 360.0);

    public SuperFrameImg read();

    public void release();

    public Size getResize();

    public static class GSPhotoCapture
    implements GSCapture {
        private final SuperFrameImg superFrame;

        public GSPhotoCapture(String url, double f) {
            Img img = url.endsWith(".pdf") ? PdfToPngConverter.imgFromPdf(url, 0) : new Img(url);
            double coeff = Math.min(GSPhotoCapture.VGA.width / (double)img.width(), GSPhotoCapture.VGA.height / (double)img.height());
            img = img.resize(new Size(coeff * (double)img.width(), coeff * (double)img.height()));
            this.superFrame = new SuperFrameImg(img.getSrc(), new double[]{img.width() / 2, img.height() / 2}, f);
        }

        @Override
        public SuperFrameImg read() {
            return this.superFrame;
        }

        @Override
        public void release() {
            this.superFrame.getFrame().getSrc().release();
        }

        @Override
        public Size getResize() {
            return this.superFrame.size();
        }
    }
}

