/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;

public class Svd {
    public static void main(String[] args) {
        double[][] pts = new double[][]{{-2.0, 1.0, 1.0}, {0.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {-1.0, 0.0, 1.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 1.0}, {-1.0, -1.0, 1.0}, {0.0, -1.0, 1.0}, {1.0, -1.0, 1.0}};
        int[][] rects = new int[][]{{0, 1, 4, 3}, {1, 2, 5, 4}, {2, 3, 7, 6}, {4, 5, 7, 8}};
        double[][] result = Svd.solve((double[][])pts, rects);
        System.out.println(Arrays.deepToString((Object[])result));
    }

    public static double[][] solve(double[][] srcPts, int[][] rects) {
        int i;
        double[][] pts = (double[][])srcPts.clone();
        double[] stdxy = new double[]{Math.sqrt(Arrays.stream(pts).mapToDouble(pt -> pt[0] * pt[0]).average().getAsDouble()), Math.sqrt(Arrays.stream(pts).mapToDouble(pt -> pt[1] * pt[1]).average().getAsDouble())};
        for (double[] pt2 : pts) {
            pt2[0] = pt2[0] / stdxy[0];
            pt2[1] = pt2[1] / stdxy[1];
        }
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (double[] pt3 : pts) {
            if (pt3[0] < xmin) {
                xmin = pt3[0];
            }
            if (pt3[1] < ymin) {
                ymin = pt3[1];
            }
            if (pt3[0] > xmax) {
                xmax = pt3[0];
            }
            if (!(pt3[1] < ymax)) continue;
            ymax = pt3[1];
        }
        double meanspan = Math.max(Math.max(Math.abs(xmin), Math.abs(xmax)), Math.max(Math.abs(ymin), Math.abs(ymax)));
        double lambda = 1.0 / (meanspan * meanspan);
        int n = pts.length;
        int m = rects.length;
        double[] polarity = new double[]{-1.0, 1.0, -1.0, 1.0};
        int nDim = 3;
        System.out.println("n = " + n);
        Mat A = new Mat(nDim * m, 3 * n, CvType.CV_64FC1, new Scalar(0.0));
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < nDim; ++j) {
                int constraint_index = nDim * i2 + j;
                for (int k = 0; k < 4; ++k) {
                    A.put(constraint_index, 3 * rects[i2][k] + j, new double[]{polarity[k]});
                }
            }
        }
        for (int row = 0; row < A.rows(); ++row) {
            for (int col = 0; col < A.cols(); ++col) {
                System.out.print(A.get(row, col)[0] + " ");
            }
            System.out.println();
        }
        System.out.println();
        Mat B = new Mat(2 * n, 3 * n, CvType.CV_64FC1, new Scalar(0.0));
        for (int i3 = 0; i3 < n; ++i3) {
            B.put(2 * i3, 3 * i3, new double[]{1.0});
            B.put(2 * i3, 3 * i3 + 2, new double[]{-pts[i3][0]});
            B.put(2 * i3 + 1, 3 * i3 + 1, new double[]{1.0});
            B.put(2 * i3 + 1, 3 * i3 + 2, new double[]{-pts[i3][1]});
        }
        for (int row = 0; row < B.rows(); ++row) {
            for (int col = 0; col < B.cols(); ++col) {
                System.out.print(B.get(row, col)[0] + " ");
            }
            System.out.println();
        }
        System.out.println();
        Mat dst = new Mat();
        Core.gemm((Mat)A.t(), (Mat)A, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Mat dst2 = new Mat();
        Core.gemm((Mat)B.t(), (Mat)B, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst2);
        Mat M = new Mat();
        Core.addWeighted((Mat)dst, (double)1.0, (Mat)dst2, (double)lambda, (double)0.0, (Mat)M);
        Mat eigenValues = new Mat();
        Mat eigenVectors = new Mat();
        Core.eigen((Mat)M, (Mat)eigenValues, (Mat)eigenVectors);
        Mat result = eigenVectors.col(eigenVectors.cols() - 1);
        Mat sum = new Mat();
        Core.reduce((Mat)result, (Mat)sum, (int)0, (int)0);
        double sum_ = sum.get(0, 0)[0];
        for (i = 0; i < pts.length; ++i) {
            pts[i][2] = sum_ > 0.0 ? -result.get(i, 0)[0] : result.get(i, 0)[0];
        }
        for (i = 0; i < pts.length; ++i) {
            pts[i][0] = pts[i][0] * stdxy[0];
            pts[i][1] = pts[i][1] * stdxy[1];
        }
        return pts;
    }

    static double[] mul(double[][] datas, double[] sol) {
        double[] result = new double[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            for (int j = 0; j < datas[i].length; ++j) {
                int n = i;
                result[n] = result[n] + datas[i][j];
            }
        }
        return result;
    }

    static double[] solve(double[][] datas, double[] coeffs) {
        Mat li_set = new Mat(9, datas.length, CvType.CV_64FC1);
        Mat tau = new Mat(datas.length, datas.length, CvType.CV_64FC1, new Scalar(0.0, 0.0, 0.0));
        int i = 0;
        for (double[] data : datas) {
            int j = 0;
            for (double dat : data) {
                li_set.put(j, i, new double[]{dat});
                ++j;
            }
            tau.put(i, i, new double[]{coeffs[i]});
            ++i;
        }
        Mat L = li_set.t();
        Mat ATA = new Mat();
        Mat dst = new Mat();
        Core.gemm((Mat)L.t(), (Mat)tau.t(), (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Core.gemm((Mat)dst, (Mat)tau, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Core.gemm((Mat)dst, (Mat)L, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)ATA);
        Mat v = new Mat();
        Core.SVDecomp((Mat)ATA, (Mat)new Mat(), (Mat)v, (Mat)new Mat());
        if (v.rows() < 9) {
            throw new IllegalStateException();
        }
        return new double[]{v.get(0, 8)[0], v.get(1, 8)[0], v.get(2, 8)[0], v.get(3, 8)[0], v.get(4, 8)[0], v.get(5, 8)[0], v.get(6, 8)[0], v.get(7, 8)[0], v.get(8, 8)[0]};
    }

    static {
        NativeLibraryLoader.load();
    }
}

