/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.text.OCRTesseract;

public class Ocr {
    private static final GenericObjectPool<OCRTesseract> tesseractInstancePool;
    private static final String TESSDATA_PATH = "/usr/share/tesseract-ocr/4.00/";
    private static final String TESSDATA_ALT_PATH;
    private static final String TESSERACT_LANGUAGE = "fra";
    private static final String TESSERACT_CHAR_WHITE_LIST = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0123456789.-,<>!?;\u00e9\u00e8\u00e0\u00e7\u00c9\u00c8\u00c0\u00c7\u20ac\u00a3$\u0153'";
    private static final int TESSERACT_OEM = 1;
    private static final int TESSERACT_PSMODE = 13;

    public static String doWork(Mat mat) {
        return Ocr.doWork(mat, 0);
    }

    public static String doWork(Mat mat, int minConfidence) {
        OCRTesseract instance = null;
        String ocrText = null;
        try {
            instance = (OCRTesseract)tesseractInstancePool.borrowObject();
            ocrText = instance.run(mat, minConfidence, 1).replace("\n", "").trim();
        }
        catch (Exception e) {
            throw new RuntimeException("An error has occured during the OCR", e);
        }
        finally {
            if (instance != null) {
                tesseractInstancePool.returnObject((Object)instance);
            }
        }
        return ocrText;
    }

    private static GenericObjectPoolConfig buildPoolConfig() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(Runtime.getRuntime().availableProcessors());
        config.setBlockWhenExhausted(true);
        config.setMaxWaitMillis(30000L);
        return config;
    }

    static {
        NativeLibraryLoader.load();
        tesseractInstancePool = new GenericObjectPool((PooledObjectFactory)new OCRTesseractInstanceFactory(), Ocr.buildPoolConfig());
        TESSDATA_ALT_PATH = System.getenv("TESSDATA_PREFIX");
    }

    public static class OCRTesseractInstanceFactory
    extends BasePooledObjectFactory<OCRTesseract> {
        public OCRTesseract create() throws Exception {
            OCRTesseract instance = null;
            try {
                instance = OCRTesseract.create((String)Ocr.TESSDATA_PATH, (String)Ocr.TESSERACT_LANGUAGE, (String)Ocr.TESSERACT_CHAR_WHITE_LIST, (int)1, (int)13);
            }
            catch (Exception e) {
                try {
                    instance = OCRTesseract.create((String)TESSDATA_ALT_PATH, (String)Ocr.TESSERACT_LANGUAGE, (String)Ocr.TESSERACT_CHAR_WHITE_LIST, (int)1, (int)13);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Unable to load tesseract data. Please ensure that tesseract-ocr is installed and configured properly on your system.", e);
                }
            }
            return instance;
        }

        public PooledObject<OCRTesseract> wrap(OCRTesseract instance) {
            return new DefaultPooledObject((Object)instance);
        }
    }
}

