/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.LinesDetector8;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;
import org.opencv.videoio.VideoCapture;

public class LinesDetector10
extends AbstractApp {
    static final double f = 672.5555555555555;
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private LinesDetector8.Lines lines;
    private Point[] trapezePoints;
    double[][] vps;
    private boolean stabilize = false;

    public static void main(String[] args) {
        LinesDetector10.launch((String[])args);
    }

    private Mat dumpTrapezePointsHomography(Mat homography, double dumpSize, Size size) {
        MatOfPoint2f results = new MatOfPoint2f();
        MatOfPoint2f framePoints = new MatOfPoint2f(new Point[]{new Point(0.0, 0.0), new Point(size.width, 0.0), new Point(size.width, size.height), new Point(0.0, size.height)});
        Core.perspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(0.0, 0.0), new Point(size.width, 0.0), new Point(size.width, size.height), new Point(0.0, size.height))), (Mat)results, (Mat)homography);
        this.dumpTrapezePoints(results.toArray(), dumpSize);
        return Imgproc.getPerspectiveTransform((Mat)framePoints, (Mat)new MatOfPoint2f(this.trapezePoints));
    }

    private void dumpTrapezePoints(Point[] newPoints, double dumpSize) {
        for (int i = 0; i < this.trapezePoints.length; ++i) {
            this.trapezePoints[i] = new Point(((dumpSize - 1.0) * this.trapezePoints[i].x + newPoints[i].x) / dumpSize, ((dumpSize - 1.0) * this.trapezePoints[i].y + newPoints[i].y) / dumpSize);
        }
    }

    @Override
    protected void onSpace() {
        this.stabilize = !this.stabilize;
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        Mat dePerspectived = new Mat();
        this.capture.read(frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskiewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskiewedView, 0, 1);
        ImageView gradView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)gradView, 1, 0);
        ImageView gradView2 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)gradView2, 1, 1);
        this.trapezePoints = new Point[]{new Point(0.0, 0.0), new Point((double)frame.width(), 0.0), new Point((double)frame.width(), (double)frame.height()), new Point(0.0, (double)frame.height())};
        Img[] binarized = new Img[1];
        this.timer.scheduleAtFixedRate(() -> {
            try {
                if (!this.stabilize) {
                    this.capture.read(frame);
                }
                ArrayList addedLines = new ArrayList();
                Img grad = new Img(frame, false).morphologyEx(4, 2, new Size(3.0, 3.0)).otsu();
                Img closed = grad.morphologyEx(3, 2, new Size(10.0, 10.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
                Img closed2 = grad.morphologyEx(3, 2, new Size(30.0, 30.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
                gradView.setImage(closed.toJfxImage());
                gradView2.setImage(closed2.toJfxImage());
                if (!this.stabilize) {
                    this.lines = new LinesDetector8.Lines(closed.houghLinesP(1, Math.PI / 180, 10, 10.0, 5.0));
                    this.lines.lines.addAll(new LinesDetector8.Lines((Mat)closed2.houghLinesP((int)1, (double)(Math.PI / 180), (int)10, (double)30.0, (double)10.0)).lines);
                    this.lines.lines.addAll(addedLines);
                }
                if (this.lines.size() > 10) {
                    Mat colorFrame = frame.clone();
                    this.lines.draw(colorFrame, new Scalar(0.0, 0.0, 0.0));
                    LinesDetector linesDetector = new LinesDetector(new Img(frame, false), this.lines.lines, this.vps);
                    this.vps = linesDetector.getVps();
                    Map<Integer, List<Integer>> clusters = linesDetector.lines2Vps(0.08726646259971647);
                    for (int cluster : clusters.keySet()) {
                        for (int lineId : clusters.get(cluster)) {
                            this.lines.lines.get(lineId).draw(colorFrame, new Scalar(cluster == 0 ? 255.0 : 0.0, cluster == 1 ? 255.0 : 0.0, cluster == 2 ? 255.0 : 0.0));
                        }
                    }
                    frameView.setImage(Tools.mat2jfxImage(colorFrame));
                    Mat homographyMat = LinesDetector10.findHomography(frame.size(), this.vps, new double[]{frame.width() / 2, frame.height() / 2, 1.0}, 672.5555555555555);
                    Mat dumpedHomographyMat = this.dumpTrapezePointsHomography(homographyMat, 1.0, frame.size());
                    Imgproc.warpPerspective((Mat)frame, (Mat)dePerspectived, (Mat)dumpedHomographyMat, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    deskiewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + this.lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 50L, TimeUnit.MILLISECONDS);
    }

    private Mat getDiffFrame(Mat frame) {
        Mat result = new Mat();
        Imgproc.cvtColor((Mat)frame, (Mat)result, (int)6);
        Imgproc.GaussianBlur((Mat)result, (Mat)result, (Size)new Size(3.0, 3.0), (double)0.0);
        Mat diffFrame = new Mat();
        Core.absdiff((Mat)result, (Scalar)new Scalar(255.0), (Mat)diffFrame);
        Imgproc.adaptiveThreshold((Mat)diffFrame, (Mat)diffFrame, (double)255.0, (int)0, (int)1, (int)7, (double)3.0);
        return diffFrame;
    }

    private Collection<Circle> selectRandomCirles(List<Circle> circles, int circlesNumber) {
        if (circles.size() <= circlesNumber) {
            return circles;
        }
        HashSet<Circle> result = new HashSet<Circle>();
        while (result.size() < circlesNumber) {
            result.add(circles.get((int)(Math.random() * (double)circles.size())));
        }
        return result;
    }

    private List<Circle> detectCircles(Mat frame, Mat diffFrame, int minRadius, int maxRadius) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)diffFrame, contours, (Mat)new Mat(), (int)1, (int)2);
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (int i = 0; i < contours.size(); ++i) {
            MatOfPoint contour = (MatOfPoint)contours.get(i);
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > 50.0)) continue;
            float[] radius = new float[1];
            Point center = new Point();
            MatOfPoint2f contour2F = new MatOfPoint2f(contour.toArray());
            Imgproc.minEnclosingCircle((MatOfPoint2f)contour2F, (Point)center, (float[])radius);
            if (!(radius[0] > (float)minRadius) || !(radius[0] < (float)maxRadius) || !(center.x > (double)radius[0]) || !(center.y > (double)radius[0]) || !(center.x + (double)radius[0] < (double)frame.width()) || !(center.y + (double)radius[0] < (double)frame.height())) continue;
            circles.add(new Circle(center, radius[0]));
        }
        return circles;
    }

    public Img getCircledImg(Mat frame, int radius, Point center) {
        Mat mask = new Mat(new Size((double)(radius * 2), (double)(radius * 2)), CvType.CV_8UC1, new Scalar(0.0));
        Imgproc.circle((Mat)mask, (Point)new Point((double)radius, (double)radius), (int)radius, (Scalar)new Scalar(255.0), (int)-1);
        Rect rect = new Rect(new Point(center.x - (double)radius, center.y - (double)radius), new Point(center.x + (double)radius, center.y + (double)radius));
        Mat roi = new Img(new Mat(frame, rect), true).bilateralFilter().adaptativeGaussianInvThreshold(3, 3.0).getSrc();
        Mat circled = new Mat();
        roi.copyTo(circled, mask);
        Img circledImg = new Img(circled, false);
        return circledImg;
    }

    public LinesDetector8.Line buildLine(Mat mat, Point center, double angle, double size) {
        double x1 = center.x - Math.sin(angle) * size;
        double y1 = center.y + Math.cos(angle) * size;
        double x2 = center.x + Math.sin(angle) * size;
        double y2 = center.y - Math.cos(angle) * size;
        return new LinesDetector8.Line(new Point(x1, y1), new Point(x2, y2));
    }

    public double score(Img circled, double angle, int filterSize, double threshold) {
        Mat M = Imgproc.getRotationMatrix2D((Point)new Point((double)(circled.width() / 2), (double)(circled.width() / 2)), (double)angle, (double)1.0);
        Mat rotated = new Mat();
        Imgproc.warpAffine((Mat)circled.getSrc(), (Mat)rotated, (Mat)M, (Size)new Size((double)circled.width(), (double)circled.width()));
        Img binarized = new Img(rotated, false).directionalFilter(filterSize).thresHold(threshold, 255.0, 0);
        Mat result = new Mat();
        Core.reduce((Mat)binarized.getSrc(), (Mat)result, (int)1, (int)0, (int)6);
        Core.reduce((Mat)result, (Mat)result, (int)0, (int)0, (int)6);
        return result.get(0, 0)[0];
    }

    public double getBestAngle(Img circledImg, int absMinMax, double step, int filterSize, double threshold, Img[] binarized) {
        double maxScore = 0.0;
        double bestAngle = -1.0;
        if (binarized != null) {
            binarized[0] = new Img(new Mat(new Size((double)(2 * absMinMax * 10), 200.0), CvType.CV_8UC1, new Scalar(0.0)), false);
        }
        ArrayList<double[]> results = new ArrayList<double[]>();
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += step) {
            double score = this.score(circledImg, angle, filterSize, threshold);
            if (angle != 0.0 && score > maxScore) {
                maxScore = score;
                bestAngle = angle;
            }
            if (angle != 0.0) {
                results.add(new double[]{angle, score});
            }
            if (binarized == null) continue;
            new LinesDetector8.Line(((double)absMinMax + angle) * 10.0, 0.0, ((double)absMinMax + angle) * 10.0, score / 1000.0).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0), 10);
        }
        BiFunction<Double, double[], Double> f = (x, params) -> params[0] * x * x * x * x + params[1] * x * x * x + params[2] * x * x + params[3] * x + params[4];
        BiFunction<double[], double[], Double> e = (xy, params) -> (Double)f.apply(xy[0], (double[])params) - xy[1];
        double[] result = new LevenbergImpl<double[]>(e, results, new double[]{1.0, 1.0, 1.0, 1.0, 1.0}).getParams();
        Point point = null;
        double polynomAngle = 0.0;
        double max = 0.0;
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += 1.0) {
            Point oldPoint = point;
            double score = f.apply(angle, result);
            point = new Point(((double)absMinMax + angle) * 10.0, score / 1000.0);
            if (score > max) {
                max = score;
                polynomAngle = angle;
            }
            if (binarized == null || oldPoint == null) continue;
            new LinesDetector8.Line(oldPoint, point).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0));
        }
        if (binarized != null) {
            Imgproc.circle((Mat)binarized[0].getSrc(), (Point)new Point(((double)absMinMax + polynomAngle) * 10.0, max / 1000.0), (int)10, (Scalar)new Scalar(255.0, 255.0, 0.0), (int)3);
        }
        return polynomAngle;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    public static Mat findHomography(Size size, double[][] vps, double[] pp, double f) {
        double theta = Math.atan2(vps[0][1], vps[0][0]);
        double phi = Math.acos(vps[0][2]);
        double[][] vps2D = LinesDetector10.getVp2DFromVps(vps, pp, f);
        System.out.println("vps2D : " + Arrays.deepToString((Object[])vps2D));
        System.out.println("vps : " + Arrays.deepToString((Object[])vps));
        double theta2 = Math.atan2(vps[1][1], vps[1][0]);
        double phi2 = Math.acos(vps[1][2]);
        double x = size.width / 8.0;
        double[] A = new double[]{size.width / 2.0, size.height / 2.0, 1.0};
        double[] B = new double[]{Math.cos(theta) < 0.0 ? size.width / 2.0 - x : size.width / 2.0 + x, size.height / 2.0};
        double[] D = new double[]{size.width / 2.0, Math.sin(theta2) < 0.0 ? size.height / 2.0 - x : size.height / 2.0 + x, 1.0};
        double[] C = new double[]{Math.cos(theta) < 0.0 ? size.width / 2.0 - x : size.width / 2.0 + x, Math.sin(theta2) < 0.0 ? size.height / 2.0 - x : size.height / 2.0 + x};
        System.out.println("vp1 (" + theta * 180.0 / Math.PI + "\u00b0, " + phi * 180.0 / Math.PI + "\u00b0)");
        System.out.println("vp2 (" + theta2 * 180.0 / Math.PI + "\u00b0, " + phi2 * 180.0 / Math.PI + "\u00b0)");
        double[] A_ = A;
        double[] B_ = new double[]{size.width / 2.0 + x * Math.sin(phi) * Math.cos(theta), size.height / 2.0 + x * Math.sin(phi) * Math.sin(theta), 1.0};
        double[] D_ = new double[]{size.width / 2.0 + x * Math.sin(phi2) * Math.cos(theta2), size.height / 2.0 + x * Math.sin(phi2) * Math.sin(theta2), 1.0};
        double[] C_ = LinesDetector10.cross2D(LinesDetector10.cross(B_, vps2D[1]), LinesDetector10.cross(D_, vps2D[0]));
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(A_), new Point(B_), new Point(C_), new Point(D_)}), (Mat)new MatOfPoint2f(new Point[]{new Point(A), new Point(B), new Point(C), new Point(D)}));
    }

    static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    static double det(double[] u, double[] v, double[] w) {
        return u[0] * v[1] * w[2] + u[2] * v[0] * w[1] + u[1] * v[2] * w[0] - u[2] * v[1] * w[0] - u[1] * v[0] * w[2] - u[0] * v[2] * w[1];
    }

    static double[] cross2D(double[] a, double[] b) {
        return LinesDetector10.on2D(LinesDetector10.cross(a, b));
    }

    static double[] on2D(double[] a) {
        return new double[]{a[0] / a[2], a[1] / a[2], 1.0};
    }

    static double[] getVpFromVp2D(double[] vpImg, double[] pp, double f) {
        double[] vp = new double[]{vpImg[0] / vpImg[2] - pp[0], vpImg[1] / vpImg[2] - pp[1], f};
        if (vp[2] == 0.0) {
            vp[2] = 0.0011;
        }
        double N = Math.sqrt(vp[0] * vp[0] + vp[1] * vp[1] + vp[2] * vp[2]);
        vp[0] = vp[0] * (1.0 / N);
        vp[1] = vp[1] * (1.0 / N);
        vp[2] = vp[2] * (1.0 / N);
        return vp;
    }

    public static double[][] getVp2DFromVps(double[][] vps, double[] pp, double f) {
        double[][] result = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            result[i][0] = vps[i][0] * f / vps[i][2] + pp[0];
            result[i][1] = vps[i][1] * f / vps[i][2] + pp[1];
            result[i][2] = 1.0;
        }
        return result;
    }

    static double[] getVp2DFromVp(double[] vp, double[] pp, double f) {
        return new double[]{vp[0] * f / vp[2] + pp[0], vp[1] * f / vp[2] + pp[1]};
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class LinesDetector {
        private final List<LinesDetector8.Line> lines;
        private final double[] pp;
        private double noiseRatio = 0.5;
        double[][] vps;

        public LinesDetector(Img img, List<LinesDetector8.Line> lines, double[][] oldVps) {
            this.lines = lines;
            this.pp = new double[]{img.width() / 2, img.height() / 2};
            List<LineInfo> linesInfos = this.getLinesInfos(lines);
            double[][] sphereGrid = this.getSphereGrids(linesInfos);
            this.vps = this.getBestVpsHyp(this.getVpsHypos(linesInfos), sphereGrid);
            double vpsRes = this.evaluateVpsHypo(this.vps, sphereGrid);
            if (oldVps != null) {
                double oldVpsRes = this.evaluateVpsHypo(oldVps, sphereGrid);
                if (oldVpsRes > vpsRes) {
                    System.out.println("Warning, old vps is better : " + oldVpsRes + " " + vpsRes);
                    System.out.println("old : " + Arrays.deepToString((Object[])LinesDetector10.getVp2DFromVps(oldVps, this.pp, 672.5555555555555)));
                    System.out.println("new : " + Arrays.deepToString((Object[])LinesDetector10.getVp2DFromVps(this.vps, this.pp, 672.5555555555555)));
                    this.vps = oldVps;
                } else {
                    System.out.println("All is ok : " + oldVpsRes + " " + vpsRes);
                }
            }
        }

        public double[][] getVps() {
            return this.vps;
        }

        private List<LineInfo> getLinesInfos(List<LinesDetector8.Line> lines) {
            ArrayList<LineInfo> lineInfos = new ArrayList<LineInfo>();
            for (LinesDetector8.Line line : lines) {
                double[] p1 = new double[]{line.x1, line.y1, 1.0};
                double[] p2 = new double[]{line.x2, line.y2, 1.0};
                double[] para = LinesDetector10.cross(p1, p2);
                double dx = line.x1 - line.x2;
                double dy = line.y1 - line.y2;
                double length = Math.sqrt(dx * dx + dy * dy);
                double orientation = Math.atan2(dy, dx);
                if (orientation < 0.0) {
                    orientation += Math.PI;
                }
                lineInfos.add(new LineInfo(para, length, orientation));
            }
            return lineInfos;
        }

        private List<double[][]> getVpsHypos(List<LineInfo> linesInfos) {
            double p = 0.3333333333333333 * Math.pow(1.0 - this.noiseRatio, 2.0);
            double confEfficience = 0.9999;
            int iterations = (int)(Math.log(1.0 - confEfficience) / Math.log(1.0 - p));
            System.out.println("Iterations : " + iterations);
            int numVp2 = 360;
            double stepVp2 = Math.PI * 2 / (double)numVp2;
            ArrayList<double[][]> vpHypo = new ArrayList<double[][]>(iterations * numVp2);
            int num = linesInfos.size();
            for (int i = 0; i < iterations; ++i) {
                int idx1 = (int)(Math.random() * (double)num);
                int idx2 = (int)(Math.random() * (double)num);
                while (idx2 == idx1) {
                    idx2 = (int)(Math.random() * (double)num);
                }
                double[] vp1_Img = LinesDetector10.cross(linesInfos.get((int)idx1).para, linesInfos.get((int)idx2).para);
                if (vp1_Img[2] == 0.0) {
                    --i;
                    continue;
                }
                double[] vp1 = LinesDetector10.getVpFromVp2D(vp1_Img, this.pp, 672.5555555555555);
                double[] vp2 = new double[3];
                double[] vp3 = new double[3];
                for (int j = 0; j < numVp2; ++j) {
                    double lambda = (double)j * stepVp2;
                    double k1 = vp1[0] * Math.sin(lambda) + vp1[1] * Math.cos(lambda);
                    double k2 = vp1[2];
                    double phi = Math.atan(-k2 / k1);
                    vp2[0] = Math.sin(phi) * Math.sin(lambda);
                    vp2[1] = Math.sin(phi) * Math.cos(lambda);
                    vp2[2] = Math.cos(phi);
                    if (vp2[2] == 0.0) {
                        vp2[2] = 0.0011;
                    }
                    double N = Math.sqrt(vp2[0] * vp2[0] + vp2[1] * vp2[1] + vp2[2] * vp2[2]);
                    vp2[0] = vp2[0] * (1.0 / N);
                    vp2[1] = vp2[1] * (1.0 / N);
                    vp2[2] = vp2[2] * (1.0 / N);
                    if (vp2[2] < 0.0) {
                        vp2[0] = vp2[0] * -1.0;
                        vp2[1] = vp2[1] * -1.0;
                        vp2[2] = vp2[2] * -1.0;
                    }
                    if ((vp3 = LinesDetector10.cross(vp1, vp2))[2] == 0.0) {
                        vp3[2] = 0.0011;
                    }
                    N = Math.sqrt(vp3[0] * vp3[0] + vp3[1] * vp3[1] + vp3[2] * vp3[2]);
                    vp3[0] = vp3[0] * (1.0 / N);
                    vp3[1] = vp3[1] * (1.0 / N);
                    vp3[2] = vp3[2] * (1.0 / N);
                    if (vp3[2] < 0.0) {
                        vp3[0] = vp3[0] * -1.0;
                        vp3[1] = vp3[1] * -1.0;
                        vp3[2] = vp3[2] * -1.0;
                    }
                    vpHypo.add(this.reorderXyz(new double[][]{vp1, vp2, vp3}));
                }
            }
            return vpHypo;
        }

        private double[][] getSphereGrids(List<LineInfo> linesInfos) {
            double angelAccuracy = Math.PI / 180;
            double angleSpanLA = 1.5707963267948966;
            double angleSpanLO = Math.PI * 2;
            int gridLA = (int)(angleSpanLA / angelAccuracy);
            int gridLO = (int)(angleSpanLO / angelAccuracy);
            double[][] sphereGrid = new double[gridLA][gridLO];
            double angelTolerance = 1.0471975511965976;
            double latitude = 0.0;
            double longitude = 0.0;
            int LA = 0;
            int LO = 0;
            double angleDev = 0.0;
            for (int i = 0; i < linesInfos.size() - 1; ++i) {
                for (int j = i + 1; j < linesInfos.size(); ++j) {
                    LineInfo lii = linesInfos.get(i);
                    LineInfo lij = linesInfos.get(j);
                    double[] ptIntersect = LinesDetector10.cross(lii.para, lij.para);
                    if (ptIntersect[2] == 0.0) continue;
                    double X = ptIntersect[0] / ptIntersect[2] - this.pp[0];
                    double Y = ptIntersect[1] / ptIntersect[2] - this.pp[1];
                    double Z = 672.5555555555555;
                    double N = Math.sqrt(X * X + Y * Y + Z * Z);
                    latitude = Math.acos(Z / N);
                    longitude = Math.atan2(X, Y) + Math.PI;
                    LA = (int)(latitude / angelAccuracy);
                    if (LA >= gridLA) {
                        LA = gridLA - 1;
                    }
                    if ((LO = (int)(longitude / angelAccuracy)) >= gridLO) {
                        LO = gridLO - 1;
                    }
                    angleDev = Math.abs(lii.orientation - lij.orientation);
                    if ((angleDev = Math.min(Math.PI - angleDev, angleDev)) > angelTolerance) continue;
                    double[] dArray = sphereGrid[LA];
                    int n = LO;
                    dArray[n] = dArray[n] + Math.sqrt(lii.length * lij.length) * (Math.sin(2.0 * angleDev) + 0.2);
                }
            }
            int halfSize = 1;
            int winSize = halfSize * 2 + 1;
            int neighNum = winSize * winSize;
            double[][] sphereGridNew = new double[gridLA][gridLO];
            for (int i = halfSize; i < gridLA - halfSize; ++i) {
                for (int j = halfSize; j < gridLO - halfSize; ++j) {
                    double neighborTotal = 0.0;
                    for (int m = 0; m < winSize; ++m) {
                        for (int n = 0; n < winSize; ++n) {
                            neighborTotal += sphereGrid[i - halfSize + m][j - halfSize + n];
                        }
                    }
                    sphereGridNew[i][j] = sphereGrid[i][j] + neighborTotal / (double)neighNum;
                }
            }
            sphereGrid = sphereGridNew;
            return sphereGrid;
        }

        private double evaluateVpsHypo(double[][] hypo, double[][] sphereGrid) {
            double oneDegree = Math.PI / 180;
            double lineLength = 0.0;
            for (int j = 0; j < 2; ++j) {
                int gridLO;
                if (hypo[j][2] == 0.0) continue;
                double latitude = Math.acos(hypo[j][2]);
                double longitude = Math.atan2(hypo[j][0], hypo[j][1]) + Math.PI;
                int gridLA = (int)(latitude / oneDegree);
                if (gridLA == 90) {
                    gridLA = 89;
                }
                if ((gridLO = (int)(longitude / oneDegree)) == 360) {
                    gridLO = 359;
                }
                lineLength += sphereGrid[gridLA][gridLO];
            }
            return lineLength;
        }

        private double[][] getBestVpsHyp(List<double[][]> vpHypos, double[][] sphereGrid) {
            double[][] result = null;
            double maxLength = 0.0;
            for (double[][] vpHypo : vpHypos) {
                double lineLength = this.evaluateVpsHypo(vpHypo, sphereGrid);
                if (!(lineLength > maxLength)) continue;
                maxLength = lineLength;
                result = vpHypo;
            }
            return result;
        }

        private int index(double[][] hypo, int axe1, int axe2) {
            int index = 0;
            double minXY = Double.MAX_VALUE;
            for (int k = 0; k < 3; ++k) {
                double currentXY = hypo[k][axe1] * hypo[k][axe1] + hypo[k][axe2] * hypo[k][axe2];
                if (!(currentXY < minXY)) continue;
                index = k;
                minXY = currentXY;
            }
            return index;
        }

        private double[][] reorderXyz(double[][] vps) {
            return new double[][]{vps[this.index(vps, 1, 2)], vps[this.index(vps, 0, 2)], vps[this.index(vps, 0, 1)]};
        }

        public Map<Integer, List<Integer>> lines2Vps(double thAngle) {
            ArrayList<double[]> vp2D = new ArrayList<double[]>();
            for (int i = 0; i < 3; ++i) {
                vp2D.add(LinesDetector10.getVp2DFromVp(this.vps[i], this.pp, 672.5555555555555));
            }
            HashMap<Integer, List<Integer>> clusters = new HashMap<Integer, List<Integer>>(){

                @Override
                public List<Integer> get(Object key) {
                    ArrayList ids = (ArrayList)super.get(key);
                    if (ids == null) {
                        ids = new ArrayList();
                        this.put((Integer)key, ids);
                    }
                    return ids;
                }
            };
            for (int i = 0; i < this.lines.size(); ++i) {
                double x1 = this.lines.get((int)i).x1;
                double y1 = this.lines.get((int)i).y1;
                double x2 = this.lines.get((int)i).x2;
                double y2 = this.lines.get((int)i).y2;
                double xm = (x1 + x2) / 2.0;
                double ym = (y1 + y2) / 2.0;
                double v1x = x1 - x2;
                double v1y = y1 - y2;
                double N1 = Math.sqrt(v1x * v1x + v1y * v1y);
                v1x /= N1;
                v1y /= N1;
                double minAngle = 1000.0;
                int bestIdx = 0;
                for (int j = 0; j < 3; ++j) {
                    double N2;
                    double crossValue;
                    double v2x = ((double[])vp2D.get(j))[0] - xm;
                    double v2y = ((double[])vp2D.get(j))[1] - ym;
                    if ((crossValue = v1x * (v2x /= (N2 = Math.sqrt(v2x * v2x + v2y * v2y))) + v1y * (v2y /= N2)) > 1.0) {
                        crossValue = 1.0;
                    }
                    if (crossValue < -1.0) {
                        crossValue = -1.0;
                    }
                    double angle = Math.acos(crossValue);
                    if (!((angle = Math.min(Math.PI - angle, angle)) < minAngle)) continue;
                    minAngle = angle;
                    bestIdx = j;
                }
                if (!(minAngle < thAngle)) continue;
                ((List)clusters.get(bestIdx)).add(i);
            }
            return clusters;
        }

        static {
            NativeLibraryLoader.load();
        }

        private class LineInfo {
            double[] para;
            double length;
            double orientation;

            public LineInfo(double[] para, double length, double orientation) {
                this.para = para;
                this.length = length;
                this.orientation = orientation;
            }
        }
    }

    private static class Circle {
        Point center;
        float radius;

        public Circle(Point center, float radius) {
            this.center = center;
            this.radius = radius;
        }
    }
}

