/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.reinforcer.tools.GSPoint;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;

public final class RectToolsMapper {
    public static GSRect convert(Rect rect) {
        return new GSRect((double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
    }

    private static Rect convert(GSRect gsRect) {
        return new Rect((int)gsRect.getX(), (int)gsRect.getY(), (int)gsRect.getWidth(), (int)gsRect.getHeight());
    }

    private static Point convert(GSPoint gsPoint) {
        return new Point(gsPoint.getX(), gsPoint.getY());
    }

    private static GSPoint convert(Point point) {
        return new GSPoint(point.x, point.y);
    }

    public static List<Rect> gsRectToRect(List<GSRect> gsRects) {
        return RectToolsMapper.gsRectToRectStream(gsRects).collect(Collectors.toList());
    }

    public static Stream<Rect> gsRectToRectStream(List<GSRect> gsRects) {
        return gsRects.stream().map(RectToolsMapper::convert);
    }

    public static List<GSRect> rectToGSRect(List<Rect> rects) {
        return RectToolsMapper.rectToGSRectStream(rects).collect(Collectors.toList());
    }

    public static Stream<GSRect> rectToGSRectStream(List<Rect> rects) {
        return rects.stream().map(RectToolsMapper::convert);
    }

    public static List<Point> gsPointToPoint(List<GSPoint> gsPoints) {
        return RectToolsMapper.gsPointToPointStream(gsPoints).collect(Collectors.toList());
    }

    public static Stream<Point> gsPointToPointStream(List<GSPoint> gsPoints) {
        return gsPoints.stream().map(RectToolsMapper::convert);
    }

    public static List<GSPoint> pointToGSPoint(List<Point> points) {
        return RectToolsMapper.pointToGSPointStream(points).collect(Collectors.toList());
    }

    public static Stream<GSPoint> pointToGSPointStream(List<Point> points) {
        return points.stream().map(RectToolsMapper::convert);
    }
}

