/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.retriever.CamLiveRetriever;
import org.genericsystem.cv.retriever.Fields;
import org.genericsystem.cv.retriever.ImgDescriptor;
import org.genericsystem.cv.retriever.Stats;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgcodecs.Imgcodecs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieverFromImg {
    private static final Logger logger;
    private static final ObjectMapper mapper;
    private final Fields fields = new Fields();
    private static final String sourceDirPath = "classes2";
    private static final String targetDirPath = "../gs-reinforcer/data";

    public static void main(String[] args) {
        new RetrieverFromImg().extractData();
    }

    public void extractData() {
        Path sourceDir = Paths.get(sourceDirPath, new String[0]);
        Path targetDir = Paths.get(targetDirPath, new String[0]);
        try (Stream<Path> stream = Files.list(sourceDir);){
            stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(dir -> {
                try (DirectoryStream<Path> files = Files.newDirectoryStream(dir, path -> Files.isRegularFile(path, new LinkOption[0]));){
                    files.forEach(file -> this.computeFields((Path)file, targetDir));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFields(Path imgPath, Path targetDir) {
        Mat frame = new Img(Imgcodecs.imread((String)imgPath.toAbsolutePath().toString())).resize(1000).getSrc();
        ImgDescriptor stabilizedImgDescriptor = null;
        boolean stabilizationHasChanged = true;
        int stabilizationErrors = 0;
        boolean recoveringCounter = false;
        Stats.beginTask("deperspectivation");
        Mat deperspectivGraphy = Mat.eye((int)3, (int)3, (int)CvType.CV_64FC1);
        Stats.endTask("deperspectivation");
        for (int i = 0; i < 20; ++i) {
            try {
                if (deperspectivGraphy != null) {
                    if (stabilizedImgDescriptor == null) {
                        stabilizedImgDescriptor = new ImgDescriptor(frame, deperspectivGraphy);
                        continue;
                    }
                    if (stabilizationHasChanged && stabilizationErrors > 10) {
                        this.fields.reset();
                        stabilizationErrors = 0;
                        stabilizedImgDescriptor = new ImgDescriptor(frame, deperspectivGraphy);
                        continue;
                    }
                    Stats.beginTask("get img descriptors");
                    ImgDescriptor newImgDescriptor = new ImgDescriptor(frame, deperspectivGraphy);
                    Stats.endTask("get img descriptors");
                    Stats.beginTask("stabilization homography");
                    Mat betweenStabilizedHomography = stabilizedImgDescriptor.computeStabilizationGraphy(newImgDescriptor);
                    Stats.endTask("stabilization homography");
                    if (betweenStabilizedHomography != null) {
                        stabilizationErrors = 0;
                        Mat stabilizationHomographyFromFrame = new Mat();
                        Core.gemm((Mat)betweenStabilizedHomography.inv(), (Mat)deperspectivGraphy, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)stabilizationHomographyFromFrame);
                        Img stabilized = CamLiveRetriever.warpPerspective(frame, stabilizationHomographyFromFrame);
                        Img stabilizedDisplay = new Img(stabilized.getSrc(), true);
                        if (stabilizationHasChanged && !recoveringCounter) {
                            Stats.beginTask("stabilizationHasChanged");
                            stabilized = newImgDescriptor.getDeperspectivedImg();
                            stabilizedDisplay = new Img(stabilized.getSrc(), true);
                            Stats.beginTask("restabilizeFields");
                            this.fields.restabilizeFields(betweenStabilizedHomography);
                            System.out.println("fields restabilized");
                            Stats.endTask("restabilizeFields");
                            stabilizedImgDescriptor = newImgDescriptor;
                            stabilizationHomographyFromFrame = deperspectivGraphy;
                            stabilizationHasChanged = false;
                            Stats.endTask("stabilizationHasChanged");
                        }
                        Stats.beginTask("consolidate fields");
                        this.fields.consolidate(stabilizedDisplay);
                        Stats.endTask("consolidate fields");
                        Stats.beginTask("performOcr");
                        this.fields.performOcr(stabilized);
                        Stats.endTask("performOcr");
                    } else {
                        logger.warn("Unable to compute a valid stabilization ({} times)", (Object)(++stabilizationErrors));
                    }
                }
            }
            catch (Throwable e) {
                logger.warn("Exception while computing layout.", e);
            }
            finally {
                Stats.endTask("frame");
            }
            Path file = targetDir.resolve(imgPath).resolveSibling(imgPath.getFileName().toString() + ".json");
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                mapper.writerWithDefaultPrettyPrinter().writeValue(file.toFile(), (Object)this.fields);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        NativeLibraryLoader.load();
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        mapper = new ObjectMapper();
    }
}

