/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class TextOrientationLinesDetector {
    static List<Lines.Line> getTextOrientationLines(SuperFrameImg superFrame) {
        List<Circle> circles = TextOrientationLinesDetector.detectCircles(superFrame, 30, 100);
        Collection<Circle> selectedCircles = TextOrientationLinesDetector.selectRandomCirles(circles, 20);
        ArrayList<Lines.Line> result = new ArrayList<Lines.Line>();
        for (Circle circle : selectedCircles) {
            Img circledImg = TextOrientationLinesDetector.getCircledImg(superFrame, (int)circle.radius, circle.center);
            double angle = TextOrientationLinesDetector.getBestAngle(circledImg, 42, 12.0, 5, 192.0, null) / 180.0 * Math.PI;
            result.add(TextOrientationLinesDetector.buildLine(circle.center, angle, circle.radius));
            Imgproc.circle((Mat)superFrame.getDisplay().getSrc(), (Point)circle.center, (int)((int)circle.radius), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
        }
        return result;
    }

    private static List<Circle> detectCircles(SuperFrameImg superFrame, int minRadius, int maxRadius) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)superFrame.getDiffFrame().getSrc(), contours, (Mat)new Mat(), (int)1, (int)2);
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (int i = 0; i < contours.size(); ++i) {
            MatOfPoint contour = (MatOfPoint)contours.get(i);
            double contourarea = Imgproc.contourArea((Mat)contour);
            if (!(contourarea > 50.0)) continue;
            float[] radius = new float[1];
            Point center = new Point();
            MatOfPoint2f contour2F = new MatOfPoint2f(contour.toArray());
            Imgproc.minEnclosingCircle((MatOfPoint2f)contour2F, (Point)center, (float[])radius);
            if (!(radius[0] > (float)minRadius) || !(radius[0] < (float)maxRadius) || !(center.x > (double)radius[0]) || !(center.y > (double)radius[0]) || !(center.x + (double)radius[0] < superFrame.width()) || !(center.y + (double)radius[0] < superFrame.height())) continue;
            circles.add(new Circle(center, radius[0]));
        }
        return circles;
    }

    private static Collection<Circle> selectRandomCirles(List<Circle> circles, int circlesNumber) {
        if (circles.size() <= circlesNumber) {
            return circles;
        }
        HashSet<Circle> result = new HashSet<Circle>();
        while (result.size() < circlesNumber) {
            result.add(circles.get((int)(Math.random() * (double)circles.size())));
        }
        return result;
    }

    private static Img getCircledImg(SuperFrameImg superFrame, int radius, Point center) {
        Mat mask = new Mat(new Size((double)(radius * 2), (double)(radius * 2)), CvType.CV_8UC1, new Scalar(0.0));
        Imgproc.circle((Mat)mask, (Point)new Point((double)radius, (double)radius), (int)radius, (Scalar)new Scalar(255.0), (int)-1);
        Rect rect = new Rect(new Point(center.x - (double)radius, center.y - (double)radius), new Point(center.x + (double)radius, center.y + (double)radius));
        Mat roi = new Mat(superFrame.getBinarized().getSrc(), rect);
        Mat circled = new Mat();
        roi.copyTo(circled, mask);
        Img circledImg = new Img(circled, false);
        return circledImg;
    }

    private static Lines.Line buildLine(Point center, double angle, double size) {
        double x1 = center.x - Math.sin(angle) * size;
        double y1 = center.y + Math.cos(angle) * size;
        double x2 = center.x + Math.sin(angle) * size;
        double y2 = center.y - Math.cos(angle) * size;
        return new Lines.Line(new Point(x1, y1), new Point(x2, y2));
    }

    private static double score(Img circled, double angle, int filterSize, double threshold) {
        Mat M = Imgproc.getRotationMatrix2D((Point)new Point((double)(circled.width() / 2), (double)(circled.width() / 2)), (double)angle, (double)1.0);
        Mat rotated = new Mat();
        Imgproc.warpAffine((Mat)circled.getSrc(), (Mat)rotated, (Mat)M, (Size)new Size((double)circled.width(), (double)circled.width()));
        Img binarized = new Img(rotated, false).directionalFilter(filterSize).thresHold(threshold, 255.0, 0);
        Mat result = new Mat();
        Core.reduce((Mat)binarized.getSrc(), (Mat)result, (int)1, (int)0, (int)6);
        Core.reduce((Mat)result, (Mat)result, (int)0, (int)0, (int)6);
        return result.get(0, 0)[0];
    }

    private static double getBestAngle(Img circledImg, int absMinMax, double step, int filterSize, double threshold, Img[] binarized) {
        double maxScore = 0.0;
        double bestAngle = -1.0;
        if (binarized != null) {
            binarized[0] = new Img(new Mat(new Size((double)(2 * absMinMax * 10), 200.0), CvType.CV_8UC1, new Scalar(0.0)), false);
        }
        ArrayList<double[]> results = new ArrayList<double[]>();
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += step) {
            double score = TextOrientationLinesDetector.score(circledImg, angle, filterSize, threshold);
            if (angle != 0.0 && score > maxScore) {
                maxScore = score;
                bestAngle = angle;
            }
            if (angle != 0.0) {
                results.add(new double[]{angle, score});
            }
            if (binarized == null) continue;
            new Lines.Line(((double)absMinMax + angle) * 10.0, 0.0, ((double)absMinMax + angle) * 10.0, score / 1000.0).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0), 1);
        }
        BiFunction<Double, double[], Double> f = (x, params) -> params[0] * x * x * x * x + params[1] * x * x * x + params[2] * x * x + params[3] * x + params[4];
        BiFunction<double[], double[], Double> e = (xy, params) -> (Double)f.apply(xy[0], (double[])params) - xy[1];
        double[] result = new LevenbergImpl<double[]>(e, results, new double[]{1.0, 1.0, 1.0, 1.0, 1.0}).getParams();
        Point point = null;
        double polynomAngle = 0.0;
        double max = 0.0;
        for (double angle = (double)(-absMinMax); angle <= (double)absMinMax; angle += 1.0) {
            Point oldPoint = point;
            double score = f.apply(angle, result);
            point = new Point(((double)absMinMax + angle) * 10.0, score / 1000.0);
            if (score > max) {
                max = score;
                polynomAngle = angle;
            }
            if (binarized == null || oldPoint == null) continue;
            new Lines.Line(oldPoint, point).draw(binarized[0].getSrc(), new Scalar(255.0, 0.0, 0.0), 1);
        }
        if (binarized != null) {
            Imgproc.circle((Mat)binarized[0].getSrc(), (Point)new Point(((double)absMinMax + polynomAngle) * 10.0, max / 1000.0), (int)10, (Scalar)new Scalar(255.0, 255.0, 0.0), (int)3);
        }
        return polynomAngle;
    }

    static class Circle {
        Point center;
        float radius;

        public Circle(Point center, float radius) {
            this.center = center;
            this.radius = radius;
        }
    }
}

