/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.cv.Calibrated;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.SuperTemplate;
import org.genericsystem.cv.application.TextOrientationLinesDetector;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.imgproc.Moments;

public class SuperFrameImg {
    private final Img frame;
    private final double[] pp;
    private final double f;
    private Img display;
    private Img bilateralFilter;
    private Img binarized;
    private Img gradient;
    private Img diffFrame;
    private Img binaryClosed10;
    private Img binaryClosed20;
    private Img binaryClosed30;
    private Img binaryClosed40;

    public SuperFrameImg(Mat frameMat, double[] pp, double f) {
        this.frame = new Img(frameMat, false);
        this.pp = pp;
        this.f = f;
    }

    public Img getFrame() {
        return this.frame;
    }

    public Img getBilateralFilter() {
        return this.bilateralFilter != null ? this.bilateralFilter : (this.bilateralFilter = this.buildBilateralFilter());
    }

    public Img getBinarized() {
        return this.binarized != null ? this.binarized : (this.binarized = this.buildBinarized());
    }

    public Img getGradient() {
        return this.gradient != null ? this.gradient : (this.gradient = this.buildGradient());
    }

    public Img getDisplay() {
        return this.display != null ? this.display : (this.display = this.buildDisplay());
    }

    public Img getDiffFrame() {
        return this.diffFrame != null ? this.diffFrame : (this.diffFrame = this.buildDiffFrame());
    }

    public Img getBinaryClosed10() {
        return this.binaryClosed10 != null ? this.binaryClosed10 : (this.binaryClosed10 = this.buildBinaryClosed10());
    }

    public Img getBinaryClosed20() {
        return this.binaryClosed20 != null ? this.binaryClosed20 : (this.binaryClosed20 = this.buildBinaryClosed20());
    }

    public Img getBinaryClosed30() {
        return this.binaryClosed30 != null ? this.binaryClosed30 : (this.binaryClosed30 = this.buildBinaryClosed30());
    }

    public Img getBinaryClosed40() {
        return this.binaryClosed40 != null ? this.binaryClosed40 : (this.binaryClosed40 = this.buildBinaryClosed40());
    }

    private Img buildBilateralFilter() {
        return this.getFrame().bilateralFilter();
    }

    private Img buildBinarized() {
        return this.getBilateralFilter().adaptativeGaussianInvThreshold(11, 3.0);
    }

    private Img buildGradient() {
        return this.getFrame().bgr2Gray().morphologyEx(4, 2, new Size(2.0, 2.0)).thresHold(15.0, 255.0, 0);
    }

    protected Img buildDisplay() {
        return new Img(this.getFrame().getSrc(), true);
    }

    private Img buildBinaryClosed10() {
        return this.getBinarized().morphologyEx(3, 2, new Size(10.0, 10.0)).morphologyEx(3, 0, new Size(10.0, 10.0));
    }

    private Img buildBinaryClosed20() {
        return this.getBinarized().morphologyEx(3, 2, new Size(20.0, 20.0)).morphologyEx(3, 0, new Size(20.0, 20.0));
    }

    private Img buildBinaryClosed30() {
        return this.getBinarized().morphologyEx(3, 2, new Size(30.0, 30.0)).morphologyEx(3, 0, new Size(30.0, 30.0));
    }

    private Img buildBinaryClosed40() {
        return this.getBinarized().morphologyEx(3, 2, new Size(40.0, 40.0)).morphologyEx(3, 0, new Size(40.0, 40.0));
    }

    public Lines detectLines() {
        Img grad = this.getGradient().morphologyEx(3, 0, new Size(8.0, 8.0)).morphologyEx(3, 2, new Size(8.0, 8.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
        Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 10.0, 3.0));
        Img grad2 = this.getGradient().morphologyEx(3, 0, new Size(30.0, 30.0)).morphologyEx(3, 2, new Size(30.0, 30.0)).morphologyEx(4, 2, new Size(3.0, 3.0));
        lines.getLines().addAll(new Lines(grad2.houghLinesP(1, Math.PI / 180, 10, 30.0, 10.0)).getLines());
        return lines;
    }

    public double[] getPrincipalPoint() {
        return new double[]{this.frame.width() / 2, this.frame.height() / 2};
    }

    public Size size() {
        return this.getFrame().size();
    }

    public double width() {
        return this.getFrame().width();
    }

    public double height() {
        return this.getFrame().height();
    }

    public Img warpPerspective(Mat homography) {
        Mat deperspectived = new Mat();
        Imgproc.warpPerspective((Mat)this.getFrame().getSrc(), (Mat)deperspectived, (Mat)homography, (Size)this.size(), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
        return new Img(deperspectived, false);
    }

    public Mat findHomography(Calibrated.AngleCalibrated[] calibrateds) {
        double[][] vps = new double[][]{calibrateds[0].getCalibratexyz(), calibrateds[1].getCalibratexyz(), calibrateds[2].getCalibratexyz()};
        double[][] vps2D = this.getVp2DFromVps(vps);
        double theta = calibrateds[0].getTheta();
        double theta2 = calibrateds[1].getTheta();
        Size size = this.size();
        double x = this.size().width / 6.0;
        double[] A = new double[]{size.width / 2.0, size.height / 2.0, 1.0};
        double[] B = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0};
        double[] D = new double[]{size.width / 2.0, size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x), 1.0};
        double[] C = new double[]{size.width / 2.0 + (Math.cos(theta) < 0.0 ? -x : x), size.height / 2.0 + (Math.sin(theta2) < 0.0 ? -x : x)};
        double[] A_ = A;
        double[] B_ = new double[]{size.width / 2.0 + x * vps[0][0], size.height / 2.0 + x * vps[0][1], 1.0};
        double[] D_ = new double[]{size.width / 2.0 + x * vps[1][0], size.height / 2.0 + x * vps[1][1], 1.0};
        double[] C_ = SuperFrameImg.cross2D(SuperFrameImg.cross(B_, vps2D[1]), SuperFrameImg.cross(D_, vps2D[0]));
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(A_), new Point(B_), new Point(C_), new Point(D_)}), (Mat)new MatOfPoint2f(new Point[]{new Point(A), new Point(B), new Point(C), new Point(D)}));
    }

    public double[][] getVp2DFromVps(double[][] vps) {
        double[][] result = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            result[i][0] = vps[i][0] * this.f / vps[i][2] + this.pp[0];
            result[i][1] = vps[i][1] * this.f / vps[i][2] + this.pp[1];
            result[i][2] = 1.0;
        }
        return result;
    }

    static double[] cross2D(double[] a, double[] b) {
        return SuperFrameImg.on2D(SuperFrameImg.cross(a, b));
    }

    static double[] on2D(double[] a) {
        return new double[]{a[0] / a[2], a[1] / a[2], 1.0};
    }

    static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    public void draw(Lines lines, Scalar color, int thickness) {
        lines.draw(this.getDisplay().getSrc(), color, thickness);
    }

    public void drawVanishingPointLines(Lines lines, Calibrated.AngleCalibrated calibratedVp, Scalar color, int thickness) {
        double[] uncalibrate0 = calibratedVp.uncalibrate(this.pp, this.f);
        Lines horizontals = lines.filter(line -> Calibrated.AngleCalibrated.distance(uncalibrate0, line) < 0.4);
        this.draw(horizontals, color, thickness);
    }

    public SuperTemplate deperspective(Mat homography) {
        return new SuperTemplate(this, CvType.CV_8UC3, (Function<SuperFrameImg, Img>)((Function)st -> st.warpPerspective(homography)));
    }

    public Calibrated.AngleCalibrated findVanishingPoint(Lines lines, Calibrated.AngleCalibrated old) {
        double[] thetaPhi = new LevenbergImpl<Lines.Line>((line, params) -> new Calibrated.AngleCalibrated((double[])params).distance((Lines.Line)line, this.pp, this.f), lines.getLines(), old.getThetaPhi()).getParams();
        return new Calibrated.AngleCalibrated(thetaPhi);
    }

    public List<Lines.Line> findTextOrientationLines() {
        return TextOrientationLinesDetector.getTextOrientationLines(this);
    }

    public void drawVpsArrows(Calibrated[] calibratedVps, double[] shift, Scalar color, int thickness) {
        this.drawArrow(new Point(shift[0], shift[1]), new Point(shift[0] + calibratedVps[0].getX() * 20.0, shift[1] + calibratedVps[0].getY() * 20.0), new Scalar(0.0, 255.0, 0.0), 2);
        this.drawArrow(new Point(shift[0], shift[1]), new Point(shift[0] - calibratedVps[1].getX() * 20.0, shift[1] - calibratedVps[1].getY() * 20.0), new Scalar(255.0, 0.0, 0.0), 2);
        this.drawArrow(new Point(shift[0], shift[1]), new Point(shift[0] - calibratedVps[2].getX() * 20.0, shift[1] - calibratedVps[2].getY() * 20.0), new Scalar(0.0, 0.0, 255.0), 2);
    }

    public void drawArrow(Point pt1, Point pt2, Scalar color, int thickness) {
        Imgproc.arrowedLine((Mat)this.getDisplay().getSrc(), (Point)pt1, (Point)pt2, (Scalar)color, (int)thickness, (int)8, (int)0, (double)0.5);
    }

    public void drawDetectedRects() {
        this.drawRects(this.detectRects(), new Scalar(255.0), -1);
    }

    public void drawRects(List<Rect> gsRects, Scalar color, int thickness) {
        Mat display = this.getDisplay().getSrc();
        gsRects.forEach(rect -> Imgproc.rectangle((Mat)display, (Point)rect.tl(), (Point)rect.br(), (Scalar)color, (int)thickness));
    }

    public Img getGrayFrame() {
        return 0 != this.getFrame().type() ? this.getFrame().bgr2Gray() : this.getFrame();
    }

    private Img buildDiffFrame() {
        Mat diffFrame = this.getGrayFrame().gaussianBlur(new Size(5.0, 5.0)).getSrc();
        Core.absdiff((Mat)diffFrame, (Scalar)new Scalar(0.0), (Mat)diffFrame);
        Imgproc.adaptiveThreshold((Mat)diffFrame, (Mat)diffFrame, (double)255.0, (int)0, (int)1, (int)7, (double)3.0);
        return new Img(diffFrame, false);
    }

    public List<Rect> detectRects() {
        return this.detectRects(this.getDiffFrame(), 10, 10000, 0.3);
    }

    public List<Point> detectCentroids() {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)this.getDiffFrame().getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        ArrayList<Point> result = new ArrayList<Point>();
        for (MatOfPoint contour : contours) {
            Moments moments = Imgproc.moments((Mat)contour);
            result.add(new Point(moments.m10 / moments.m00, moments.m01 / moments.m00));
        }
        Collections.reverse(result);
        return result;
    }

    public int countWhitePixels(MatOfPoint contour, Rect rect, Img img) {
        Mat mask = Mat.zeros((Size)rect.size(), (int)CvType.CV_8UC1);
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0), (int)-1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(0.0), (int)1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        int white = 0;
        for (int row = 0; row < mask.rows(); ++row) {
            for (int col = 0; col < mask.cols(); ++col) {
                if (mask.get(row, col)[0] == 0.0 || img.get(row + (int)rect.tl().y, col + (int)rect.tl().x)[0] == 0.0) continue;
                ++white;
            }
        }
        return white;
    }

    public List<SuperContour> detectSuperContours(double minArea) {
        ArrayList contours = new ArrayList();
        Mat hierarchy = new Mat();
        Img img = this.getDiffFrame().morphologyEx(3, 0, new Size(3.0, 3.0));
        Imgproc.findContours((Mat)img.getSrc(), contours, (Mat)hierarchy, (int)3, (int)1);
        ArrayList<SuperContour> result = new ArrayList<SuperContour>();
        int row = 0;
        for (MatOfPoint contour : contours) {
            MatOfPoint fatherWrapper;
            double[] indexes = hierarchy.get(0, row);
            double fatherIndex = indexes[3];
            MatOfPoint matOfPoint = fatherWrapper = fatherIndex != -1.0 ? (MatOfPoint)contours.get((int)fatherIndex) : null;
            if (Imgproc.contourArea((Mat)contour) > 8.0 && Imgproc.boundingRect((MatOfPoint)contour).area() < 4000.0) {
                if (fatherWrapper != null) {
                    if (this.countWhitePixels(contour, Imgproc.boundingRect((MatOfPoint)contour), img) != 0) {
                        result.add(new SuperContour(contour, hierarchy.get(0, row)[3] == -1.0));
                    }
                } else {
                    result.add(new SuperContour(contour, hierarchy.get(0, row)[3] == -1.0));
                }
            }
            ++row;
        }
        return result;
    }

    public List<Span> assembleContours(List<SuperContour> superContours) {
        Collections.sort(superContours);
        ArrayList<Edge> candidateEdges = new ArrayList<Edge>();
        for (int i = 0; i < superContours.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                Edge edge = this.generateCandidateEdge(superContours.get(i), superContours.get(j));
                if (edge == null) continue;
                candidateEdges.add(edge);
            }
        }
        Collections.sort(candidateEdges);
        for (Edge edge : candidateEdges) {
            if (edge.getC1().succ != null || edge.getC2().pred != null) continue;
            edge.getC1().succ = edge.getC2();
            edge.getC2().pred = edge.getC1();
        }
        ArrayList<Span> spans = new ArrayList<Span>();
        while (!superContours.isEmpty()) {
            SuperContour contour = superContours.get(0);
            int i = 100;
            while (contour.pred != null) {
                if (i < 10) {
                    System.out.println("pred" + contour.rect + " " + contour.left + " " + contour.right);
                }
                if (i-- < 0) {
                    throw new IllegalStateException();
                }
                contour = contour.pred;
            }
            Span curSpan = new Span();
            double width = 0.0;
            i = 100;
            while (contour != null) {
                if (i < 10) {
                    System.out.println("succ " + contour.rect + " " + contour.left + " " + contour.right);
                }
                if (i-- < 0) {
                    throw new IllegalStateException();
                }
                superContours.remove(contour);
                curSpan.add(contour);
                width += contour.lxmax - contour.lxmin;
                contour = contour.succ;
            }
            double SPAN_MIN_WIDTH = 30.0;
            if (!(width > SPAN_MIN_WIDTH)) continue;
            spans.add(curSpan);
        }
        return spans;
    }

    private Edge generateCandidateEdge(SuperContour c1, SuperContour c2) {
        if (c1.right.x > c2.left.x) {
            SuperContour tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        if (c1.right.x > c2.left.x) {
            return null;
        }
        double dist = Math.sqrt(Math.pow(c1.right.x - c2.left.x, 2.0) + Math.pow(c1.right.y - c2.left.y, 2.0));
        double[] overall_tangent = new double[]{c2.center.x - c1.center.x, c2.center.y - c1.center.y};
        double overall_angle = Math.atan2(overall_tangent[1], overall_tangent[0]);
        double angle1 = this.angle_dist(c1.angle, overall_angle);
        double angle2 = this.angle_dist(c2.angle, overall_angle);
        if (this.angle_dist(overall_angle) * 180.0 / Math.PI > 3.0) {
            return null;
        }
        double delta_angle = angle1 * (c1.lxmax - c1.lxmin) + angle2 * (c2.lxmax - c2.lxmin);
        double score = dist + 2.0 * delta_angle;
        System.out.println(score + " " + dist + " " + 2.0 * delta_angle);
        return new Edge(score, c1, c2);
    }

    private double angle_dist(double angle_b, double angle_a) {
        return this.angle_dist(angle_b - angle_a);
    }

    private double angle_dist(double diff) {
        while (diff > Math.PI) {
            diff -= Math.PI * 2;
        }
        while (diff < -Math.PI) {
            diff += Math.PI * 2;
        }
        return Math.abs(diff);
    }

    List<Rect> detectRects(Img binarized, int minArea, int maxArea, double fillRatio) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)binarized.getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        Size size = binarized.size();
        ArrayList<Rect> result = new ArrayList<Rect>();
        for (MatOfPoint contour : contours) {
            double area = Imgproc.contourArea((Mat)contour);
            if (!(area > (double)minArea) || !(area < (double)maxArea)) continue;
            Rect rect = Imgproc.boundingRect((MatOfPoint)contour);
            if (rect.tl().x == 0.0 || rect.tl().y == 0.0 || rect.br().x == size.width || rect.br().y == size.height || !(this.getFillRatio(contour, rect) > fillRatio)) continue;
            result.add(rect);
        }
        Collections.reverse(result);
        return result;
    }

    public double getFillRatio(MatOfPoint contour, Rect rect) {
        Mat mask = Mat.zeros((Size)rect.size(), (int)CvType.CV_8UC1);
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0), (int)-1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        Mat mat = new Mat();
        Core.findNonZero((Mat)mask, (Mat)mat);
        return (double)mat.rows() / rect.area();
    }

    public List<GSRect> cleanList(List<GSRect> bigRects, List<GSRect> smallRects, double overlapThreshold) {
        smallRects.removeIf(smallRect -> bigRects.stream().anyMatch(bigRect -> smallRect.inclusiveArea(bigRect) > overlapThreshold));
        return Stream.concat(smallRects.stream().filter(smallRect -> bigRects.stream().filter(rect -> rect.isOverlapping(smallRect)).noneMatch(rect -> rect.getInsider(smallRect) == null)), bigRects.stream()).collect(Collectors.toList());
    }

    public boolean isOverlapping(Rect rect, Rect other) {
        return (double)rect.x <= other.br().x && other.tl().x <= rect.br().x && (double)rect.y <= other.br().y && other.tl().y <= rect.br().y;
    }

    public Calibrated.AngleCalibrated[] findOtherVps(Calibrated.AngleCalibrated calibrated0, Lines lines) {
        Calibrated.AngleCalibrated[] result = new Calibrated.AngleCalibrated[]{null, null, null};
        double bestError = Double.MAX_VALUE;
        for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / 180) {
            double error;
            Calibrated.AngleCalibrated calibratexy = calibrated0.getOrthoFromAngle(angle);
            Calibrated.AngleCalibrated calibratez = calibrated0.getOrthoFromVps(calibratexy);
            if (calibratexy.getPhi() < calibratez.getPhi()) {
                Calibrated.AngleCalibrated tmp = calibratexy;
                calibratexy = calibratez;
                calibratez = tmp;
            }
            if (!((error = calibratexy.distance(lines.getLines(), this.pp, this.f)) < bestError)) continue;
            bestError = error;
            result[0] = calibrated0;
            result[1] = calibratexy;
            result[2] = calibratez;
        }
        double theta0 = Math.abs(result[0].getTheta()) % Math.PI;
        theta0 = Math.min(Math.PI - theta0, theta0);
        double theta1 = Math.abs(result[1].getTheta()) % Math.PI;
        if (theta0 > (theta1 = Math.min(Math.PI - theta1, theta1))) {
            Calibrated.AngleCalibrated tmp = result[0];
            result[0] = result[1];
            result[1] = tmp;
        }
        return result;
    }

    public double[] getPp() {
        return this.pp;
    }

    public double getF() {
        return this.f;
    }

    public void putText(String text) {
        Imgproc.putText((Mat)this.getDisplay().getSrc(), (String)text, (Point)new Point((double)(this.getDisplay().width() / 2), 20.0), (int)1, (double)1.0, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1);
    }

    public static class Span {
        private List<SuperContour> contours = new ArrayList<SuperContour>();

        public void add(SuperContour superContour) {
            this.contours.add(superContour);
        }

        public List<SuperContour> getContours() {
            return this.contours;
        }
    }

    public static class Edge
    implements Comparable<Edge> {
        private final double score;
        private final SuperContour c1;
        private final SuperContour c2;

        public Edge(double score, SuperContour c1, SuperContour c2) {
            this.c1 = c1;
            this.c2 = c2;
            this.score = score;
        }

        @Override
        public int compareTo(Edge edge) {
            return Double.compare(this.score, edge.getScore());
        }

        private double getScore() {
            return this.score;
        }

        public SuperContour getC1() {
            return this.c1;
        }

        public SuperContour getC2() {
            return this.c2;
        }
    }

    public static class SuperContour
    implements Comparable<SuperContour> {
        public final MatOfPoint contour;
        public SuperContour succ;
        public SuperContour pred;
        public Point center;
        public Point tangent;
        public Point antiTangent;
        public double angle;
        public Point left;
        public Point right;
        public Rect rect;
        public double lxmin;
        public double lxmax;
        public double lymin;
        public double lymax;
        public final boolean isLeaf;

        SuperContour(MatOfPoint contour, boolean isLeaf) {
            this.contour = contour;
            this.rect = Imgproc.boundingRect((MatOfPoint)contour);
            Moments moments = Imgproc.moments((Mat)contour);
            this.center = new Point(moments.m10 / moments.m00, moments.m01 / moments.m00);
            Mat momentsMatrix = new Mat(new Size(2.0, 2.0), CvType.CV_64FC1);
            momentsMatrix.put(0, 0, new double[]{moments.mu20 / moments.m00});
            momentsMatrix.put(0, 1, new double[]{moments.mu11 / moments.m00});
            momentsMatrix.put(1, 0, new double[]{moments.mu11 / moments.m00});
            momentsMatrix.put(1, 1, new double[]{moments.mu02 / moments.m00});
            Mat svdU = new Mat();
            Core.SVDecomp((Mat)momentsMatrix, (Mat)new Mat(), (Mat)svdU, (Mat)new Mat());
            double tx = svdU.get(0, 0)[0];
            double ty = svdU.get(1, 0)[0];
            if (tx < 0.0) {
                tx = -tx;
                ty = -ty;
            }
            this.tangent = new Point(tx, ty);
            this.antiTangent = new Point(ty, -tx);
            this.lxmin = Double.MAX_VALUE;
            this.lxmax = 0.0;
            this.lymin = Double.MAX_VALUE;
            this.lymax = 0.0;
            for (Point pt : contour.toArray()) {
                double anticlx;
                double clx = this.tangent.x * (pt.x - this.center.x) + this.tangent.y * (pt.y - this.center.y);
                if (clx < this.lxmin) {
                    this.lxmin = clx;
                }
                if (clx > this.lxmax) {
                    this.lxmax = clx;
                }
                if ((anticlx = this.antiTangent.x * (pt.x - this.center.x) + this.antiTangent.y * (pt.y - this.center.y)) < this.lymin) {
                    this.lymin = anticlx;
                }
                if (!(anticlx > this.lymax)) continue;
                this.lymax = anticlx;
            }
            this.left = new Point(this.center.x + this.tangent.x * this.lxmin, this.center.y + this.tangent.y * this.lxmin);
            this.right = new Point(this.center.x + this.tangent.x * this.lxmax, this.center.y + this.tangent.y * this.lxmax);
            this.angle = Math.atan2(this.tangent.y, this.tangent.x);
            this.isLeaf = isLeaf;
            if (this.lxmin >= this.lxmax) {
                throw new IllegalStateException();
            }
            if (this.lymin >= this.lymax) {
                throw new IllegalStateException();
            }
        }

        @Override
        public int compareTo(SuperContour c) {
            return Double.compare(this.rect.tl().y, c.rect.tl().y);
        }

        public double xLocalOverlap(SuperContour c2) {
            double xmin = (c2.left.x - this.center.x) * this.tangent.x + (c2.left.y - this.center.y) * this.tangent.y;
            double xmax = (c2.right.x - this.center.x) * this.tangent.x + (c2.right.y - this.center.y) * this.tangent.y;
            return Math.min(this.lxmax, xmax) - Math.max(this.lxmin, xmin);
        }

        public double yLocalOverlap(SuperContour c2) {
            double ymin = (c2.left.x - this.center.x) * this.antiTangent.x + (c2.left.y - this.center.y) * this.antiTangent.y;
            double ymax = (c2.right.x - this.center.x) * this.antiTangent.x + (c2.right.y - this.center.y) * this.antiTangent.y;
            return Math.min(this.lymax, ymax) - Math.max(this.lymin, ymin);
        }
    }
}

