/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Matrix;
import org.genericsystem.cv.utils.Line;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Ransac;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class LinesDetector5
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public static void main(String[] args) {
        LinesDetector5.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskewedView, 0, 1);
        Mat dePerspectived = frame.clone();
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(frame);
                Img grad = new Img(frame, false).morphologyEx(4, 0, new Size(2.0, 2.0)).otsu();
                Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 100.0, 10.0));
                System.out.println("Average angle: " + lines.getMean() / Math.PI * 180.0);
                if (lines.size() > 10) {
                    lines.draw(frame, new Scalar(0.0, 0.0, 255.0));
                    frameView.setImage(Tools.mat2jfxImage(frame));
                    Ransac<Line> ransac = lines.vanishingPointRansac(frame.width(), frame.height());
                    Matrix vp_matrix = (Matrix)ransac.getBestModel().getParams()[0];
                    Mat vp_mat = vp_matrix.convert();
                    Point vp = new Point(vp_mat.get(0, 0)[0], vp_mat.get(1, 0)[0]);
                    Point bary = new Point((double)(frame.width() / 2), (double)(frame.height() / 2));
                    Mat homography = this.findHomography(new Point(vp.x, vp.y), bary, frame.width(), frame.height());
                    lines = Lines.of(ransac.getBestDataSet().values());
                    lines = Lines.of(lines.perspectivTransform(homography));
                    Mat mask = new Mat(frame.size(), CvType.CV_8UC1, new Scalar(255.0));
                    Mat maskWarpped = new Mat();
                    Imgproc.warpPerspective((Mat)mask, (Mat)maskWarpped, (Mat)homography, (Size)frame.size());
                    Mat tmp = new Mat();
                    Imgproc.warpPerspective((Mat)frame, (Mat)tmp, (Mat)homography, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    tmp.copyTo(dePerspectived, maskWarpped);
                    lines.draw(dePerspectived, new Scalar(0.0, 255.0, 0.0));
                    deskewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 33L, 250L, TimeUnit.MILLISECONDS);
    }

    public void print(Mat m) {
        for (int row = 0; row < m.rows(); ++row) {
            System.out.print("(");
            for (int col = 0; col < m.cols() - 1; ++col) {
                System.out.print(m.get(row, col)[0] + ",");
            }
            System.out.println(m.get(row, m.cols() - 1)[0] + ")");
        }
        System.out.println("---------------");
    }

    public Point[] rotate(Point bary, double alpha, Point ... p) {
        Mat matrix = Imgproc.getRotationMatrix2D((Point)bary, (double)(alpha / Math.PI * 180.0), (double)1.0);
        MatOfPoint2f results = new MatOfPoint2f();
        Core.transform((Mat)new MatOfPoint2f(p), (Mat)results, (Mat)matrix);
        return results.toArray();
    }

    public Point center(Point a, Point b) {
        return new Point((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    private Mat findHomography(Point vp, Point bary, double width, double height) {
        Point B_;
        Point C_;
        Point D_;
        Point A_;
        double alpha_ = Math.atan2(vp.y - bary.y, vp.x - bary.x);
        if (alpha_ < -1.5707963267948966 && alpha_ > -Math.PI) {
            alpha_ += Math.PI;
        }
        if (alpha_ < Math.PI && alpha_ > 1.5707963267948966) {
            alpha_ -= Math.PI;
        }
        double alpha = alpha_;
        Point rotatedVp = this.rotate(bary, alpha, vp)[0];
        Point A = new Point(0.0, 0.0);
        Point B = new Point(width, 0.0);
        Point C = new Point(width, height);
        Point D = new Point(0.0, height);
        Point AB2 = new Point(width / 2.0, 0.0);
        Point CD2 = new Point(width / 2.0, height);
        if (rotatedVp.x >= width / 2.0) {
            A_ = new Line(AB2, rotatedVp).intersection(0.0);
            D_ = new Line(CD2, rotatedVp).intersection(0.0);
            C_ = new Line(A_, bary).intersection(new Line(CD2, rotatedVp));
            B_ = new Line(D_, bary).intersection(new Line(AB2, rotatedVp));
        } else {
            B_ = new Line(AB2, rotatedVp).intersection(width);
            C_ = new Line(CD2, rotatedVp).intersection(width);
            A_ = new Line(C_, bary).intersection(new Line(AB2, rotatedVp));
            D_ = new Line(B_, bary).intersection(new Line(CD2, rotatedVp));
        }
        System.out.println("vp : " + vp);
        System.out.println("rotated vp : " + rotatedVp);
        System.out.println("Alpha : " + alpha * 180.0 / Math.PI);
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(this.rotate(bary, -alpha, A_, B_, C_, D_)), (Mat)new MatOfPoint2f(new Point[]{A, B, C, D}));
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Lines
    extends org.genericsystem.cv.utils.Lines {
        private static Matrix K;

        public Lines(Mat src) {
            super(src);
        }

        public Lines(Collection<Line> lines) {
            super(lines);
        }

        public static Lines of(Collection<Line> lines) {
            return new Lines(lines);
        }

        private Matrix getLineMat(Line line) {
            Matrix a = new Matrix(3, 1);
            Matrix b = new Matrix(3, 1);
            a.set(0, 0, line.getX1());
            a.set(1, 0, line.getY1());
            a.set(2, 0, 1.0);
            b.set(0, 0, line.getX2());
            b.set(1, 0, line.getY2());
            b.set(2, 0, 1.0);
            Matrix an = K.inv().times(a, 1.0);
            Matrix bn = K.inv().times(b, 1.0);
            Matrix li = Matrix.crossProduct(an, bn);
            return li.normalize();
        }

        public Ransac<Line> vanishingPointRansac(int width, int height) {
            int minimal_sample_set_dimension = 2;
            double maxError = 0.03246f;
            if (K == null) {
                K = new Matrix(3, 3);
                K.set(0, 0, width);
                K.set(0, 2, width / 2);
                K.set(1, 1, height);
                K.set(1, 2, height / 2);
                K.set(2, 2, 1.0);
            }
            return new Ransac<Line>(this.getLines(), this.getModelProvider(minimal_sample_set_dimension, maxError), minimal_sample_set_dimension, 100, maxError, Double.valueOf(Math.floor((double)this.size() * 0.7)).intValue());
        }

        private Function<Collection<Line>, Ransac.Model<Line>> getModelProvider(int minimal_sample_set_dimension, final double maxError) {
            return datas -> {
                final Matrix[] vp = new Matrix[]{new Matrix()};
                if (datas.size() == minimal_sample_set_dimension) {
                    Iterator it = datas.iterator();
                    vp[0] = Matrix.crossProduct(this.getLineMat((Line)it.next()), this.getLineMat((Line)it.next())).normalize();
                } else {
                    Matrix li_set = new Matrix(3, datas.size());
                    Matrix tau = new Matrix(datas.size(), datas.size());
                    int i = 0;
                    for (Line line : datas) {
                        Matrix li = this.getLineMat(line);
                        li_set.set(0, i, li.get(0, 0));
                        li_set.set(1, i, li.get(1, 0));
                        li_set.set(2, i, li.get(2, 0));
                        tau.set(i, i, line.size());
                        ++i;
                    }
                    Matrix dst = li_set.times(tau.t(), 1.0);
                    dst = dst.times(tau, 1.0);
                    Matrix ATA = dst.times(li_set.t(), 1.0);
                    Mat v = new Mat();
                    Mat ata = ATA.convert();
                    Core.SVDecomp((Mat)ata, (Mat)new Mat(), (Mat)v, (Mat)new Mat());
                    Matrix result = Matrix.convert(v);
                    if (v.rows() < 3) {
                        throw new IllegalStateException();
                    }
                    vp[0] = new Matrix(3, 1);
                    vp[0].set(0, 0, result.get(0, 2));
                    vp[0].set(1, 0, result.get(1, 2));
                    vp[0].set(2, 0, result.get(2, 2));
                    vp[0].normalize();
                    vp[0] = K.times(vp[0], 1.0);
                    if (vp[0].get(2, 0) != 0.0) {
                        vp[0].set(0, 0, vp[0].get(0, 0) / vp[0].get(2, 0));
                        vp[0].set(1, 0, vp[0].get(1, 0) / vp[0].get(2, 0));
                        vp[0].set(2, 0, 1.0);
                    } else {
                        vp[0] = K.times(vp[0], 1.0);
                    }
                }
                return new Ransac.Model<Line>(){

                    @Override
                    public double computeError(Line line) {
                        Matrix lineMat = this.getLineMat(line);
                        double di = vp[0].dot(lineMat);
                        return (di /= vp[0].norm() * lineMat.norm()) * di;
                    }

                    @Override
                    public double computeGlobalError(List<Line> datas, Collection<Line> consensusDatas) {
                        double globalError = 0.0;
                        for (Line line : datas) {
                            double error = this.computeError(line);
                            if (error > maxError) {
                                error = maxError;
                            }
                            globalError += error;
                        }
                        return globalError /= (double)datas.size();
                    }

                    @Override
                    public Object[] getParams() {
                        return new Object[]{vp[0]};
                    }
                };
            };
        }
    }
}

