/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableValue;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.CacheNoStartedException;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.api.tools.Memoizer;
import org.genericsystem.common.CheckedContext;
import org.genericsystem.common.Differential;
import org.genericsystem.common.Generic;
import org.genericsystem.common.GenericBuilder;
import org.genericsystem.common.IDifferential;
import org.genericsystem.common.Restructurator;
import org.genericsystem.common.Root;
import org.genericsystem.defaults.DefaultCache;
import org.genericsystem.defaults.tools.RxJavaHelpers;

public abstract class AbstractCache
extends CheckedContext
implements DefaultCache<Generic> {
    private final Restructurator restructurator;
    protected final ObjectProperty<IDifferential<Generic>> transactionProperty;
    protected final ObjectProperty<Differential> differentialProperty = new SimpleObjectProperty();
    protected final io.reactivex.Observable<Differential> differentialObservable = RxJavaHelpers.valuesOf(this.differentialProperty).replay().refCount();
    private ObservableIntegerValue cacheLevel;
    private ObservableLongValue ts;
    private final ContextEventListener<Generic> listener;

    public Generic setMeta(int dim) {
        return this.setInstance(null, Collections.emptyList(), this.getRoot().getValue(), Arrays.asList(this.rootComponents(dim)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U safeSupply(Supplier<U> safeExecution) {
        AbstractCache localCache = this.getRoot().getLocalCache();
        this.start();
        try {
            U u = safeExecution.get();
            return u;
        }
        finally {
            if (localCache != null) {
                localCache.start();
            } else {
                this.stop();
            }
        }
    }

    public void safeExecute(Runnable safeExecution) {
        AbstractCache localCache = this.getRoot().getLocalCache();
        this.start();
        try {
            safeExecution.run();
        }
        finally {
            if (null != localCache) {
                localCache.start();
            } else {
                this.stop();
            }
        }
    }

    public final <U extends AbstractCache> U start() {
        return (U)this.getRoot().start(this);
    }

    public final void stop() {
        this.getRoot().stop(this);
    }

    public long shiftTs() throws RollbackException {
        this.transactionProperty.set(this.buildTransaction());
        this.listener.triggersRefreshEvent();
        return this.getTs();
    }

    public boolean contains(Generic generic) {
        return ((Differential)this.differentialProperty.getValue()).getAdds().contains(generic);
    }

    public BooleanBinding isInCache(Generic generic) {
        return Bindings.createBooleanBinding(() -> ((Differential)this.differentialProperty.getValue()).getAdds().contains(generic), (Observable[])new Observable[]{this.differentialProperty});
    }

    protected abstract IDifferential<Generic> buildTransaction();

    public AbstractCache(Root root) {
        this(root, new ContextEventListener<Generic>(){});
    }

    public AbstractCache(Root root, ContextEventListener<Generic> listener) {
        super(root);
        this.restructurator = this.buildRestructurator();
        this.listener = listener;
        this.transactionProperty = new SimpleObjectProperty(this.buildTransaction());
        this.cacheLevel = Bindings.createIntegerBinding(() -> ((Differential)this.differentialProperty.get()).getCacheLevel(), (Observable[])new Observable[]{this.differentialProperty});
        this.ts = Bindings.createLongBinding(() -> ((IDifferential)this.transactionProperty.get()).getTs(), (Observable[])new Observable[]{this.transactionProperty});
        this.initialize();
    }

    protected Differential getDifferential() {
        return (Differential)this.differentialProperty.get();
    }

    Restructurator getRestructurator() {
        return this.restructurator;
    }

    public ObservableValue<IDifferential<Generic>> getTransactionProperty() {
        return this.transactionProperty;
    }

    public IDifferential<Generic> getTransaction() {
        return (IDifferential)this.transactionProperty.get();
    }

    public long getTs() {
        return this.getTransaction().getTs();
    }

    public ObservableLongValue getTsObservableValue() {
        return this.ts;
    }

    @Override
    public Snapshot<Generic> getDependencies(Generic generic) {
        return this.getDifferential().getDependencies(generic);
    }

    public void enableReactive() {
        this.getRoot().addReactiveCache(this);
    }

    public void disableReactive() {
        this.getRoot().removeReactiveCache(this);
    }

    protected Restructurator buildRestructurator() {
        return new Restructurator(this);
    }

    protected void initialize() {
        this.differentialProperty.set((Object)this.buildDifferential(this.getDifferential() == null ? this.buildTransactionDifferential() : this.getDifferential().getSubDifferential()));
    }

    protected Differential buildDifferential(IDifferential<Generic> subCache) {
        return new Differential(subCache);
    }

    protected TransactionDifferential buildTransactionDifferential() {
        return new TransactionDifferential();
    }

    public void tryFlush() throws ConcurrencyControlException {
        if (!this.equals(this.getRoot().getCurrentCache())) {
            this.discardWithException((Throwable)new CacheNoStartedException("The Cache isn't started"));
        }
        try {
            this.checkConstraints();
            this.doSynchronizedApplyInSubContext();
            this.initialize();
            if (this.getDifferential().getSubDifferential() instanceof TransactionDifferential) {
                this.getRoot().getReactiveCaches().stream().filter(cache -> cache != this).forEach(cache -> cache.safeExecute(() -> cache.shiftTs()));
            }
            this.listener.triggersFlushEvent();
        }
        catch (OptimisticLockConstraintViolationException exception) {
            this.discardWithException(exception);
        }
    }

    public void flush() {
        ConcurrencyControlException cause = null;
        for (int attempt = 0; attempt < 50; ++attempt) {
            try {
                this.tryFlush();
                return;
            }
            catch (ConcurrencyControlException e) {
                cause = e;
                try {
                    Thread.sleep(15L);
                    this.shiftTs();
                }
                catch (InterruptedException ex) {
                    this.discardWithException(ex);
                }
                continue;
            }
        }
        this.discardWithException(cause);
    }

    protected void doSynchronizedApplyInSubContext() throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        Differential originalCacheElement = this.getDifferential();
        this.synchronizedApply(originalCacheElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedApply(Differential cacheElement) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        Root root = this.getRoot();
        synchronized (root) {
            cacheElement.apply();
        }
    }

    public void clear() {
        this.getDifferential().unApply();
        this.initialize();
        this.listener.triggersClearEvent();
        this.listener.triggersRefreshEvent();
    }

    public void mount() {
        this.differentialProperty.set((Object)this.buildDifferential(this.getDifferential()));
    }

    public void unmount() {
        IDifferential<Generic> subCache = this.getDifferential().getSubDifferential();
        this.differentialProperty.set((Object)(subCache instanceof Differential ? (Differential)subCache : new Differential(subCache)));
        this.listener.triggersClearEvent();
        this.listener.triggersRefreshEvent();
    }

    @Override
    protected void triggersMutation(Generic oldDependency, Generic newDependency) {
        if (this.listener != null) {
            this.listener.triggersMutationEvent(oldDependency, newDependency);
        }
    }

    public Generic buildAndPlug(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components) {
        return this.plug(this.getRoot().build(null, clazz, meta, supers, value, components));
    }

    protected Generic plug(Generic generic) {
        assert (generic.getBirthTs() == Long.MAX_VALUE || generic.getBirthTs() == 0L) : generic.info() + generic.getBirthTs();
        this.getDifferential().plug(generic);
        this.getChecker().checkAfterBuild(true, false, generic);
        return generic;
    }

    protected void unplug(Generic generic) {
        this.getChecker().checkAfterBuild(false, false, generic);
        this.getDifferential().unplug(generic);
    }

    protected void checkConstraints() throws RollbackException {
        this.getDifferential().checkConstraints(this.getChecker());
    }

    public void discardWithException(Throwable exception) throws RollbackException {
        this.clear();
        throw new RollbackException(exception);
    }

    public int getCacheLevel() {
        return this.getDifferential().getCacheLevel();
    }

    public ObservableIntegerValue getCacheLevelObservableValue() {
        return this.cacheLevel;
    }

    public Generic setInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return new GenericBuilder.SetBuilder(this, meta, overrides, value, components).resolve();
    }

    public Generic addInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return new GenericBuilder.AddBuilder(this, meta, overrides, value, components).resolve();
    }

    public Generic update(Generic update, List<Generic> overrides, Serializable newValue, List<Generic> newComponents) {
        return new GenericBuilder.UpdateBuilder(this, update, update.getMeta(), overrides, newValue, newComponents).resolve();
    }

    public Generic merge(Generic update, List<Generic> overrides, Serializable newValue, List<Generic> newComponents) {
        return new GenericBuilder.MergeBuilder(this, update, update.getMeta(), overrides, newValue, newComponents).resolve();
    }

    public void forceRemove(Generic generic) {
        this.getRestructurator().rebuildAll(null, null, this.computeDependencies(generic));
    }

    public void remove(Generic generic) {
        this.getRestructurator().rebuildAll(null, null, this.computeRemoveDependencies(generic));
    }

    public void conserveRemove(Generic generic) {
        this.getRestructurator().rebuildAll(generic, () -> generic, this.computeDependencies(generic));
    }

    public static interface ContextEventListener<X> {
        default public void triggersMutationEvent(X oldDependency, X newDependency) {
        }

        default public void triggersRefreshEvent() {
        }

        default public void triggersClearEvent() {
        }

        default public void triggersFlushEvent() {
        }
    }

    protected class TransactionDifferential
    implements IDifferential<Generic> {
        private Function<Generic, io.reactivex.Observable<Generic>> addsM = Memoizer.memoize(generic -> RxJavaHelpers.prevFromObservableValue(AbstractCache.this.transactionProperty).switchMap(prevTransaction -> prevTransaction.getAdds((Generic)generic)));
        private Function<Generic, io.reactivex.Observable<Generic>> remsM = Memoizer.memoize(generic -> RxJavaHelpers.prevFromObservableValue(AbstractCache.this.transactionProperty).switchMap(prevTransaction -> prevTransaction.getRemovals((Generic)generic)));

        protected TransactionDifferential() {
        }

        @Override
        public void apply(Snapshot<Generic> removes, Snapshot<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            AbstractCache.this.getTransaction().apply(removes, adds);
        }

        @Override
        public AbstractCache getCache() {
            return AbstractCache.this;
        }

        @Override
        public io.reactivex.Observable<IDifferential<Generic>> getDifferentialObservable() {
            return AbstractCache.this.differentialObservable;
        }

        @Override
        public Snapshot<Generic> getDependencies(Generic generic) {
            return AbstractCache.this.getTransaction().getDependencies(generic);
        }

        @Override
        public long getTs() {
            return AbstractCache.this.getTransaction().getTs();
        }

        @Override
        public io.reactivex.Observable<Generic> getAdds(Generic generic) {
            return this.addsM.apply(generic);
        }

        @Override
        public io.reactivex.Observable<Generic> getRemovals(Generic generic) {
            return this.remsM.apply(generic);
        }
    }
}

