/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.vertx.core.impl.ConcurrentHashSet;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.api.core.annotations.DirectClass;
import org.genericsystem.api.core.annotations.InstanceClass;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Generic;
import org.genericsystem.common.GenericProxy;
import org.genericsystem.common.SystemCache;
import org.genericsystem.common.Vertex;
import org.genericsystem.defaults.DefaultConfig;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.DefaultRoot;

public abstract class Root
implements DefaultRoot<Generic>,
ProxyObject,
Generic {
    private final Map<Long, Generic> genericsById = new ConcurrentHashMap<Long, Generic>();
    private final SystemCache systemCache = this.buildSystemCache(this);
    protected boolean isInitialized = false;
    private final ThreadLocal<AbstractCache> cacheLocal = new ThreadLocal();
    private final Set<AbstractCache> reactiveCaches = new ConcurrentHashSet();
    private MethodHandler handler;
    private static final ProxyFactory PROXY_FACTORY = new ProxyFactory();
    private static final MethodFilter METHOD_FILTER = method -> method.getName().equals("toString");

    protected abstract SystemCache buildSystemCache(Root var1);

    @Override
    public Root getRoot() {
        return this;
    }

    public Set<AbstractCache> getReactiveCaches() {
        return this.reactiveCaches;
    }

    public void addReactiveCache(AbstractCache cache) {
        this.reactiveCaches.add(cache);
    }

    public void removeReactiveCache(AbstractCache cache) {
        this.reactiveCaches.remove(cache);
    }

    protected void startSystemCache(Class<?> ... userClasses) {
        this.checkNames(userClasses);
        this.newCache().start();
        this.systemCache.mount(Arrays.asList(DefaultConfig.MetaAttribute.class, DefaultConfig.MetaRelation.class, DefaultConfig.SystemMap.class, DefaultConfig.Sequence.class), userClasses);
        this.getCurrentCache().flush();
    }

    private void checkNames(Class<?>[] userClasses) {
        HashSet set = new HashSet();
        List names = Arrays.stream(userClasses).map(Class::getName).filter(className -> !set.add(className)).collect(Collectors.toList());
        if (!names.isEmpty()) {
            throw new IllegalStateException("Class name clash detected  : " + names);
        }
    }

    public void setHandler(MethodHandler handler) {
        this.handler = handler;
    }

    public MethodHandler getHandler() {
        return this.handler;
    }

    public abstract AbstractCache newCache();

    public <Custom extends Generic> Custom find(Class<?> clazz) {
        return (Custom)this.systemCache.find(clazz);
    }

    public <Custom extends Generic> Custom bind(Class<?> clazz) {
        return (Custom)this.systemCache.bind(clazz);
    }

    public Class<?> findAnnotedClass(Generic generic) {
        return this.systemCache.getClassByVertex(generic);
    }

    public Generic getGenericById(long ts) {
        return this.genericsById.get(ts);
    }

    protected void release(long ts) {
        this.genericsById.remove(ts);
    }

    protected final Generic newT(Class<?> clazz) {
        try {
            return this.newInstance(clazz);
        }
        catch (IllegalArgumentException e) {
            this.getCurrentCache().discardWithException(e);
            return null;
        }
    }

    public final Generic[] newTArray(int dim) {
        return new Generic[dim];
    }

    protected Generic build(Vertex vertex) {
        return this.build(vertex.getTs(), vertex.getClazz(), vertex.getMeta() == vertex.getTs() ? null : this.getGenericById(vertex.getMeta()), vertex.getSupers().stream().map(this::getGenericById).collect(Collectors.toList()), vertex.getValue(), vertex.getComponents().stream().map(this::getGenericById).collect(Collectors.toList()), vertex.getBirthTs());
    }

    protected Class<?> adaptClass(Class<?> clazz, Generic meta) {
        InstanceClass metaAnnotation;
        InstanceClass instanceClass = metaAnnotation = meta == null ? null : this.getAnnotedClass(meta).getAnnotation(InstanceClass.class);
        if (clazz == null) {
            return metaAnnotation == null ? this.getTClass() : metaAnnotation.value();
        }
        DirectClass directClass = clazz.getAnnotation(DirectClass.class);
        if (directClass != null) {
            if (metaAnnotation == null || metaAnnotation.value().isAssignableFrom(clazz)) {
                return clazz;
            }
            this.getCurrentCache().discardWithException(new IllegalStateException(clazz + " must extend " + metaAnnotation.value()));
        }
        if (metaAnnotation == null) {
            return this.getTClass().isAssignableFrom(clazz) ? clazz : this.getTClass();
        }
        if (metaAnnotation.value().isAssignableFrom(clazz)) {
            return clazz;
        }
        this.getCurrentCache().discardWithException(new IllegalStateException(clazz + " must extend " + metaAnnotation.value()));
        return null;
    }

    public abstract long pickNewTs();

    Generic build(Long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components) {
        return this.build(ts, clazz, meta, supers, value, components, this.isInitialized() ? Long.MAX_VALUE : 0L);
    }

    protected abstract Generic build(Long var1, Class<?> var2, Generic var3, List<Generic> var4, Serializable var5, List<Generic> var6, long var7);

    protected Generic init(Generic generic, DefaultHandler handler) {
        ((ProxyObject)generic).setHandler((MethodHandler)handler);
        assert (((ProxyObject)generic).getHandler() instanceof DefaultHandler);
        Generic gresult = this.genericsById.putIfAbsent(handler.getTs(), generic);
        assert (gresult == null) : gresult.info();
        return generic;
    }

    protected abstract Class<Generic> getTClass();

    private Generic newInstance(Class<?> clazz) {
        Class[] classArray;
        PROXY_FACTORY.setSuperclass(clazz.isInterface() ? Object.class : clazz);
        if (clazz.isInterface()) {
            if (this.getTClass().isAssignableFrom(clazz)) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = clazz;
            } else {
                Class[] classArray3 = new Class[2];
                classArray3[0] = clazz;
                classArray = classArray3;
                classArray3[1] = this.getTClass();
            }
        } else if (this.getTClass().isAssignableFrom(clazz)) {
            classArray = new Class[]{};
        } else {
            Class[] classArray4 = new Class[1];
            classArray = classArray4;
            classArray4[0] = this.getTClass();
        }
        PROXY_FACTORY.setInterfaces(classArray);
        try {
            return (Generic)PROXY_FACTORY.createClass(METHOD_FILTER).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public Class<?> getAnnotedClass(Generic generic) {
        Class<?> annotedClass;
        if (generic.isSystem() && (annotedClass = this.findAnnotedClass(generic)) != null) {
            return annotedClass;
        }
        if (!generic.isRoot() && generic instanceof ProxyObject) {
            return generic.getClass().getSuperclass();
        }
        return generic.getClass();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public AbstractCache getLocalCache() {
        return this.cacheLocal.get();
    }

    public AbstractCache getCurrentCache() {
        AbstractCache context = this.cacheLocal.get();
        if (context == null) {
            throw new IllegalStateException("Unable to find the current cache, thread context is not defined. Did you miss to call start() method on your cache ? or perhaps have you accidentaly closed your engine ?");
        }
        return context;
    }

    protected AbstractCache start(AbstractCache cache) {
        if (cache == null) {
            throw new NullPointerException();
        }
        this.cacheLocal.set(cache);
        return cache;
    }

    protected void stop(AbstractCache cache) {
        this.cacheLocal.remove();
    }

    public void close() {
        this.cacheLocal.remove();
    }

    public String toString() {
        return this.defaultToString();
    }

    public abstract class DefaultHandler
    implements MethodHandler,
    ISignature<Generic> {
        private final Class<?> clazz;
        private final Generic meta;
        private final List<Generic> supers;
        private final Serializable value;
        private final List<Generic> components;
        private final long ts;

        protected DefaultHandler(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long ts) {
            this.clazz = clazz;
            this.meta = meta;
            this.supers = supers;
            this.value = value;
            this.components = components;
            this.ts = ts;
        }

        public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
            return ((DefaultGeneric)self).defaultToString();
        }

        protected abstract Root getRoot();

        public Vertex getVertex() {
            return new Vertex(this.getClazz(), this.getTs(), this.getMeta() != null ? this.getMeta().getTs() : this.getTs(), this.getSupers().stream().map(GenericProxy::getTs).collect(Collectors.toList()), this.getValue(), this.getComponents().stream().map(GenericProxy::getTs).collect(Collectors.toList()), this.getBirthTs());
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Generic getMeta() {
            return this.meta;
        }

        public List<Generic> getSupers() {
            return this.supers;
        }

        public Serializable getValue() {
            return this.value;
        }

        public List<Generic> getComponents() {
            return this.components;
        }

        public long getTs() {
            return this.ts;
        }
    }
}

