/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.api.core.annotations.constraints.InstanceValueGenerator;
import org.genericsystem.api.core.exceptions.ExistsException;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Generic;

public abstract class GenericBuilder {
    protected final AbstractCache context;
    final Generic meta;
    protected Generic adjustedMeta;
    final List<Generic> overrides;
    protected List<Generic> supers;
    protected final Serializable value;
    protected final List<Generic> components;
    protected Generic gettable;

    GenericBuilder(AbstractCache context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        assert (overrides != null);
        this.context = context;
        this.meta = meta != null ? meta : context.getRoot();
        this.overrides = overrides;
        this.components = components;
        this.value = this.generateValue(value);
        this.check();
        this.adjust();
    }

    Serializable generateValue(Serializable value) {
        Class instanceValueGenerator = this.meta.getInstanceValueGenerator();
        if (instanceValueGenerator != null) {
            try {
                return ((InstanceValueGenerator.ValueGenerator)instanceValueGenerator.newInstance()).generateInstanceValue((IGeneric)this.meta, this.supers, value, this.components);
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.context.discardWithException(e);
            }
        }
        return value;
    }

    private void check() {
        this.context.getChecker().checkBeforeBuild(this.meta, this.overrides, this.value, this.components);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isMeta() {
        if (!Objects.equals(this.context.getRoot().getValue(), this.value)) return false;
        if (!this.components.stream().allMatch(this.context.getRoot()::equals)) return false;
        return true;
    }

    void adjust() {
        this.adjustedMeta = (Generic)this.meta.adjustMeta(this.components);
        if (!this.isMeta() && this.adjustedMeta.getComponents().size() != this.components.size()) {
            this.adjustedMeta = this.context.setMeta(this.components.size());
        }
        this.supers = this.context.computeAndCheckOverridesAreReached(this.adjustedMeta, this.overrides, this.value, this.components);
    }

    Generic get() {
        if (this.gettable == null) {
            this.gettable = (Generic)this.adjustedMeta.getDirectInstance(this.supers, this.value, this.components);
        }
        return this.gettable;
    }

    Generic getEquiv() {
        return (Generic)this.adjustedMeta.getDirectEquivInstance(this.supers, this.value, this.components);
    }

    public Generic getOrBuild() {
        Generic instance = this.get();
        return instance == null ? this.build() : instance;
    }

    protected Generic build() {
        this.gettable = this.context.buildAndPlug(null, this.isMeta() ? null : this.adjustedMeta, this.supers, this.value, this.components);
        return this.gettable;
    }

    Generic add() {
        return this.context.getRestructurator().rebuildAll(null, () -> this.build(), this.context.computePotentialDependencies(this.adjustedMeta, this.supers, this.value, this.components));
    }

    Generic set(Generic update) {
        assert (update != null);
        return this.context.getRestructurator().rebuildAll(update, () -> this.build(), this.context.computeDependencies(update));
    }

    Generic merge(Generic update) {
        assert (update != null);
        return this.context.getRestructurator().rebuildAll(update, () -> this.getOrBuild(), this.context.computeDependencies(update));
    }

    public static class SetSystemBuilder
    extends AtomicBuilder {
        private final Class<?> clazz;

        public SetSystemBuilder(AbstractCache context, Class<?> clazz, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
            this.clazz = clazz;
        }

        @Override
        Serializable generateValue(Serializable value) {
            return value;
        }

        @Override
        protected Generic build() {
            this.gettable = this.context.buildAndPlug(this.clazz, this.isMeta() ? null : this.adjustedMeta, this.supers, this.value, this.components);
            return this.gettable;
        }

        @Override
        public final Generic resolve() {
            Generic instance = this.get();
            return instance == null ? this.build() : instance;
        }
    }

    public static class AtomicBuilder
    extends GenericBuilder {
        protected AtomicBuilder(AbstractCache context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
        }

        public Generic resolve() {
            return this.getOrBuild();
        }
    }

    static class MergeBuilder
    extends GenericBuilder {
        private final Generic update;

        MergeBuilder(AbstractCache context, Generic update, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
            this.update = update;
        }

        Generic resolve() {
            return this.merge(this.update);
        }
    }

    static class UpdateBuilder
    extends GenericBuilder {
        private final Generic update;

        UpdateBuilder(AbstractCache context, Generic update, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
            this.update = update;
        }

        Generic resolve() {
            Generic generic = this.get();
            if (generic != null && this.update != generic) {
                this.context.discardWithException((Throwable)new ExistsException("An equivalent instance already exists : " + generic.info()));
            }
            return this.set(this.update);
        }
    }

    static class SetBuilder
    extends GenericBuilder {
        SetBuilder(AbstractCache context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
        }

        Generic resolve() {
            Generic generic = this.get();
            if (generic != null) {
                return generic;
            }
            generic = this.getEquiv();
            return generic == null ? this.add() : this.set(generic);
        }
    }

    public static class AddBuilder
    extends GenericBuilder {
        AddBuilder(AbstractCache context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
        }

        public Generic resolve() {
            Generic generic = this.get();
            if (generic != null) {
                this.context.discardWithException((Throwable)new ExistsException("An equivalent instance already exists : " + generic.info()));
            }
            return this.add();
        }
    }
}

