/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.genericsystem.api.core.ApiStatics;
import org.genericsystem.api.core.AxedPropertyClass;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.common.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSBuffer
implements Buffer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int index = 0;
    private final Buffer internal;

    public GSBuffer() {
        this(Buffer.buffer());
    }

    public GSBuffer(Buffer internal) {
        this.internal = internal;
    }

    public void writeToBuffer(Buffer buffer) {
        this.internal.writeToBuffer(buffer);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        return this.internal.readFromBuffer(pos, buffer);
    }

    public String toString(String enc) {
        return this.internal.toString(enc);
    }

    public byte getByte(int pos) {
        return this.internal.getByte(pos);
    }

    public int getInt(int pos) {
        return this.internal.getInt(pos);
    }

    public long getLong(int pos) {
        return this.internal.getLong(pos);
    }

    public double getDouble(int pos) {
        return this.internal.getDouble(pos);
    }

    public float getFloat(int pos) {
        return this.internal.getFloat(pos);
    }

    public short getShort(int pos) {
        return this.internal.getShort(pos);
    }

    public byte[] getBytes() {
        return this.internal.getBytes();
    }

    public byte[] getBytes(int start, int end) {
        return this.internal.getBytes(start, end);
    }

    public GSBuffer getBuffer(int start, int end) {
        return new GSBuffer(this.internal.getBuffer(start, end));
    }

    public String getString(int start, int end, String enc) {
        return this.internal.getString(start, end, enc);
    }

    public String getString(int start, int end) {
        return this.internal.getString(start, end);
    }

    public Buffer appendBuffer(Buffer buff) {
        return this.internal.appendBuffer(buff);
    }

    public Buffer appendBuffer(Buffer buff, int offset, int len) {
        return this.internal.appendBuffer(buff, offset, len);
    }

    public Buffer appendBytes(byte[] bytes) {
        return this.internal.appendBytes(bytes);
    }

    public Buffer appendBytes(byte[] bytes, int offset, int len) {
        return this.internal.appendBytes(bytes, offset, len);
    }

    public GSBuffer appendByte(byte b) {
        this.internal.appendByte(b);
        return this;
    }

    public GSBuffer appendInt(int i) {
        this.internal.appendInt(i);
        return this;
    }

    public GSBuffer appendLong(long l) {
        this.internal.appendLong(l);
        return this;
    }

    public GSBuffer appendShort(short s) {
        this.internal.appendShort(s);
        return this;
    }

    public GSBuffer appendFloat(float f) {
        this.internal.appendFloat(f);
        return this;
    }

    public GSBuffer appendDouble(double d) {
        this.internal.appendDouble(d);
        return this;
    }

    public GSBuffer appendString(String str, String enc) {
        this.internal.appendString(str, enc);
        return this;
    }

    public GSBuffer appendString(String str) {
        this.internal.appendString(str);
        return this;
    }

    public GSBuffer appendGSString(String string) {
        return this.appendGSBytes(string.getBytes(CharsetUtil.UTF_8));
    }

    public GSBuffer appendGSVertex(Vertex vertex) {
        this.appendGSClazz(vertex.getClazz());
        this.appendLong(vertex.getTs());
        this.appendLong(vertex.getMeta());
        this.appendGSLongList(vertex.getSupers());
        this.appendGSValue(vertex.getValue());
        this.appendGSLongList(vertex.getComponents());
        this.appendLong(vertex.getBirthTs());
        return this;
    }

    public GSBuffer appendGSSignature(long meta, List<Long> supers, Serializable value, List<Long> components) {
        this.appendLong(meta);
        this.appendGSLongList(supers);
        this.appendGSValue(value);
        this.appendGSLongList(components);
        return this;
    }

    public GSBuffer appendGSVertexArray(Vertex[] vertexArray) {
        this.appendInt(vertexArray.length);
        for (Vertex v : vertexArray) {
            this.appendGSVertex(v);
        }
        return this;
    }

    public GSBuffer appendGSLongList(List<Long> array) {
        this.appendInt(array.size());
        for (long l : array) {
            this.appendLong(l);
        }
        return this;
    }

    public GSBuffer appendGSLongArray(long[] array) {
        this.appendInt(array.length);
        for (long l : array) {
            this.appendLong(l);
        }
        return this;
    }

    public GSBuffer appendGSValue(Serializable value) {
        for (Map.Entry entry : ApiStatics.SUPPORTED_VALUE_CLASSES.entrySet()) {
            if (!((Class)entry.getValue()).isInstance(value)) continue;
            this.appendInt((Integer)entry.getKey());
            switch ((Integer)entry.getKey()) {
                case 0: {
                    this.appendGSClazz(((AxedPropertyClass)value).getClazz());
                    this.appendInt(((AxedPropertyClass)value).getAxe());
                    return this;
                }
                case 1: {
                    this.appendInt((Boolean)value != false ? 1 : 0);
                    return this;
                }
                case 2: {
                    this.appendGSBytes((byte[])value);
                    return this;
                }
                case 3: {
                    this.appendDouble((Double)value);
                    return this;
                }
                case 4: {
                    this.appendFloat(((Float)value).floatValue());
                    return this;
                }
                case 5: {
                    this.appendInt((Integer)value);
                    return this;
                }
                case 6: {
                    this.appendLong((Long)value);
                    return this;
                }
                case 7: {
                    this.appendShort((Short)value);
                    return this;
                }
                case 8: {
                    this.appendGSString((String)((Object)value));
                    return this;
                }
                case 9: {
                    this.appendGSClazz((Class)value);
                    return this;
                }
            }
            throw new IllegalStateException("unknown class code in appendGSValue" + entry.getKey());
        }
        return this;
    }

    public GSBuffer appendGSBytes(byte[] bytes) {
        this.appendInt(bytes.length);
        this.appendBytes(bytes);
        return this;
    }

    public GSBuffer appendGSClazz(Class<?> clazz) {
        this.appendGSString(clazz != null ? clazz.getName() : "");
        return this;
    }

    public Object getIntThrowException() {
        return this.getInt() == 1 ? Integer.valueOf(this.getInt()) : this.getGSSerializable();
    }

    public Object getLongThrowException() {
        return this.getInt() == 1 ? Long.valueOf(this.getLong()) : this.getGSSerializable();
    }

    public Object getGSVertexThrowException() {
        return this.getInt() == 1 ? this.getGSVertex() : this.getGSSerializable();
    }

    public Object getGSVertexArrayThrowException() {
        return this.getInt() == 1 ? this.getGSVertexArray() : this.getGSSerializable();
    }

    public GSBuffer appendIntThrowException(ConcurrentSupplier<Integer> supplier) {
        try {
            int result = supplier.get();
            this.appendInt(1);
            this.appendInt(result);
        }
        catch (Throwable t) {
            this.appendInt(0);
            logger.warn("Exception while appending to buffer.", t);
            this.appendGSSerializable(t);
        }
        return this;
    }

    public GSBuffer appendLongThrowException(ConcurrentSupplier<Long> supplier) {
        try {
            long result = supplier.get();
            this.appendInt(1);
            this.appendLong(result);
        }
        catch (Throwable t) {
            this.appendInt(0);
            logger.warn("Exception while appending to buffer.", t);
            this.appendGSSerializable(t);
        }
        return this;
    }

    public GSBuffer appendGSVertexThrowException(ConcurrentSupplier<Vertex> vertex) {
        try {
            Vertex result = vertex.get();
            this.appendInt(1);
            this.appendGSVertex(result);
        }
        catch (Throwable t) {
            this.appendInt(0);
            logger.warn("Exception while appending to buffer.", t);
            this.appendGSSerializable(t);
        }
        return this;
    }

    public GSBuffer appendGSVertexArrayThrowException(ConcurrentSupplier<Vertex[]> vertexArray) {
        try {
            Vertex[] result = vertexArray.get();
            this.appendInt(1);
            this.appendGSVertexArray(result);
        }
        catch (Throwable t) {
            this.appendInt(0);
            logger.warn("Exception while appending to buffer.", t);
            this.appendGSSerializable(t);
        }
        return this;
    }

    public GSBuffer appendGSSerializable(Serializable serializable) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(serializable);
        }
        catch (IOException e) {
            logger.error("Exception while writing object.", (Throwable)e);
            throw new IllegalStateException(e);
        }
        this.appendGSBytes(bos.toByteArray());
        return this;
    }

    public Serializable getGSSerializable() {
        Serializable serializable;
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getGSBytes());
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            serializable = (Serializable)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("Exception while reading object.", (Throwable)e);
            throw new IllegalStateException();
        }
        return serializable;
    }

    public int getInt() {
        int result = this.getInt(this.index);
        this.index += 4;
        return result;
    }

    public long getLong() {
        long result = this.getLong(this.index);
        this.index += 8;
        return result;
    }

    public double getDouble() {
        double result = this.getDouble(this.index);
        this.index += 16;
        return result;
    }

    public float getFloat() {
        float result = this.getFloat(this.index);
        this.index += 8;
        return result;
    }

    public short getShort() {
        short result = this.getShort(this.index);
        this.index += 2;
        return result;
    }

    public String getGSString() {
        byte[] result = this.getGSBytes();
        return new String(result);
    }

    public Vertex getGSVertex() {
        Class<?> clazz = this.getGSClazz();
        long ts = this.getLong();
        long meta = this.getLong();
        List<Long> supers = Arrays.stream(this.getGSLongArray()).mapToObj(l -> l).collect(Collectors.toList());
        Serializable value = this.getGSValue();
        List<Long> components = Arrays.stream(this.getGSLongArray()).mapToObj(l -> l).collect(Collectors.toList());
        long birthTs = this.getLong();
        return new Vertex(clazz, ts, meta, supers, value, components, birthTs);
    }

    public Vertex[] getGSVertexArray() {
        Vertex[] result = new Vertex[this.getInt()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getGSVertex();
        }
        return result;
    }

    public long[] getGSLongArray() {
        long[] result = new long[this.getInt()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getLong();
        }
        return result;
    }

    public Serializable getGSValue() {
        int code = this.getInt();
        switch (code) {
            case 0: {
                return new AxedPropertyClass(this.getGSClazz(), this.getInt());
            }
            case 1: {
                return Boolean.valueOf(this.getInt() == 1);
            }
            case 2: {
                return this.getGSBytes();
            }
            case 3: {
                return Double.valueOf(this.getDouble());
            }
            case 4: {
                return Float.valueOf(this.getFloat());
            }
            case 5: {
                return Integer.valueOf(this.getInt());
            }
            case 6: {
                return Long.valueOf(this.getLong());
            }
            case 7: {
                return Short.valueOf(this.getShort());
            }
            case 8: {
                return this.getGSString();
            }
            case 9: {
                return this.getGSClazz();
            }
            case 10: {
                return null;
            }
        }
        throw new IllegalStateException("unknowned class code");
    }

    public Class<?> getGSClazz() {
        String string = this.getGSString();
        try {
            return string.isEmpty() ? null : Class.forName(string);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] getGSBytes() {
        int length = this.getInt();
        byte[] result = this.getBytes(this.index, this.index + length);
        if (result.length != length) {
            throw new IllegalStateException(result.length + " " + length);
        }
        this.index += length;
        return result;
    }

    public byte getByte() {
        byte result = this.getByte(this.index);
        ++this.index;
        return result;
    }

    public GSBuffer setByte(int pos, byte b) {
        this.internal.setByte(pos, b);
        return this;
    }

    public GSBuffer setInt(int pos, int i) {
        this.internal.setInt(pos, i);
        return this;
    }

    public GSBuffer setLong(int pos, long l) {
        this.internal.setLong(pos, l);
        return this;
    }

    public GSBuffer setDouble(int pos, double d) {
        this.internal.setDouble(pos, d);
        return this;
    }

    public GSBuffer setFloat(int pos, float f) {
        this.internal.setFloat(pos, f);
        return this;
    }

    public GSBuffer setShort(int pos, short s) {
        this.internal.setShort(pos, s);
        return this;
    }

    public GSBuffer setBuffer(int pos, Buffer b) {
        this.internal.setBuffer(pos, b);
        return this;
    }

    public GSBuffer setBuffer(int pos, Buffer b, int offset, int len) {
        this.internal.setBuffer(pos, b, offset, len);
        return this;
    }

    public GSBuffer setBytes(int pos, ByteBuffer b) {
        this.internal.setBytes(pos, b);
        return this;
    }

    public GSBuffer setBytes(int pos, byte[] b) {
        this.internal.setBytes(pos, b);
        return this;
    }

    public GSBuffer setBytes(int pos, byte[] b, int offset, int len) {
        this.internal.setBytes(pos, b, offset, len);
        return this;
    }

    public GSBuffer setString(int pos, String str) {
        this.internal.setString(pos, str);
        return this;
    }

    public GSBuffer setString(int pos, String str, String enc) {
        this.internal.setString(pos, str, enc);
        return this;
    }

    public int length() {
        return this.internal.length();
    }

    public GSBuffer copy() {
        return new GSBuffer(this.internal.copy());
    }

    public GSBuffer slice() {
        this.internal.slice();
        return this;
    }

    public Buffer slice(int start, int end) {
        return this.internal.slice(start, end);
    }

    public ByteBuf getByteBuf() {
        return this.internal.getByteBuf();
    }

    public GSBuffer appendUnsignedByte(short arg0) {
        this.internal.appendUnsignedByte(arg0);
        return this;
    }

    public GSBuffer appendUnsignedInt(long arg0) {
        this.internal.appendUnsignedInt(arg0);
        return this;
    }

    public GSBuffer appendUnsignedShort(int arg0) {
        this.internal.appendUnsignedShort(arg0);
        return this;
    }

    public short getUnsignedByte(int arg0) {
        return this.internal.getUnsignedByte(arg0);
    }

    public long getUnsignedInt(int arg0) {
        return this.internal.getUnsignedInt(arg0);
    }

    public int getUnsignedShort(int arg0) {
        return this.internal.getUnsignedShort(arg0);
    }

    public GSBuffer setUnsignedByte(int arg0, short arg1) {
        this.internal.setUnsignedByte(arg0, arg1);
        return this;
    }

    public GSBuffer setUnsignedInt(int arg0, long arg1) {
        this.internal.setUnsignedInt(arg0, arg1);
        return this;
    }

    public GSBuffer setUnsignedShort(int arg0, int arg1) {
        this.internal.setUnsignedShort(arg0, arg1);
        return this;
    }

    public GSBuffer getBytes(byte[] arg0) {
        return new GSBuffer(this.internal.getBytes(arg0));
    }

    public GSBuffer getBytes(byte[] arg0, int arg1) {
        return new GSBuffer(this.internal.getBytes(arg0, arg1));
    }

    public GSBuffer getBytes(int arg0, int arg1, byte[] arg2) {
        return new GSBuffer(this.internal.getBytes(arg0, arg1, arg2));
    }

    public GSBuffer getBytes(int arg0, int arg1, byte[] arg2, int arg3) {
        return new GSBuffer(this.internal.getBytes(arg0, arg1, arg2, arg3));
    }

    public JsonArray toJsonArray() {
        return this.internal.toJsonArray();
    }

    public JsonObject toJsonObject() {
        return this.internal.toJsonObject();
    }

    public String toString(Charset arg0) {
        return this.internal.toString();
    }

    public int getIntLE(int pos) {
        return this.internal.getIntLE(pos);
    }

    public long getUnsignedIntLE(int pos) {
        return this.internal.getUnsignedIntLE(pos);
    }

    public long getLongLE(int pos) {
        return this.internal.getLongLE(pos);
    }

    public short getShortLE(int pos) {
        return this.internal.getShortLE(pos);
    }

    public int getUnsignedShortLE(int pos) {
        return this.internal.getUnsignedShortLE(pos);
    }

    public int getMedium(int pos) {
        return this.internal.getMedium(pos);
    }

    public int getMediumLE(int pos) {
        return this.internal.getMediumLE(pos);
    }

    public int getUnsignedMedium(int pos) {
        return this.internal.getUnsignedMedium(pos);
    }

    public int getUnsignedMediumLE(int pos) {
        return this.internal.getUnsignedMediumLE(pos);
    }

    public Buffer appendIntLE(int i) {
        return this.internal.appendIntLE(i);
    }

    public Buffer appendUnsignedIntLE(long i) {
        return this.internal.appendUnsignedIntLE(i);
    }

    public Buffer appendMedium(int i) {
        return this.internal.appendMedium(i);
    }

    public Buffer appendMediumLE(int i) {
        return this.internal.appendMediumLE(i);
    }

    public Buffer appendLongLE(long l) {
        return this.internal.appendLongLE(l);
    }

    public Buffer appendShortLE(short s) {
        return this.internal.appendShortLE(s);
    }

    public Buffer appendUnsignedShortLE(int s) {
        return this.internal.appendUnsignedShortLE(s);
    }

    public Buffer setIntLE(int pos, int i) {
        return this.internal.setInt(pos, i);
    }

    public Buffer setUnsignedIntLE(int pos, long i) {
        return this.internal.setUnsignedIntLE(pos, i);
    }

    public Buffer setMedium(int pos, int i) {
        return this.internal.setMedium(pos, i);
    }

    public Buffer setMediumLE(int pos, int i) {
        return this.internal.setMediumLE(pos, i);
    }

    public Buffer setLongLE(int pos, long l) {
        return this.internal.setLongLE(pos, l);
    }

    public Buffer setShortLE(int pos, short s) {
        return this.internal.setShortLE(pos, s);
    }

    public Buffer setUnsignedShortLE(int pos, int s) {
        return this.internal.setUnsignedShortLE(pos, s);
    }

    @FunctionalInterface
    public static interface ConcurrentSupplier<T> {
        public T get() throws ConcurrencyControlException, OptimisticLockConstraintViolationException;
    }
}

