/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.tools.Memoizer;
import org.genericsystem.common.Checker;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.defaults.DefaultConfig;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.tools.InheritanceComputer;

public abstract class CheckedContext
implements DefaultContext<Generic> {
    private final Root root;
    private final Checker checker;
    private final Function<Generic, Snapshot<Generic>> getSubInheritingsM = Memoizer.memoize(generic -> new Snapshot<Generic>(){
        private Observable adds;
        private Observable removals;
        {
            this.adds = Observable.merge((ObservableSource)generic.getInheritings().getAdds(), (ObservableSource)Observable.fromIterable((Iterable)generic.getInheritings()).flatMap(g -> ((Snapshot)CheckedContext.this.getSubInheritingsM.apply(g)).getAdds()), (ObservableSource)generic.getInheritings().getAdds().flatMap(g -> ((Snapshot)CheckedContext.this.getSubInheritingsM.apply(g)).getAdds())).share();
            this.removals = Observable.merge((ObservableSource)generic.getInheritings().getRemovals(), (ObservableSource)Observable.fromIterable((Iterable)generic.getInheritings()).flatMap(g -> ((Snapshot)CheckedContext.this.getSubInheritingsM.apply(g)).getRemovals()), (ObservableSource)generic.getInheritings().getAdds().flatMap(g -> ((Snapshot)CheckedContext.this.getSubInheritingsM.apply(g)).getRemovals())).share();
        }

        public Stream<Generic> unfilteredStream() {
            return Stream.concat(Stream.of(generic), generic.getInheritings().stream().flatMap(inheriting -> ((Snapshot)CheckedContext.this.getSubInheritingsM.apply(inheriting)).stream())).distinct();
        }

        public Observable<Generic> getAdds() {
            return this.adds;
        }

        public Observable<Generic> getRemovals() {
            return this.removals;
        }
    });
    private final Function<Generic, Snapshot<Generic>> getSubInstancesM = Memoizer.memoize(generic -> new Snapshot<Generic>(){
        private Observable adds;
        private Observable removals;
        {
            this.adds = Observable.merge((ObservableSource)Observable.fromIterable((Iterable)generic.getSubInheritings()).flatMap(g -> g.getInstances().getAdds()), (ObservableSource)generic.getSubInheritings().getAdds().flatMap(g -> g.getInstances().getAdds())).share();
            this.removals = Observable.merge((ObservableSource)Observable.fromIterable((Iterable)generic.getSubInheritings()).flatMap(g -> g.getInstances().getRemovals()), (ObservableSource)generic.getSubInheritings().getAdds().flatMap(g -> g.getInstances().getRemovals())).share();
        }

        public Stream<Generic> unfilteredStream() {
            return generic.getSubInheritings().stream().flatMap(inheriting -> inheriting.getInstances().stream());
        }

        public Observable<Generic> getAdds() {
            return this.adds;
        }

        public Observable<Generic> getRemovals() {
            return this.removals;
        }
    });
    private final Function<Generic, Function<Generic, Snapshot<Generic>>> getAttributesM = Memoizer.memoize(this::computeGetAttributes);
    private final Function<Generic, Function<Generic, Snapshot<Generic>>> getHoldersM = Memoizer.memoize(this::computeGetHolders);

    protected CheckedContext(Root root) {
        assert (root != null);
        this.root = root;
        this.checker = this.buildChecker();
    }

    protected Checker buildChecker() {
        return new Checker(this);
    }

    protected Checker getChecker() {
        return this.checker;
    }

    public Root getRoot() {
        return this.root;
    }

    protected void triggersMutation(Generic oldDependency, Generic newDependency) {
    }

    public abstract Snapshot<Generic> getDependencies(Generic var1);

    public Snapshot<Generic> getSubInstances(Generic vertex) {
        return this.getSubInstancesM.apply(vertex);
    }

    public Snapshot<Generic> getSubInheritings(Generic vertex) {
        return this.getSubInheritingsM.apply(vertex);
    }

    private Function<Generic, Snapshot<Generic>> computeGetAttributes(final Generic generic) {
        return Memoizer.memoize(attribute -> new Snapshot<Generic>(){
            InheritanceComputer inheritanceComputer;
            {
                this.inheritanceComputer = new InheritanceComputer((DefaultGeneric)generic, (DefaultGeneric)attribute, 1);
            }

            public Stream<Generic> unfilteredStream() {
                Generic nonHeritableProperty = (Generic)generic.getKey(DefaultConfig.NonHeritableProperty.class, -1);
                if (nonHeritableProperty == null || attribute.inheritsFrom(nonHeritableProperty) || attribute.isInheritanceEnabled()) {
                    return this.inheritanceComputer.inheritanceStream();
                }
                return generic.getComposites().filter(new IndexFilter(FiltersBuilder.IS_SPECIALIZATION_OF, new Object[]{attribute})).filter(new IndexFilter(FiltersBuilder.HAS_LEVEL, new Object[]{1})).stream();
            }

            public Observable<Generic> getAdds() {
                return this.inheritanceComputer.getAdds();
            }

            public Observable<Generic> getRemovals() {
                return this.inheritanceComputer.getRemovals();
            }
        });
    }

    public Snapshot<Generic> getAttributes(Generic generic, Generic attribute) {
        return this.getAttributesM.apply(generic).apply(attribute);
    }

    private Function<Generic, Snapshot<Generic>> computeGetHolders(final Generic generic) {
        return Memoizer.memoize(attribute -> new Snapshot<Generic>(){
            InheritanceComputer inheritanceComputer;
            {
                this.inheritanceComputer = new InheritanceComputer((DefaultGeneric)generic, (DefaultGeneric)attribute, 2);
            }

            public Stream<Generic> unfilteredStream() {
                Generic nonHeritableProperty = (Generic)generic.getKey(DefaultConfig.NonHeritableProperty.class, -1);
                if (nonHeritableProperty == null || attribute.inheritsFrom(nonHeritableProperty) || attribute.isInheritanceEnabled()) {
                    return this.inheritanceComputer.inheritanceStream();
                }
                return generic.getComposites().filter(new IndexFilter(FiltersBuilder.IS_SPECIALIZATION_OF, new Object[]{attribute})).filter(new IndexFilter(FiltersBuilder.HAS_LEVEL, new Object[]{2})).stream();
            }

            public Observable<Generic> getAdds() {
                return this.inheritanceComputer.getAdds();
            }

            public Observable<Generic> getRemovals() {
                return this.inheritanceComputer.getRemovals();
            }
        });
    }

    public Snapshot<Generic> getHolders(Generic generic, Generic attribute) {
        return this.getHoldersM.apply(generic).apply(attribute);
    }

    public Generic get(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        meta = meta != null ? meta : this.getRoot();
        if ((meta = (Generic)meta.adjustMeta(components)).getComponents().size() != components.size()) {
            return null;
        }
        overrides = this.computeAndCheckOverridesAreReached(meta, overrides, value, components);
        return (Generic)meta.getDirectInstance(overrides, value, components);
    }
}

