/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SoftValueHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Map<K, SoftValueRef<K, V>> map = new HashMap<K, SoftValueRef<K, V>>();
    private ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public synchronized Set entrySet() {
        this.processQueue();
        return this.map.entrySet();
    }

    @Override
    public synchronized Collection<V> values() {
        this.processQueue();
        return this.map.values().stream().map(ref -> ref.get()).filter(v -> v != null).collect(Collectors.toList());
    }

    private synchronized void processQueue() {
        SoftValueRef ref;
        while ((ref = (SoftValueRef)this.queue.poll()) != null) {
            this.map.remove(ref.key);
        }
    }

    @Override
    public synchronized int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        this.processQueue();
        return this.map.containsKey(key);
    }

    @Override
    public synchronized V get(Object key) {
        this.processQueue();
        SoftValueRef<K, V> ref = this.map.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public synchronized V put(K key, V value) {
        this.processQueue();
        SoftValueRef ref = this.map.put(key, SoftValueRef.create(key, value, this.queue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public synchronized V remove(Object key) {
        this.processQueue();
        SoftValueRef<K, V> ref = this.map.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public synchronized void clear() {
        this.processQueue();
        this.map.clear();
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        this.processQueue();
        V result = this.get(key);
        if (result == null) {
            result = this.put(key, value);
        }
        return result;
    }

    @Override
    public synchronized V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.processQueue();
        V result = this.get(key);
        if (result == null) {
            V newValue = mappingFunction.apply(key);
            this.put(key, newValue);
            return newValue;
        }
        return result;
    }

    private static class SoftValueRef<K, V>
    extends SoftReference<V> {
        public K key;

        private SoftValueRef(K key, V val, ReferenceQueue<V> q) {
            super(val, q);
            this.key = key;
        }

        private static <T, U> SoftValueRef<T, U> create(T key, U val, ReferenceQueue<U> q) {
            if (val == null) {
                return null;
            }
            return new SoftValueRef<T, U>(key, val, q);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SoftValueRef)) {
                return false;
            }
            return Objects.equals(((SoftValueRef)obj).get(), this.get());
        }
    }
}

