/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.api.core.AxedPropertyClass;
import org.genericsystem.api.core.IRoot;
import org.genericsystem.api.core.annotations.Components;
import org.genericsystem.api.core.annotations.Dependencies;
import org.genericsystem.api.core.annotations.HashedInstanceValue;
import org.genericsystem.api.core.annotations.HideValue;
import org.genericsystem.api.core.annotations.Meta;
import org.genericsystem.api.core.annotations.Supers;
import org.genericsystem.api.core.annotations.constraints.InstanceValueClassConstraint;
import org.genericsystem.api.core.annotations.constraints.InstanceValueGenerator;
import org.genericsystem.api.core.annotations.constraints.NoInheritance;
import org.genericsystem.api.core.annotations.constraints.NoReferentialIntegrityProperty;
import org.genericsystem.api.core.annotations.constraints.PropertyConstraint;
import org.genericsystem.api.core.annotations.constraints.RequiredConstraint;
import org.genericsystem.api.core.annotations.constraints.SingularConstraint;
import org.genericsystem.api.core.annotations.constraints.UniqueValueConstraint;
import org.genericsystem.api.core.annotations.value.AxedPropertyClassValue;
import org.genericsystem.api.core.annotations.value.BooleanValue;
import org.genericsystem.api.core.annotations.value.ByteArrayValue;
import org.genericsystem.api.core.annotations.value.ClassGenericValue;
import org.genericsystem.api.core.annotations.value.DoubleValue;
import org.genericsystem.api.core.annotations.value.EngineValue;
import org.genericsystem.api.core.annotations.value.FloatValue;
import org.genericsystem.api.core.annotations.value.IntValue;
import org.genericsystem.api.core.annotations.value.LongValue;
import org.genericsystem.api.core.annotations.value.ShortValue;
import org.genericsystem.api.core.annotations.value.StringValue;
import org.genericsystem.api.core.exceptions.CyclicException;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.defaults.DefaultRoot;

public abstract class SystemCache {
    private final Map<Class<?>, Generic> systemCache = new HashMap();
    private final Map<Generic, Class<?>> reverseSystemCache = new IdentityHashMap();
    protected final Root root;

    public SystemCache(Root root) {
        this.root = root;
        this.put(DefaultRoot.class, root);
        this.put(root.getClass(), root);
    }

    public void mount(List<Class<?>> systemClasses, Class<?> ... userClasses) {
        for (Class<?> clazz : systemClasses) {
            this.bind(clazz);
        }
        for (Class<?> clazz : userClasses) {
            this.bind(clazz);
        }
    }

    private Generic set(Class<?> clazz) {
        if (this.root.isInitialized()) {
            throw new IllegalStateException("Class : " + clazz + " has not been built at startup");
        }
        Generic systemProperty = this.systemCache.get(clazz);
        if (systemProperty != null) {
            assert (systemProperty.isAlive());
            return systemProperty;
        }
        Generic meta = this.setMeta(clazz);
        List<Generic> overrides = this.setOverrides(clazz);
        Serializable value = this.findValue(clazz);
        List<Generic> components = this.setComponents(clazz);
        AbstractCache cache = this.root.getCurrentCache();
        systemProperty = this.getOrBuild(cache, clazz, meta, overrides, value, components);
        this.put(clazz, systemProperty);
        this.mountConstraints(clazz, systemProperty);
        this.triggersDependencies(clazz);
        return systemProperty;
    }

    protected abstract Generic getOrBuild(AbstractCache var1, Class<?> var2, Generic var3, List<Generic> var4, Serializable var5, List<Generic> var6);

    private void put(Class<?> clazz, Generic vertex) {
        this.systemCache.put(clazz, vertex);
        this.reverseSystemCache.put(vertex, clazz);
    }

    public Generic find(Class<?> clazz) {
        if (IRoot.class.isAssignableFrom(clazz)) {
            return this.root;
        }
        return this.systemCache.get(clazz);
    }

    public Generic bind(Class<?> clazz) {
        Generic result = this.find(clazz);
        if (result == null) {
            result = this.set(clazz);
        }
        return result;
    }

    public Class<?> getClassByVertex(Generic vertex) {
        return this.reverseSystemCache.get(vertex);
    }

    void mountConstraints(Class<?> clazz, Generic result) {
        SingularConstraint singularTarget;
        NoReferentialIntegrityProperty referentialIntegrity;
        RequiredConstraint requiredConstraint;
        if (clazz.getAnnotation(PropertyConstraint.class) != null) {
            result.enablePropertyConstraint();
        }
        if (clazz.getAnnotation(UniqueValueConstraint.class) != null) {
            result.enableUniqueValueConstraint();
        }
        if (clazz.getAnnotation(InstanceValueClassConstraint.class) != null) {
            result.setInstanceValueClassConstraint(clazz.getAnnotation(InstanceValueClassConstraint.class).value());
        }
        if (clazz.getAnnotation(NoInheritance.class) != null) {
            result.disableInheritance();
        }
        if (clazz.getAnnotation(InstanceValueGenerator.class) != null) {
            result.setInstanceValueGenerator(clazz.getAnnotation(InstanceValueGenerator.class).value());
        }
        if ((requiredConstraint = clazz.getAnnotation(RequiredConstraint.class)) != null) {
            for (int axe : requiredConstraint.value()) {
                result.enableRequiredConstraint(axe);
            }
        }
        if ((referentialIntegrity = clazz.getAnnotation(NoReferentialIntegrityProperty.class)) != null) {
            for (int axe : referentialIntegrity.value()) {
                result.disableReferentialIntegrity(axe);
            }
        }
        if ((singularTarget = clazz.getAnnotation(SingularConstraint.class)) != null) {
            for (int axe : singularTarget.value()) {
                result.enableSingularConstraint(axe);
            }
        }
        if (clazz.getAnnotation(HashedInstanceValue.class) != null) {
            result.enableHashedInstanceValue();
        }
        if (clazz.getAnnotation(HideValue.class) != null) {
            result.hideValue();
        }
    }

    private void triggersDependencies(Class<?> clazz) {
        Dependencies dependenciesClass = clazz.getAnnotation(Dependencies.class);
        if (dependenciesClass != null) {
            for (Class dependencyClass : dependenciesClass.value()) {
                this.bind(dependencyClass);
            }
        }
    }

    private Generic setMeta(Class<?> clazz) {
        Meta meta = clazz.getAnnotation(Meta.class);
        if (meta == null) {
            return this.root;
        }
        if (meta.value() == clazz) {
            return null;
        }
        return this.bind(meta.value());
    }

    private List<Generic> setOverrides(Class<?> clazz) {
        ArrayList<Generic> overridesVertices = new ArrayList<Generic>();
        Supers supersAnnotation = clazz.getAnnotation(Supers.class);
        if (supersAnnotation != null) {
            for (Class overrideClass : supersAnnotation.value()) {
                overridesVertices.add(this.bind(overrideClass));
            }
        }
        return overridesVertices;
    }

    private Serializable findValue(Class<?> clazz) {
        AxedPropertyClassValue axedPropertyClass = clazz.getAnnotation(AxedPropertyClassValue.class);
        if (axedPropertyClass != null) {
            return new AxedPropertyClass(axedPropertyClass.propertyClass(), axedPropertyClass.pos());
        }
        BooleanValue booleanValue = clazz.getAnnotation(BooleanValue.class);
        if (booleanValue != null) {
            return Boolean.valueOf(booleanValue.value());
        }
        ByteArrayValue byteArrayValue = clazz.getAnnotation(ByteArrayValue.class);
        if (byteArrayValue != null) {
            return byteArrayValue.value();
        }
        ClassGenericValue classValue = clazz.getAnnotation(ClassGenericValue.class);
        if (classValue != null) {
            return classValue.value();
        }
        DoubleValue doubleValue = clazz.getAnnotation(DoubleValue.class);
        if (doubleValue != null) {
            return Double.valueOf(doubleValue.value());
        }
        EngineValue engineValue = clazz.getAnnotation(EngineValue.class);
        if (engineValue != null) {
            return this.root.getValue();
        }
        FloatValue floatValue = clazz.getAnnotation(FloatValue.class);
        if (floatValue != null) {
            return Float.valueOf(floatValue.value());
        }
        IntValue intValue = clazz.getAnnotation(IntValue.class);
        if (intValue != null) {
            return Integer.valueOf(intValue.value());
        }
        LongValue longValue = clazz.getAnnotation(LongValue.class);
        if (longValue != null) {
            return Long.valueOf(longValue.value());
        }
        ShortValue shortValue = clazz.getAnnotation(ShortValue.class);
        if (shortValue != null) {
            return Short.valueOf(shortValue.value());
        }
        StringValue stringValue = clazz.getAnnotation(StringValue.class);
        if (stringValue != null) {
            return stringValue.value();
        }
        return clazz;
    }

    private List<Generic> setComponents(Class<?> clazz) {
        ArrayList<Generic> components = new ArrayList<Generic>();
        Components componentsAnnotation = clazz.getAnnotation(Components.class);
        if (componentsAnnotation != null) {
            for (Class compositeClass : componentsAnnotation.value()) {
                if (compositeClass.equals(clazz)) {
                    this.root.getCurrentCache().discardWithException((Throwable)new CyclicException("The annoted class " + clazz + " has a component with same name"));
                    continue;
                }
                components.add(this.set(compositeClass));
            }
        }
        return components;
    }
}

