/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.tools.Memoizer;
import org.genericsystem.common.AbstractIterator;
import org.genericsystem.common.SoftValueHashMap;

public class PseudoConcurrentCollection<T extends IGeneric<?>>
implements Snapshot<T> {
    final Map<T, T> map = new HashMap<T, T>();
    private final IndexNode indexesTree = new IndexNode(new IndexImpl(new IndexFilter(FiltersBuilder.NO_FILTER, new Object[0]), null));
    private boolean fireInvalidations = true;
    private Subject<T> adds = PublishSubject.create().toSerialized();
    private Subject<T> removes = PublishSubject.create().toSerialized();
    private Function<Predicate<T>, Observable<T>> getAddsM = Memoizer.memoize(p -> this.adds.hide().filter(x -> this.fireInvalidations && p.test(x)));
    private Function<Predicate<T>, Observable<T>> getRemsM = Memoizer.memoize(p -> this.removes.hide().filter(x -> this.fireInvalidations && p.test(x)));

    public Iterator<T> iterator() {
        return this.indexesTree.getIndex(new ArrayList<IndexFilter>()).iterator();
    }

    public Stream<T> unfilteredStream() {
        return this.indexesTree.getIndex(new ArrayList<IndexFilter>()).stream();
    }

    public Snapshot<T> filter(final List<IndexFilter> filters) {
        return new Snapshot<T>(){

            public Stream<T> unfilteredStream() {
                return PseudoConcurrentCollection.this.indexesTree.getIndex(filters).stream();
            }
        };
    }

    public void add(T element) {
        this.indexesTree.add(element);
        this.adds.onNext(element);
    }

    public boolean remove(T element) {
        boolean result = this.indexesTree.remove(element);
        if (result) {
            this.removes.onNext(element);
        }
        return result;
    }

    public T get(Object o) {
        return (T)((IGeneric)this.map.get(o));
    }

    public Observable<T> getFilteredAdds(Predicate<T> predicate) {
        return this.getAddsM.apply(predicate);
    }

    public Observable<T> getFilteredRemoves(Predicate<T> predicate) {
        return this.getRemsM.apply(predicate);
    }

    public void disableInvalidations() {
        this.fireInvalidations = false;
    }

    public void enableInvalidations() {
        this.fireInvalidations = true;
    }

    private static class Node<T> {
        private final T content;
        private Node<T> next;

        private Node(T content) {
            this.content = content;
        }
    }

    private class IndexImpl
    implements Index<T> {
        private Node<T> head = null;
        private Node<T> tail = null;
        private final IndexFilter filter;

        IndexImpl(IndexFilter filter, Index<T> parent) {
            this.filter = filter;
            if (parent != null) {
                parent.stream().forEach(generic -> {
                    if (filter.test(generic)) {
                        this.add((T)generic);
                    }
                });
            }
        }

        @Override
        public boolean add(T element) {
            assert (element != null);
            if (this.filter.test(element)) {
                Node newNode = new Node(element);
                if (this.head == null) {
                    this.head = newNode;
                } else {
                    this.tail.next = newNode;
                }
                this.tail = newNode;
                PseudoConcurrentCollection.this.map.put(element, element);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(T element) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!element.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new InternalIterator();
        }

        @Override
        public Stream<T> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new InternalIterator(), 0), false);
        }

        public class InternalIterator
        extends AbstractIterator<Node<T>, T>
        implements Iterator<T> {
            private Node<T> last;

            @Override
            protected void advance() {
                this.last = (Node)this.next;
                this.next = this.next == null ? IndexImpl.this.head : ((Node)this.next).next;
            }

            @Override
            public T project() {
                return (IGeneric)((Node)this.next).content;
            }

            @Override
            public void remove() {
                if (this.next == null) {
                    throw new IllegalStateException();
                }
                PseudoConcurrentCollection.this.map.remove(((Node)this.next).content);
                if (this.last == null) {
                    IndexImpl.this.head = ((Node)this.next).next;
                    this.next = null;
                } else {
                    this.last.next = ((Node)this.next).next;
                    if (((Node)this.next).next == null) {
                        IndexImpl.this.tail = this.last;
                    }
                }
            }
        }
    }

    private class IndexNode {
        private Index<T> index;
        private SoftValueHashMap<IndexFilter, IndexNode> children = new SoftValueHashMap<IndexFilter, IndexNode>(){

            @Override
            public synchronized IndexNode get(Object key) {
                IndexNode result = (IndexNode)super.get(key);
                if (result == null) {
                    IndexNode newValue = new IndexNode(new IndexImpl((IndexFilter)key, IndexNode.this.index));
                    this.put((IndexFilter)key, newValue);
                    return newValue;
                }
                return result;
            }
        };

        IndexNode(Index<T> index) {
            this.index = index;
        }

        Index<T> getIndex(List<IndexFilter> filters) {
            if (filters.isEmpty()) {
                return this.index;
            }
            return this.children.get(filters.get(0)).getIndex(filters.subList(1, filters.size()));
        }

        public void add(T generic) {
            if (this.index.add(generic)) {
                this.children.values().forEach(childNode -> childNode.add(generic));
            }
            this.cleanUp();
        }

        public boolean remove(T generic) {
            boolean result = this.index.remove(generic);
            if (result) {
                this.children.values().forEach(childNode -> childNode.remove(generic));
            }
            this.cleanUp();
            return result;
        }

        private void cleanUp() {
            List<IndexFilter> removes = new ArrayList(this.children.keySet()).stream().filter(key -> !key.isAlive()).collect(Collectors.toList());
            removes.forEach(key -> this.children.remove(key));
        }
    }

    private static interface Index<T> {
        public boolean add(T var1);

        public boolean remove(T var1);

        public Iterator<T> iterator();

        public Stream<T> stream();
    }
}

