/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.ServerWebSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.genericsystem.common.AbstractBackEnd;
import org.genericsystem.common.GSVertx;
import org.genericsystem.common.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketsServer {
    protected static Logger log = LoggerFactory.getLogger(AbstractWebSocketsServer.class);
    private List<HttpServer> httpServers = new ArrayList<HttpServer>();
    private final int port;
    private final String host;

    public AbstractWebSocketsServer(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public abstract Handler<Buffer> getHandler(String var1, ServerWebSocket var2);

    public abstract Handler<Void> getCloseHandler(ServerWebSocket var1);

    public abstract void addHttpHandler(HttpServer var1);

    public void start() {
        log.info("Generic System Server is starting...!");
        Vertx vertx = GSVertx.vertx().getVertx();
        for (int i = 0; i < 2 * Runtime.getRuntime().availableProcessors(); ++i) {
            HttpServer httpServer = vertx.createHttpServer(new HttpServerOptions().setPort(this.port).setHost(this.host));
            httpServer.websocketHandler(webSocket -> {
                String path = webSocket.path();
                webSocket.handler(this.getHandler(path, (ServerWebSocket)webSocket));
                webSocket.exceptionHandler(e -> {
                    log.error("Exception on websocket.", e);
                    throw new IllegalStateException((Throwable)e);
                });
                webSocket.closeHandler(this.getCloseHandler((ServerWebSocket)webSocket));
            });
            this.addHttpHandler(httpServer);
            AbstractBackEnd.synchronizeTask(handler -> httpServer.listen(handler));
            this.httpServers.add(httpServer);
        }
    }

    public void stop(Map<String, Root> roots) {
        log.info("Generic System Server is stopping...");
        this.httpServers.forEach(httpServer -> {
            Void cfr_ignored_0 = (Void)AbstractBackEnd.synchronizeTask(handler -> httpServer.close(handler));
        });
        roots.values().forEach(root -> root.close());
        roots = null;
        log.info("Generic System Server is stopped");
    }
}

