/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.reactivex.Observable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.api.tools.Memoizer;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Checker;
import org.genericsystem.common.Generic;
import org.genericsystem.common.IDifferential;
import org.genericsystem.common.PseudoConcurrentCollection;
import org.genericsystem.defaults.DefaultGeneric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Differential
implements IDifferential<Generic> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final IDifferential<Generic> subDifferential;
    protected final PseudoConcurrentCollection<Generic> adds = new PseudoConcurrentCollection();
    protected final PseudoConcurrentCollection<Generic> removes = new PseudoConcurrentCollection();
    private Function<Generic, Observable<Generic>> addsM = Memoizer.memoize(generic -> Observable.merge(this.getSubDifferential().getAdds((Generic)generic), this.adds.getFilteredAdds(arg_0 -> ((Generic)generic).isDirectAncestorOf(arg_0)), this.removes.getFilteredRemoves(arg_0 -> ((Generic)generic).isDirectAncestorOf(arg_0))).share());
    private Function<Generic, Observable<Generic>> remsM = Memoizer.memoize(generic -> Observable.merge(this.getSubDifferential().getRemovals((Generic)generic), this.removes.getFilteredAdds(arg_0 -> ((Generic)generic).isDirectAncestorOf(arg_0)), this.adds.getFilteredRemoves(arg_0 -> ((Generic)generic).isDirectAncestorOf(arg_0))).share());
    private final Function<Generic, Snapshot<Generic>> getDepsM = Memoizer.memoize(generic -> new Snapshot<Generic>(){
        private Observable addsObs;
        private Observable removalsObs;
        {
            this.addsObs = Differential.this.getDifferentialObservable().switchMap(diff -> diff.getAdds(generic).filter(g -> Differential.this.getCache().isAlive((DefaultGeneric)g))).share();
            this.removalsObs = Differential.this.getDifferentialObservable().switchMap(diff -> diff.getRemovals(generic).filter(g -> !Differential.this.getCache().isAlive((DefaultGeneric)g))).share();
        }

        public Generic get(Object o) {
            Generic result = Differential.this.adds.get(o);
            if (result != null) {
                return generic.isDirectAncestorOf(result) ? result : null;
            }
            return !Differential.this.removes.contains(o) ? (Generic)Differential.this.subDifferential.getDependencies(generic).get(o) : null;
        }

        public Stream<Generic> unfilteredStream() {
            return Stream.concat(Differential.this.adds.contains(generic) ? Stream.empty() : Differential.this.subDifferential.getDependencies(generic).filter(new IndexFilter(FiltersBuilder.NOT_CONTAINED_IN_PARAM, new Object[]{Differential.this.removes.toSet()})).stream(), Differential.this.adds.filter(new IndexFilter(FiltersBuilder.IS_DIRECT_DEPENDENCY_OF, new Object[]{generic})).stream());
        }

        public Snapshot<Generic> filter(List<IndexFilter> filters) {
            ArrayList<IndexFilter> filters_ = new ArrayList<IndexFilter>(filters);
            filters_.add(new IndexFilter(FiltersBuilder.NOT_CONTAINED_IN_PARAM, new Object[]{Differential.this.removes.toSet()}));
            return super.filter(filters_);
        }

        public Observable<Generic> getAdds() {
            return this.addsObs;
        }

        public Observable<Generic> getRemovals() {
            return this.removalsObs;
        }
    });

    public Differential(IDifferential<Generic> subDifferential) {
        this.subDifferential = subDifferential;
    }

    public Stream<Generic> getLivingToRespawn() {
        return this.adds.stream().filter(g -> g.getTs() == Long.MAX_VALUE && g.isAlive());
    }

    public PseudoConcurrentCollection<Generic> getAdds() {
        return this.adds;
    }

    public IDifferential<Generic> getSubDifferential() {
        return this.subDifferential;
    }

    @Override
    public AbstractCache getCache() {
        return this.subDifferential.getCache();
    }

    public int getCacheLevel() {
        return this.subDifferential instanceof Differential ? ((Differential)this.subDifferential).getCacheLevel() + 1 : 0;
    }

    public IntegerProperty getCacheLevelObservable() {
        return this.subDifferential instanceof Differential ? new SimpleIntegerProperty(((Differential)this.subDifferential).getCacheLevel() + 1) : new SimpleIntegerProperty(0);
    }

    @Override
    public Observable<Differential> getDifferentialObservable() {
        return this.subDifferential.getDifferentialObservable();
    }

    void checkConstraints(Checker checker) throws RollbackException {
        this.adds.forEach(x -> checker.checkAfterBuild(true, true, (Generic)x));
        this.removes.forEach(x -> checker.checkAfterBuild(false, true, (Generic)x));
    }

    protected Generic plug(Generic generic) {
        this.adds.add(generic);
        return generic;
    }

    protected void unplug(Generic generic) {
        if (!this.adds.remove(generic)) {
            this.removes.add(generic);
        }
    }

    @Override
    public Snapshot<Generic> getDependencies(Generic generic) {
        return this.getDepsM.apply(generic);
    }

    void apply() throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        this.getSubDifferential().apply(this.removes, this.adds);
    }

    @Override
    public void apply(Snapshot<Generic> removes, Snapshot<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        this.removes.disableInvalidations();
        this.adds.disableInvalidations();
        for (Generic generic : removes) {
            this.unplug(generic);
        }
        for (Generic generic : adds) {
            this.plug(generic);
        }
        this.removes.enableInvalidations();
        this.adds.enableInvalidations();
    }

    public void unApply() {
        this.adds.forEach(add -> this.adds.remove((Generic)add));
        this.removes.forEach(rem -> this.removes.remove((Generic)rem));
    }

    @Override
    public long getTs() {
        return this.getSubDifferential().getTs();
    }

    @Override
    public Observable<Generic> getAdds(Generic generic) {
        return this.addsM.apply(generic);
    }

    @Override
    public Observable<Generic> getRemovals(Generic generic) {
        return this.remsM.apply(generic);
    }
}

