/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.genericsystem.common.Vertex;
import org.genericsystem.defaults.DefaultGeneric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statics {
    private static Logger log = LoggerFactory.getLogger(Statics.class);
    private static ThreadLocal<Long> threadDebugged = new ThreadLocal();
    public static final String ENGINE_VALUE = "Engine";
    public static final long MILLI_TO_NANOSECONDS = 1000000L;
    public static final int ATTEMPT_SLEEP = 15;
    public static final int ATTEMPTS = 50;
    public static final int HTTP_ATTEMPTS = 1;
    public static final long CONCURRENCY_CONTROL_EXCEPTION = -1L;
    public static final long OTHER_EXCEPTION = -2L;
    public static final long ROLLBACK_EXCEPTION = -1L;
    public static final long GARBAGE_PERIOD = 1000L;
    public static final long GARBAGE_INITIAL_DELAY = 1000L;
    public static final long LIFE_TIMEOUT = 1386174608777L;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_PORT = 8080;
    public static final int ENGINES_DEFAULT_PORT = 8082;
    public static final Vertex[] EMPTY = new Vertex[0];
    public static final long SERVER_TIMEOUT = 1000L;
    public static final TimeUnit SERVER_TIMEOUT_UNIT = TimeUnit.MILLISECONDS;

    public static void debugCurrentThread() {
        threadDebugged.set(System.currentTimeMillis());
    }

    public static void stopDebugCurrentThread() {
        threadDebugged.remove();
    }

    public static boolean isCurrentThreadDebugged() {
        return threadDebugged.get() != null;
    }

    public static void logTimeIfCurrentThreadDebugged(String message) {
        if (Statics.isCurrentThreadDebugged()) {
            log.info("{} : {}", (Object)message, (Object)(System.currentTimeMillis() - threadDebugged.get()));
        }
    }

    public static class Supers<T extends DefaultGeneric<T>>
    extends ArrayList<T> {
        private static final long serialVersionUID = 6163099887384346235L;

        public Supers(List<T> adds) {
            adds.forEach(this::add);
        }

        public Supers(List<T> adds, T lastAdd) {
            this(adds);
            this.add(lastAdd);
        }

        public Supers(List<T> adds, List<T> otherAdds) {
            this(adds);
            otherAdds.forEach(this::add);
        }

        @Override
        public boolean add(T candidate) {
            for (DefaultGeneric element : this) {
                if (!element.inheritsFrom(candidate)) continue;
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!candidate.inheritsFrom((DefaultGeneric)it.next())) continue;
                it.remove();
            }
            return super.add(candidate);
        }
    }
}

