/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EnginesDeploymentConfig
extends JsonObject {
    public EnginesDeploymentConfig() {
        this("0.0.0.0", 8082);
    }

    public EnginesDeploymentConfig(String host, int port) {
        this.put("engines", new JsonObject());
        this.put("host", host);
        this.put("port", port);
    }

    public EnginesDeploymentConfig addEngine(String path, String persistentDirectoryPath, Class<?> ... classes) {
        if (this.getJsonObject("engines").getJsonObject(path) != null) {
            throw new IllegalStateException("Path already exists : " + path);
        }
        this.getJsonObject("engines").put(path, (JsonObject)new EngineDeploymentConfig(persistentDirectoryPath, classes));
        return this;
    }

    public Set<String> getEnginePaths() {
        return this.getJsonObject("engines").getMap().keySet();
    }

    public String getHost() {
        return this.getString("host");
    }

    public int getPort() {
        return this.getInteger("port");
    }

    public String toString() {
        return this.encodePrettily();
    }

    public List<Class<?>> getClasses(String path) {
        return new EngineDeploymentConfig(this.getJsonObject("engines").getJsonObject(path).getMap()).getClasses();
    }

    public String getPersistentDirectoryPath(String path) {
        return new EngineDeploymentConfig(this.getJsonObject("engines").getJsonObject(path).getMap()).getPersistentDirectoryPath();
    }

    public static class DefaultPathSingleEngineDeployment
    extends EnginesDeploymentConfig {
        public DefaultPathSingleEngineDeployment(Class<?> ... classes) {
            this((String)null, classes);
        }

        public DefaultPathSingleEngineDeployment(String persistentDirectoryPath, Class<?> ... classes) {
            this.addEngine("/", persistentDirectoryPath, classes);
        }
    }

    public static class EngineDeploymentConfig
    extends JsonObject {
        protected EngineDeploymentConfig(Map<String, Object> map) {
            super(map);
        }

        public EngineDeploymentConfig(String persistentDirectoryPath, Class<?> ... classes) {
            super.put("persistenceDirectoryPath", persistentDirectoryPath);
            super.put("classes", new JsonArray());
            this.addClasses(classes);
        }

        public EngineDeploymentConfig addClasses(Class<?> ... classes) {
            for (Class<?> clazz : classes) {
                super.getJsonArray("classes").add(clazz.getName());
            }
            return this;
        }

        public List<Class<?>> getClasses() {
            return this.getJsonArray("classes").getList().stream().map(className -> {
                try {
                    return Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
        }

        public String getPersistentDirectoryPath() {
            return super.getString("persistenceDirectoryPath");
        }
    }
}

