/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.common;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.genericsystem.common.AbstractWebSocketsServer;
import org.genericsystem.common.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackEnd {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Map<String, Root> roots = new HashMap<String, Root>();
    protected AbstractWebSocketsServer webSocketsServer;

    public AbstractBackEnd(String host, int port) {
        this.webSocketsServer = this.buildWebSocketsServer(host, port);
    }

    protected abstract AbstractWebSocketsServer buildWebSocketsServer(String var1, int var2);

    public void start() {
        this.webSocketsServer.start();
    }

    public void stop() {
        this.webSocketsServer.stop(this.roots);
    }

    public AbstractWebSocketsServer getwebSocket() {
        return this.webSocketsServer;
    }

    public Map<String, Root> getRoots() {
        return this.roots;
    }

    public static <T> T synchronizeTask(Handler<Handler<AsyncResult<T>>> consumer) {
        ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(1);
        consumer.handle(res -> {
            try {
                blockingQueue.put(res);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted exception.", (Throwable)e);
            }
        });
        AsyncResult res2 = null;
        try {
            res2 = (AsyncResult)blockingQueue.take();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted exception.", (Throwable)e);
        }
        if (res2.failed()) {
            throw new IllegalStateException(res2.cause());
        }
        return (T)res2.result();
    }
}

