/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.AnnotationLiteral;
import org.genericsystem.api.core.annotations.SystemGeneric;
import org.genericsystem.cdi.Engine;
import org.genericsystem.cdi.UserClassesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class StartupBean
implements Extension {
    private final Logger log = LoggerFactory.getLogger(StartupBean.class);

    public void onStartup(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        this.log.info("------------------start initialization-----------------------");
        UserClassesProvider userClasses = StartupBean.getBean(UserClassesProvider.class, beanManager);
        Set beans = beanManager.getBeans(Object.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        for (Bean bean : beans) {
            Class classToProvide;
            Class clazz = bean.getBeanClass();
            if (!(clazz instanceof Class) || (classToProvide = clazz).getAnnotation(SystemGeneric.class) == null) continue;
            this.log.info("Generic System: providing " + classToProvide);
            userClasses.addUserClasse(classToProvide);
        }
        StartupBean.getBean(Engine.class, beanManager);
        this.log.info("-------------------end initialization------------------------");
    }

    public static <T> T getBean(Class<T> clazz, BeanManager beanManager) {
        Bean bean = beanManager.resolve(beanManager.getBeans(clazz, new Annotation[0]));
        return (T)beanManager.getReference(bean, clazz, beanManager.createCreationalContext((Contextual)bean));
    }
}

