/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cdi;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.genericsystem.cdi.Vertex;
import org.genericsystem.concurrency.GarbageCollector;
import org.genericsystem.concurrency.IEngine;
import org.genericsystem.concurrency.IRoot;

public class Root
extends Vertex
implements IRoot<Vertex, Root> {
    private final TsGenerator generator = new TsGenerator();
    private final IEngine<?, ?, Vertex, Root> engine;
    private final GarbageCollector<Vertex, Root> garbageCollector;

    Root(IEngine<?, ?, Vertex, Root> engine, Serializable value) {
        this.init(false, null, Collections.emptyList(), value, Collections.emptyList());
        this.engine = engine;
        long ts = this.pickNewTs();
        this.restore(ts, 0L, 0L, Long.MAX_VALUE);
        this.garbageCollector = new GarbageCollector((IRoot)this);
    }

    public Root getRoot() {
        return this;
    }

    public Root getAlive() {
        return this;
    }

    public boolean isRoot() {
        return true;
    }

    public long pickNewTs() {
        return this.generator.pickNewTs();
    }

    public IEngine<?, ?, Vertex, Root> getEngine() {
        return this.engine;
    }

    public GarbageCollector<Vertex, Root> getGarbageCollector() {
        return this.garbageCollector;
    }

    static class TsGenerator {
        private final long startTime = System.currentTimeMillis() * 1000000L - System.nanoTime();
        private final AtomicLong lastTime = new AtomicLong(0L);

        TsGenerator() {
        }

        long pickNewTs() {
            long current;
            long nanoTs;
            while ((nanoTs = this.startTime + System.nanoTime()) - (current = this.lastTime.get()) <= 0L || !this.lastTime.compareAndSet(current, nanoTs)) {
            }
            return nanoTs;
        }
    }
}

