/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cdi;

import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.genericsystem.cdi.Engine;
import org.genericsystem.cdi.GenericSystem;
import org.genericsystem.cdi.PersistentDirectoryProvider;
import org.genericsystem.cdi.UserClassesProvider;
import org.genericsystem.cdi.event.EventLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EngineProvider {
    protected static Logger log = LoggerFactory.getLogger(EngineProvider.class);
    private transient Engine engine;
    @Inject
    private UserClassesProvider userClassesProvider;
    @Inject
    private PersistentDirectoryProvider persistentDirectoryProvider;
    @Inject
    private EventLauncher eventLauncher;

    @PostConstruct
    public void init() {
        log.info("$$$$$$$$$$$$$$ START GS ENGINE V3 $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
        String logo = "\n";
        logo = logo + "____________________________________________________________________________________________________________\n";
        logo = logo + "|___________________________________________________________________________________________________________|\n";
        logo = logo + "|___________________________________________________________________________________________________________|\n";
        logo = logo + "|____________|         ____                      _      ____             __                  /______________|\n";
        logo = logo + "|____________|        / ___)___  _  _____  ___  /_)__  / ___)_  __ ___  / /  ___  ____      /_______________|\n";
        logo = logo + "|____________|       / /___/ __)/ \\/ / __)/ _ )/ |/ _)/___ \\/ \\/  ) __)/___)/ __)/    )    /________________|\n";
        logo = logo + "|____________|      / /_  / __)/    / __)/   \\/  / /_ ___/ /\\    (__  / /_ / __)/ / / /   /_________________|\n";
        logo = logo + "|____________|      \\____(____(_/\\_(____(_/\\_(__(____(____/  \\  (____(____(____(_/_/_/   /__________________|\n";
        logo = logo + "|____________|                                               /_/                        /___________________|\n";
        logo = logo + "|____________|_________________________________________________________________________/____________________|\n";
        logo = logo + "|___________________________________________________________________________________________________________|\n";
        logo = logo + "|___________________________________________________________________________________________________________|  \n";
        log.info(logo);
        log.info("-----------------------------------------------------------------------------------------------");
        log.info("-  directory path : " + this.persistentDirectoryProvider.getDirectoryPath());
        log.info("-  userClasses : " + Arrays.toString(this.userClassesProvider.getUserClassesArray()));
        log.info("-----------------------------------------------------------------------------------------------");
        this.engine = GenericSystem.newPersistentEngine(this.persistentDirectoryProvider.getDirectoryPath(), this.userClassesProvider.getUserClassesArray());
    }

    @Produces
    public Engine getEngine() {
        return this.engine;
    }

    @PreDestroy
    public void destroy() {
        this.eventLauncher.launchStopEvent();
        log.info("$$$$$$$$$$$$$$ STOP GS ENGINE $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
        this.engine = null;
    }
}

