/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cdi;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.genericsystem.cache.AbstractContext;
import org.genericsystem.cache.GenericsCache;
import org.genericsystem.cdi.Cache;
import org.genericsystem.cdi.Generic;
import org.genericsystem.cdi.Root;
import org.genericsystem.cdi.Vertex;
import org.genericsystem.concurrency.IEngine;
import org.genericsystem.concurrency.Transaction;
import org.genericsystem.impl.AbstractGeneric;
import org.genericsystem.impl.SystemCache;
import org.genericsystem.kernel.AbstractVertex;

public class Engine
extends Generic
implements IEngine<Generic, Engine, Vertex, Root> {
    private final ThreadLocal<Cache> cacheLocal = new ThreadLocal();
    private final GenericsCache<Generic> genericsCache = new GenericsCache();
    private final SystemCache<Generic> systemCache = new SystemCache((AbstractGeneric)this);
    private final Root root;

    public Engine(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Engine(Serializable engineValue, Class<?> ... userClasses) {
        this.init(false, null, Collections.emptyList(), engineValue, Collections.emptyList());
        this.root = this.buildRoot(engineValue);
        Cache cache = this.newCache().start();
        Generic metaAttribute = (Generic)this.setInstance((AbstractVertex)this, this.getValue(), this.coerceToTArray(new Object[]{this}));
        ((Generic)this.setInstance((Serializable)((Object)AbstractVertex.SystemMap.class), this.coerceToTArray(new Object[]{this}))).enablePropertyConstraint();
        metaAttribute.disableReferentialIntegrity(0);
        for (Class<?> clazz : userClasses) {
            this.systemCache.set(clazz);
        }
        cache.flushAndUnmount();
    }

    Root buildRoot(Serializable value) {
        return new Root(this, (Serializable)((Object)"Engine"));
    }

    public Cache buildCache(AbstractContext<Generic, Engine, Vertex, Root> subContext) {
        return new Cache(subContext);
    }

    public Cache newCache() {
        return new Cache((AbstractContext<Generic, Engine, Vertex, Root>)new Transaction((IEngine)this.getRoot()));
    }

    public Root unwrap() {
        return this.root;
    }

    public Generic getOrBuildT(Class<?> clazz, boolean throwExistException, Generic meta, List<Generic> supers, Serializable value, List<Generic> components) {
        return (Generic)this.genericsCache.getOrBuildT(clazz, throwExistException, (org.genericsystem.cache.AbstractGeneric)meta, supers, value, components);
    }

    public Cache start(org.genericsystem.cache.Cache<Generic, Engine, Vertex, Root> cache) {
        if (!this.equals(cache.getEngine())) {
            throw new IllegalStateException();
        }
        this.cacheLocal.set((Cache)cache);
        return (Cache)cache;
    }

    public void stop(org.genericsystem.cache.Cache<Generic, Engine, Vertex, Root> cache) {
        assert (this.cacheLocal.get() == cache);
        this.cacheLocal.set(null);
    }

    public Cache getCurrentCache() {
        Cache currentCache = this.cacheLocal.get();
        if (currentCache == null) {
            throw new IllegalStateException("Unable to find the current cache. Did you miss to call start() method on it ?");
        }
        return currentCache;
    }

    public <subT extends Generic> subT find(Class<subT> clazz) {
        return (subT)((Object)((Generic)((Object)this.systemCache.get(clazz))));
    }

    public boolean isRoot() {
        return true;
    }

    public Engine getRoot() {
        return this;
    }

    public Engine getAlive() {
        return this;
    }

    static class TsGenerator {
        private final long startTime = System.currentTimeMillis() * 1000000L - System.nanoTime();
        private final AtomicLong lastTime = new AtomicLong(0L);

        TsGenerator() {
        }

        long pickNewTs() {
            long current;
            long nanoTs;
            while ((nanoTs = this.startTime + System.nanoTime()) - (current = this.lastTime.get()) <= 0L || !this.lastTime.compareAndSet(current, nanoTs)) {
            }
            return nanoTs;
        }
    }
}

