/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cdi;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.genericsystem.cdi.Cache;
import org.genericsystem.cdi.Engine;

@SessionScoped
public class CacheProvider
implements Serializable {
    private static final long serialVersionUID = 5201003234496546928L;
    @Inject
    private transient Engine engine;
    private transient Cache currentCache;

    @PostConstruct
    public void init() {
        this.currentCache = this.engine.newCache();
    }

    public void mountNewCache() {
        this.currentCache = this.currentCache.mountNewCache();
    }

    public void flushCurrentCache() {
        this.currentCache = this.currentCache.flushAndUnmount();
    }

    public void discardCurrentCache() {
        this.currentCache = this.currentCache.clearAndUnmount();
    }

    @Produces
    public Cache getCurrentCache() {
        return this.currentCache;
    }

    public void setCurrentCache(Cache cache) {
        this.currentCache = cache;
    }

    @PreDestroy
    public void preDestroy() {
        this.currentCache = null;
    }
}

